package kr.gui;


import java.awt.Color;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;

import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Track;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.Timer;


import kr.gui.kreventgraph.KREventGraph;
import kr.gui.metrodome.MetrodomeGraph;
import kr.gui.midigraph.MidiTuneGraph;
import kr.miditunemodel.MidiTuneModel;
import kr.util.MidiUtils;
import kr.util.audio.AudioClip;
import kr.util.audio.MidiAudioClip;
import kr.util.audio.MidiSongAudioClip;
import kr.util.sample.SampleManager;

public class KRViewer extends JFrame implements Runnable {
	private Model m;
	private KRController cont;
	MidiTuneGraph mg;
	private MidiTextGraph mtg;
	private AudioGraph vocalsGraph;
	private AudioGraph bkgGraph;
	private TimePanel timePanel;
	private Object filesPanel;
	private KRGainPanel gainControlPanel;
	private KRGainPanel midiFileControlPanel;
	private MidiChooserPanel midiChooserPanel;
	private KREventGraph krEventGraph;
	private MetrodomeGraph metrodomeGraph;
	private KRStatusPanel statusPanel;

	public KRViewer(Model m) {
		setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
		setTitle("KR Maker");
		this.m = m;
		cont = new KRController(m);
		KRViewerController viewerController = new KRViewerController();
		viewerController.init(this, m);
		
	}
	
	public void run()
	{
		Container content = getContentPane();
		content.setBackground(Color.LIGHT_GRAY);
		content.setLayout(new GridBagLayout());
		GridBagConstraints c = new GridBagConstraints();

		c.insets = new Insets(0,0,1,1);
		c.gridx = c.gridy = 0;
		c.weightx = c.weighty = 1;
		c.fill = c.BOTH;
		mg = new MidiTuneGraph(m.getGuiModel(), m.getMidiModel(), cont.getMidiGraphController(),m.getAudioModel());
		content.add(mg, c);

		c.gridy++;
		
		c.weighty = 0.1;
		metrodomeGraph = new MetrodomeGraph(m.getGuiModel(), m.getMidiFileModel().getMidiTuneModel(), 
				cont.getMetrodomeGraphController());		
		content.add(metrodomeGraph, c);

		c.gridy++;
		c.weighty = 0;
		mtg = new MidiTextGraph(m.getGuiModel(), m.getMidiModel(), cont.getMidiTextGraphController());
		content.add(mtg, c);

		/*c.gridy++;
		c.weighty = 0;
		vocalsGraph = new AudioGraph(m.getVocalsModel(), cont.getVocalsController());
		content.add(vocalsGraph, c);*/

		c.gridy++;
		c.weighty = .25;
		vocalsGraph = new AudioGraph(m.getGuiModel(), m.getAudioModel().getVocalsChannel(), cont.getVocalsController(),
				m.getAudioModel());
		content.add(vocalsGraph, c);
		
		c.gridy++;
		c.weighty = .25;
		bkgGraph = new AudioGraph(m.getGuiModel(), m.getAudioModel().getBkgChannel(), cont.getBkgController(),
				m.getAudioModel());
		content.add(bkgGraph, c);
		
		c.gridy++;
		
		c.weighty = 0;
		krEventGraph = new KREventGraph(m.getGuiModel(), m.getMidiModel(), cont.getKRGraphController());		
		content.add(krEventGraph, c);

		c.gridy++;
		
		/*c.weighty = 0;
		miscSettingsPanel = new MiscSettingsPanel(m, cont.getMiscSettingsController());		
		content.add(miscSettingsPanel, c);

		c.gridy++;*/
		
		c.weighty = 0;
		timePanel = new TimePanel(m, cont.getTimeController());		
		content.add(timePanel, c);

		c.gridy++;
		
		c.weighty = 0;
		gainControlPanel = new KRGainPanel(m.getGuiModel());		
		content.add(gainControlPanel, c);

		c.gridy++;
		
		c.weighty = 0;
		statusPanel = new KRStatusPanel();		
		content.add(statusPanel, c);

		/*c.gridy++;
		c.weighty = 0;
		midiChooserPanel = new MidiChooserPanel(m.getMidiFileModel(), cont.getMidiChooserController());		
		content.add(midiChooserPanel, c);

		c.weighty = 0;
		c.gridy++;
		
		filesPanel = new FilePanel(m.getFileModel(), cont.getFileController());*/
		
		KRMenuBar bar = new KRMenuBar(m, cont.getMenuController(),this);
		
		setJMenuBar(bar);
		
		//pack();
		setSize(800, 600);
		setVisible(true);
	
		SamplePlayController sampleController = cont.getSamplePlayController();
		sampleController.init(m, m.getGuiModel());
		
	}

}

class KRViewerTest
{
	public static void main(String []args) throws Exception
	{
		Model m = new Model();
		
		System.out.println("hi everybody");
		
		//
		// Read midi stuff
		//
		/*Sequence sequence = null;
		File file = new File(args[0]);

		sequence = MidiSystem.getSequence(file);

		Track [] tracks = sequence.getTracks();
		
		m.getMidiModel().readTune(sequence, tracks[1], tracks[1], (byte)0, (byte)1);
		m.getMidiModel().readKREvents(sequence, tracks[2]);*/
		
		//long micros = MidiUtils.tick2microsecond(sequence, 5, null);
		
		//
		// Read sampled sound
		//
		
		if(args.length > 1)
		{
			File sample = new File(args[1]);
			
			SampleManager sm = new SampleManager();
			AudioClip clip = sm.getData(sample);
			
			//MidiAudioClip clip = new MidiAudioClip(48000);
			//clip.playFreq(100.);
			
			//MidiSongAudioClip midi = new MidiSongAudioClip(48000, m.getMidiFileModel().getMidiTuneModel());
			
			m.getAudioModel().setBkgClip(clip);
			//m.getAudioModel().setVocalsClip(midi);
		}
		
		//
		// Show the viewer
		//
		KRViewer k = new KRViewer(m);
		
		javax.swing.SwingUtilities.invokeLater(k);
	}
}

