package kr.gui;

import kr.gui.kreventgraph.KREventGraphController;
import kr.gui.metrodome.MetrodomeGraphController;
import kr.gui.midigraph.MidiTuneGraphController;
import kr.gui.midigraph.MidiTextGraphController;

public class KRController {
	private TimeController timeController;
	private MidiTuneGraphController midiGraphController;
	private MidiTextGraphController midiTextGraphController;
	private AudioController bkgController, vocalsController;
	private SamplePlayController samplePlayController;
	private MidiPlayController midiPlayController;
	private KRMenuController menuController;
	private KREventGraphController krEventGraphControler;
	private MetrodomeGraphController metrodomeGraphController;
	
	public KRController(Model m)
	{
		this.timeController = new TimeController();
		this.midiGraphController = new MidiTuneGraphController();
		this.midiTextGraphController = new MidiTextGraphController();
		this.vocalsController = new AudioController();
		this.bkgController = new AudioController();
		this.samplePlayController = new SamplePlayController();
		this.midiPlayController = new MidiPlayController();
		this.menuController = new KRMenuController(); 
		this.krEventGraphControler = new KREventGraphController();
		this.metrodomeGraphController = new MetrodomeGraphController();
	}

	public MidiTuneGraphController getMidiGraphController() {
		return midiGraphController;
	}

	public MidiTextGraphController getMidiTextGraphController() {
		return midiTextGraphController;
	}

	public AudioController getVocalsController() {
		return vocalsController;
	}

	public AudioController getBkgController() {
		return bkgController;
	}

	public TimeController getTimeController() {
		return timeController;
	}

	public FileController getFileController() {
		// TODO Auto-generated method stub
		return null;
	}

	public SamplePlayController getSamplePlayController() {
		return samplePlayController;
	}

	public MidiPlayController getMidiPlayController() {
		return midiPlayController;
	}

	public KRMenuController getMenuController() {
		return menuController;
	}

	public KREventGraphController getKRGraphController() {
		return krEventGraphControler;
	}

	public MetrodomeGraphController getMetrodomeGraphController() {
		return metrodomeGraphController;
	}

}
