; XBGM# Win32 Installer
;
;
; Version: MPL 1.1/GPL 2.0/LGPL 2.1
;
; The contents of this file are subject to the Mozilla Public License Version 
; 1.1 (the "License"); you may not use this file except in compliance with 
; the License. You may obtain a copy of the License at 
; http://www.mozilla.org/MPL/
;
; Software distributed under the License is distributed on an "AS IS" basis,
; WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
; for the specific language governing rights and limitations under the
; License.
;
; The Initial Developer of the Original Code is
; Lacroix Francois <kaya@kayaweed.net>.
;
; Alternatively, the contents of this file may be used under the terms of
; either of the GNU General Public License Version 2 or later (the "GPL"),
; or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
; in which case the provisions of the GPL or the LGPL are applicable instead
; of those above. If you wish to allow use of your version of this file only
; under the terms of either the GPL or the LGPL, and not to allow others to
; use your version of this file under the terms of the MPL, indicate your
; decision by deleting the provisions above and replace them with the notice
; and other provisions required by the GPL or the LGPL. If you do not delete
; the provisions above, a recipient may use your version of this file under
; the terms of any one of the MPL, the GPL or the LGPL.
;

; Define your application name
!define APPNAME "XBGM#"
!define APPVERSION "0.9.1.0"
!define APPNAMEANDVERSION "XBGM# 0.9.1.0"
!define SETUPVERSION "0.1"

; Define mono .NET WEB installer
; PROJECT url
!define MONOWEBPATH "ftp://www.go-mono.com/archive/1.1.17.1/windows-installer/2/"
!define MONOWEBFILE "mono-1.1.17.1-gtksharp-2.8.3-win32-2.exe"

; Define Gtk# Win32 Installer for Microsoft .NET
; PROJECT url
!define GTKWEBPATH "http://forge.novell.com/modules/xfcontent/private.php/gtks-inst4win/Win32%20Runtime%20Installer/v2.7.1/"
!define GTKWEBFILE "gtksharp-runtime-2.7.1-win32-0.4.exe"

; Main Install settings
Name "${APPNAMEANDVERSION}"
InstallDir "$PROGRAMFILES\XBGM#"
InstallDirRegKey HKLM "Software\${APPNAME}" ""
OutFile "../xbgmsharp-${APPVERSION}-setup-${SETUPVERSION}.exe"

; Modern interface settings
!include "MUI.nsh"

!define MUI_BrandingText "${APPNAME} Installer v${APPVERSION}"

!define MUI_ABORTWARNING
!define MUI_FINISHPAGE_RUN "$INSTDIR\xbgmsharp.bat"
;!define MUI_FINISHPAGE_SHOWREADME "$INSTDIR\README"
;!define MUI_FINISHPAGE_RUN "xbgmsharp.bat"
;!define MUI_FINISHPAGE_SHOWREADME "../README"


!insertmacro MUI_PAGE_WELCOME
!insertmacro MUI_PAGE_LICENSE "../COPYING"
!insertmacro MUI_PAGE_COMPONENTS
!insertmacro MUI_PAGE_DIRECTORY
!insertmacro MUI_PAGE_INSTFILES
!insertmacro MUI_PAGE_FINISH

!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES

; Set languages (first is default language)
!insertmacro MUI_LANGUAGE "English"
!insertmacro MUI_LANGUAGE "French"
!insertmacro MUI_LANGUAGE "Spanish"
!insertmacro MUI_LANGUAGE "German"
!insertmacro MUI_RESERVEFILE_LANGDLL

Function createscriptbatdbg
	;Get mono version 
	ReadRegStr $1 HKEY_LOCAL_MACHINE "SOFTWARE\Novell\Mono" "DefaultCLR"
	IfErrors lbl_erreur lbl_ok
	
	lbl_erreur:
		MessageBox MB_ICONINFORMATION "Mono is not installed"
		Goto lbl_done
		
	lbl_ok:
		ClearErrors
		MessageBox MB_OK "Mono $1 is installed"
    ;ReadRegStr $2 HKEY_LOCAL_MACHINE "SOFTWARE\Novell\Mono\1.1.13.6" "SdkInstallRoot"
	;Get mono version path
    ReadRegStr $2 HKEY_LOCAL_MACHINE "SOFTWARE\Novell\Mono\$1" "SdkInstallRoot"
	MessageBox MB_OK "Mono $1 is installed at: $2"

	FileOpen $0 "$INSTDIR\xbgmsharp.bat" w
	FileWrite $0 "@ECHO OFF"
	FileWriteByte $0  "13"
	FileWriteByte $0  "10"
	FileWrite $0 "SETLOCAL"
	FileWriteByte $0  "13"
	FileWriteByte $0  "10"
	FileWrite $0 'SET PATH=C:\PROGRA~1\Mono-$1\bin;%PATH%'
	FileWriteByte $0  "13"
	FileWriteByte $0  "10"
	FileWrite $0 'SET MONO_PATH=C:\PROGRA~1\Mono-$1\lib'
	FileWriteByte $0  "13"
	FileWriteByte $0  "10"
	FileWrite $0 'SET MONO_CFG_DIR=C:\PROGRA~1\Mono-$1\etc'
	FileWriteByte $0  "13"
	FileWriteByte $0  "10"
	#To make Debug Automatic
	FileWrite $0 '"C:\PROGRA~1\Mono-$1\bin\mono.exe" "xbgmsharp.exe" >debug.txt 2>&1'
	FileWriteByte $0  "13"
	FileWriteByte $0  "10"
	# REM because of debug automatic
	FileWrite $0 'rem monoLaunchW.exe xbgmsharp.exe'
	FileWriteByte $0  "13"
	FileWriteByte $0  "10"
	FileWrite $0 "ENDLOCAL"
	FileWriteByte $0  "13"
	FileWriteByte $0  "10"
	FileClose $0
	#MessageBox MB_OK "$INSTDIR\xbgmsharp.bat"
	Goto Good
	
	lbl_done:
		MessageBox MB_ICONINFORMATION "You need to generate the script file by yourself, Read the FAQ"	

	Good:
FunctionEnd

Function createscriptbat
	;Get mono version 
	ReadRegStr $1 HKEY_LOCAL_MACHINE "SOFTWARE\Novell\Mono" "DefaultCLR"
#	IfErrors goto erreur ok
#	erreur:
#		MessageBox MB_ICONINFORMATION "Mono is not installed"
#	ok:
    ;ReadRegStr $2 HKEY_LOCAL_MACHINE "SOFTWARE\Novell\Mono\1.1.13.6" "SdkInstallRoot"
	;Get mono version path
    ReadRegStr $2 HKEY_LOCAL_MACHINE "SOFTWARE\Novell\Mono\$1" "SdkInstallRoot"
	#MessageBox MB_OK "Mono $1 is installed at: $2"

	FileOpen $0 "$INSTDIR\xbgmsharp.bat" w
	FileWrite $0 "@ECHO OFF"
	FileWriteByte $0  "13"
	FileWriteByte $0  "10"
	FileWrite $0 "SETLOCAL"
	FileWriteByte $0  "13"
	FileWriteByte $0  "10"
	FileWrite $0 'SET PATH="$2\bin";%PATH%'
	FileWriteByte $0  "13"
	FileWriteByte $0  "10"
	FileWrite $0 'SET MONO_PATH="$2\lib"'
	FileWriteByte $0  "13"
	FileWriteByte $0  "10"
	FileWrite $0 'SET MONO_CFG_DIR="$2\etc"'
	FileWriteByte $0  "13"
	FileWriteByte $0  "10"
	FileWrite $0 'rem "$2\bin\mono.exe" "xbgmsharp.exe" %*'
	FileWriteByte $0  "13"
	FileWriteByte $0  "10"
	FileWrite $0 'monoLaunchW.exe xbgmsharp.exe'
	FileWriteByte $0  "13"
	FileWriteByte $0  "10"
	FileWrite $0 "ENDLOCAL"
	FileWriteByte $0  "13"
	FileWriteByte $0  "10"
	FileClose $0
	#MessageBox MB_OK "$INSTDIR\xbgmsharp.bat"
FunctionEnd

Section "XBGM#" Section3

	; Set Section properties
	SectionIn RO
	SetOverwrite on

	; Set Section Files and Shortcuts
	SetOutPath "$INSTDIR\"
	File "..\src\bin\Release\ICSharpCode.SharpZipLib.dll"
        ;Not need anymore i generate the bat file from the version of mono install
        ;File "..\src\bin\Debug\xbgmsharp.bat"

   	;Now use the monoLaunch to avoid the command line windows
	File "..\src\bin\Release\monoLaunchW.exe"

	File "..\src\bin\Release\gtkrc"
	;File "..\src\bin\Release\xbgmsharp.exe"
	File "..\src\bin\Debug\xbgmsharp.exe"
	File "..\README"
	File "..\COPYING"
	
	CreateDirectory "$SMPROGRAMS\XBGM#"

	# Create the file before creating the link
	Call createscriptbatdbg

	;	CreateShortCut "$DESKTOP\xbgmsharp.lnk" "$INSTDIR\xbgmsharp.bat" "1" "$INSTDIR\xbgmsharp.exe" 0
	CreateShortCut "$DESKTOP\XBGM#.lnk" "$INSTDIR\xbgmsharp.bat" "" "$INSTDIR\xbgmsharp.exe"
;	CreateShortCut "$DESKTOP\XBGM#.lnk" "$INSTDIR\xbgmsharp.bat" "" "C:\WINDOWS\explorer.exe" 4
	CreateShortCut "$SMPROGRAMS\XBGM#\XBGM#.lnk" "$INSTDIR\xbgmsharp.bat" "" "$INSTDIR\xbgmsharp.exe"
	CreateShortCut "$SMPROGRAMS\XBGM#\Uninstall.lnk" "$INSTDIR\uninstall.exe"

SectionEnd

Section "Mono & GTK#" Section1

	; Set Section properties
	;SectionIn RO
	SetOverwrite on

  SetOutPath "$INSTDIR"
    ;NSISDL::download /PROXY localhost:9090  "${MONOWEBPATH}${MONOWEBFILE}" "$TEMP\${MONOWEBFILE}"
	NSISDL::download "${MONOWEBPATH}${MONOWEBFILE}" "$TEMP\${MONOWEBFILE}"
    Pop $R0
    StrCmp $R0 "success" doit abortdownload
    abortdownload:
      Abort "Error downloading ${MONOWEBFILE}"
     doit:
	ExecWait "$TEMP\${MONOWEBFILE} /SILENT"
;	ExecWait "$TEMP\${WEBFILE}"
    File /nonfatal /r "$TEMP\${MONOWEBFILE}"
;    done:
      Call createscriptbatdbg
SectionEnd

#Section "GTK#" Section2
#
#	; Set Section properties
#	;SectionIn RO
#	SetOverwrite on
#
#  SetOutPath "$INSTDIR"
#    ;NSISDL::download /PROXY localhost:9090 "${GTKWEBPATH}${GTKWEBFILE}" "$TEMP\${GTKWEBFILE}"
#	NSISDL::download "${GTKWEBPATH}${GTKWEBFILE}" "$TEMP\${GTKWEBFILE}"
#    Pop $R1
#    StrCmp $R1 "success" doit abortdownload
#    abortdownload:
#      Abort "Error downloading ${GTKWEBFILE}"
#     doit:
#	ExecWait "$TEMP\${GTKWEBFILE} /SILENT"
#;	ExecWait "$TEMP\${WEBFILE}"
#    File /nonfatal /r "$TEMP\${GTKWEBFILE}"
#;    done:
#      Call createscriptbat
#SectionEnd

Section -FinishSection

	WriteRegStr HKLM "Software\${APPNAME}" "" "$INSTDIR"
	WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${APPNAME}" "DisplayName" "${APPNAME}"
	WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${APPNAME}" "UninstallString" "$INSTDIR\uninstall.exe"
	WriteUninstaller "$INSTDIR\uninstall.exe"

SectionEnd

; Modern install component descriptions
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
	!insertmacro MUI_DESCRIPTION_TEXT ${Section1} "Download and install the setup version of Mono-1.1.17 and GTK#-2.8.3 directly from the web"
#	!insertmacro MUI_DESCRIPTION_TEXT ${Section2} "Download and install the setup version of GTK#-2.8.3 directly from the web. You need Microsoft .NET Framework to be install. It might get XBGM# unstable"
	!insertmacro MUI_DESCRIPTION_TEXT ${Section3} "Install Xbox Game Manager"
!insertmacro MUI_FUNCTION_DESCRIPTION_END

;Uninstall section
Section Uninstall

	;Remove from registry...
	DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${APPNAME}"
	DeleteRegKey HKLM "SOFTWARE\${APPNAME}"

	; Delete self
	Delete "$INSTDIR\uninstall.exe"

	; Delete Shortcuts
	Delete "$DESKTOP\XBGM#.lnk"
	Delete "$SMPROGRAMS\XBGM#\XBGM#.lnk"
	Delete "$SMPROGRAMS\XBGM#\Uninstall.lnk"

	; Clean up XBGM#
	Delete "$INSTDIR\ICSharpCode.SharpZipLib.dll"
	Delete "$INSTDIR\xbgmsharp.bat"
	Delete "$INSTDIR\xbgmsharp.exe"
	Delete "$INSTDIR\README"
	Delete "$INSTDIR\gtkrc"
	Delete "$INSTDIR\xbgmsharp.exe.manifest"
	Delete "$INSTDIR\monoLaunchW.exe"
	Delete "$INSTDIR\*"
	
	; Clean extra file
	Delete "$PROFILE\xbgmsharp\config.xml"
	Delete "$PROFILE\xbgmsharp\titles.txt"
	Delete "$PROFILE\xbgmsharp\titleimage.zip"
	Delete "$PROFILE\xbgmsharp\titleimage\*"
	
	; Remove remaining directories
	RMDir "$SMPROGRAMS\XBGM#"
	RMDir "$PROFILE\xbgmsharp\titleimage"
	RMDir "$PROFILE\xbgmsharp"
	RMDir "$INSTDIR\"

SectionEnd

; eof
