/*
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org
 *
 * Copyright (C) Eric Farng 2003
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.farng.mp3.object;

/**
 * Title: Description: Copyright:    Copyright (c) 2002 Company:
 *
 * @author Eric Farng
 * @version $Revision: 1.1 $
 */
public class ObjectID3v2LyricLine
    extends AbstractMP3Object {
    /** DOCUMENT ME! */
    String text = "";

    /** DOCUMENT ME! */
    int timeStamp = 0;

    /**
     * Creates a new ObjectID3v2LyricLine object.
     *
     * @param timeStamp DOCUMENT ME!
     * @param text DOCUMENT ME!
     */
    public ObjectID3v2LyricLine(int timeStamp, String text) {
        this.timeStamp = timeStamp;
        this.text      = text;
    }

    /**
     * Creates a new ObjectID3v2LyricLine object.
     *
     * @param arr DOCUMENT ME!
     */
    public ObjectID3v2LyricLine(byte[] arr) {
        readByteArray(arr, 0);
    }

    /**
     * Creates a new ObjectID3v2LyricLine object.
     *
     * @param arr DOCUMENT ME!
     * @param offset DOCUMENT ME!
     */
    public ObjectID3v2LyricLine(byte[] arr, int offset) {
        readByteArray(arr, offset);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public int getSize() {
        return text.length() + 1 + 4;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getText() {
        return text;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public int getTimeStamp() {
        return timeStamp;
    }

    /**
     * DOCUMENT ME!
     *
     * @param obj DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean equals(Object obj) {
        if ((obj instanceof ObjectID3v2LyricLine) == false) {
            return false;
        }

        ObjectID3v2LyricLine object = (ObjectID3v2LyricLine) obj;

        if (this.text.equals(object.text) == false) {
            return false;
        }

        if (this.timeStamp != object.timeStamp) {
            return false;
        }

        return super.equals(obj);
    }

    /**
     * DOCUMENT ME!
     *
     * @param arr DOCUMENT ME!
     * @param offset DOCUMENT ME!
     */
    public void readByteArray(byte[] arr, int offset) {
        offset += (arr.length - 4);

        text = new String(arr);
        text = text.substring(0, text.length() - 5);

        timeStamp = 0;

        for (int i = offset; i < arr.length; i++) {
            timeStamp <<= 8;
            timeStamp += arr[i];
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String toString() {
        return timeStamp + " " + text;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public byte[] writeByteArray() {
        int    i;
        byte[] arr = new byte[getSize()];

        for (i = 0; i < text.length(); i++) {
            arr[i] = (byte) text.charAt(i);
        }

        arr[i++] = 0;
        arr[i++] = (byte) ((timeStamp & 0xFF000000) >> 24);
        arr[i++] = (byte) ((timeStamp & 0x00FF0000) >> 16);
        arr[i++] = (byte) ((timeStamp & 0x0000FF00) >> 8);
        arr[i++] = (byte) (timeStamp & 0x000000FF);

        return arr;
    }
}