/*
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org
 *
 * Copyright (C) Eric Farng 2003
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.farng.mp3.lyrics3;

import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

import org.farng.mp3.InvalidTagException;
import org.farng.mp3.TagConstants;
import org.farng.mp3.TagOptionSingleton;
import org.farng.mp3.id3.FrameBodySYLT;
import org.farng.mp3.id3.FrameBodyUSLT;
import org.farng.mp3.object.ObjectID3v2LyricLine;
import org.farng.mp3.object.ObjectLyrics3Line;
import org.farng.mp3.object.ObjectLyrics3TimeStamp;


/**
 * Title: Description: Copyright:    Copyright (c) 2002 Company:
 *
 * @author Eric Farng
 * @version $Revision: 1.1 $
 */
public class FieldBodyLYR
    extends AbstractLyrics3v2FieldBody {
    /** DOCUMENT ME! */
    private ArrayList lines = new ArrayList();

    /**
     * Creates a new FieldBodyLYR object.
     */
    public FieldBodyLYR() {}

    /**
     * Creates a new FieldBodyLYR object.
     *
     * @param line DOCUMENT ME!
     */
    public FieldBodyLYR(String line) {
        readString(line);
    }

    /**
     * Creates a new FieldBodyLYR object.
     *
     * @param sync DOCUMENT ME!
     */
    public FieldBodyLYR(FrameBodySYLT sync) {
        addLyric(sync);
    }

    /**
     * Creates a new FieldBodyLYR object.
     *
     * @param unsync DOCUMENT ME!
     */
    public FieldBodyLYR(FrameBodyUSLT unsync) {
        addLyric(unsync);
    }

    /**
     * Creates a new FieldBodyLYR object.
     *
     * @param file DOCUMENT ME!
     *
     * @throws InvalidTagException DOCUMENT ME!
     * @throws java.io.IOException DOCUMENT ME!
     */
    public FieldBodyLYR(RandomAccessFile file)
                 throws InvalidTagException, java.io.IOException {
        this.read(file);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getIdentifier() {
        return "LYR";
    }

    /**
     * DOCUMENT ME!
     *
     * @param str DOCUMENT ME!
     */
    public void setLyric(String str) {
        readString(str);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getLyric() {
        return writeString();
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public int getSize() {
        int               size = 0;
        ObjectLyrics3Line line;

        for (int i = 0; i < lines.size(); i++) {
            line = (ObjectLyrics3Line) lines.get(i);
            size += (line.getSize() + 2);
        }

        return size;

        //return size - 2; // cut off the last crlf pair
    }

    /**
     * DOCUMENT ME!
     *
     * @param obj DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean isSubsetOf(Object obj) {
        if ((obj instanceof FieldBodyLYR) == false) {
            return false;
        }

        ArrayList superset = ((FieldBodyLYR) obj).lines;

        for (int i = 0; i < lines.size(); i++) {
            if (superset.contains(lines.get(i)) == false) {
                return false;
            }
        }

        return super.isSubsetOf(obj);
    }

    /**
     * DOCUMENT ME!
     *
     * @param sync DOCUMENT ME!
     */
    public void addLyric(FrameBodySYLT sync) {
        // SYLT frames are made of individual lines
        Iterator             iterator    = sync.iterator();
        boolean              lineExist;
        ObjectLyrics3Line    newLine;
        ObjectID3v2LyricLine currentLine;
        Iterator             lineIter;
        HashMap              lineMap = new HashMap();

        while (iterator.hasNext()) {
            currentLine = (ObjectID3v2LyricLine) iterator.next();

            if (lineMap.containsKey(currentLine.getText())) {
                newLine = (ObjectLyrics3Line) lineMap.get(currentLine.getText());
                newLine.addTimeStamp(new ObjectLyrics3TimeStamp(
                                                                currentLine.getTimeStamp(),
                                                                sync.getTimeStampFormat()));
            } else {
                newLine = new ObjectLyrics3Line(currentLine,
                                                sync.getTimeStampFormat());
                lineMap.put(currentLine.getText(),
                            newLine);
                lines.add(newLine);
            }
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param unsync DOCUMENT ME!
     */
    public void addLyric(FrameBodyUSLT unsync) {
        // USLT frames are just long text string;
        lines.add(new ObjectLyrics3Line(unsync.getLyric()));
    }

    /**
     * DOCUMENT ME!
     *
     * @param obj DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean equals(Object obj) {
        if ((obj instanceof FieldBodyLYR) == false) {
            return false;
        }

        FieldBodyLYR object = (FieldBodyLYR) obj;

        if (this.lines.equals(object.lines) == false) {
            return false;
        }

        return super.equals(obj);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean hasTimeStamp() {
        boolean present = false;

        for (int i = 0; i < lines.size(); i++) {
            if (((ObjectLyrics3Line) lines.get(i)).hasTimeStamp()) {
                present = true;
            }
        }

        return present;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Iterator iterator() {
        return lines.iterator();
    }

    /**
     * DOCUMENT ME!
     *
     * @param file DOCUMENT ME!
     *
     * @throws InvalidTagException DOCUMENT ME!
     * @throws java.io.IOException DOCUMENT ME!
     */
    public void read(RandomAccessFile file)
              throws InvalidTagException, java.io.IOException {
        String lineString;

        byte[] buffer = new byte[5];

        // read the 5 character size
        file.read(buffer, 0, 5);

        int size = Integer.parseInt(new String(buffer, 0, 5));

        if ((size == 0) &&
                (TagOptionSingleton.getInstance()
                     .isLyrics3KeepEmptyFieldIfRead() == false)) {
            throw new InvalidTagException("Lyircs3v2 Field has size of zero.");
        }

        buffer = new byte[size];

        // read the SIZE length description
        file.read(buffer);
        lineString = new String(buffer);
        readString(lineString);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String toString() {
        String str = getIdentifier() + " : ";

        for (int i = 0; i < lines.size(); i++) {
            str += lines.get(i)
                   .toString();
        }

        return str;
    }

    /**
     * DOCUMENT ME!
     *
     * @param file DOCUMENT ME!
     *
     * @throws java.io.IOException DOCUMENT ME!
     */
    public void write(RandomAccessFile file)
               throws java.io.IOException {
        int    size   = 0;
        int    offset = 0;
        byte[] buffer = new byte[5];
        String str    = "";

        size = getSize();
        str  = Integer.toString(size);

        for (int i = 0; i < (5 - str.length()); i++) {
            buffer[i] = (byte) '0';
        }

        offset += (5 - str.length());

        for (int i = 0; i < str.length(); i++) {
            buffer[i + offset] = (byte) str.charAt(i);
        }

        offset += str.length();
        file.write(buffer, 0, 5);

        if (size > 0) {
            str    = writeString();
            buffer = new byte[str.length()];

            for (int i = 0; i < str.length(); i++) {
                buffer[i] = (byte) str.charAt(i);
            }

            file.write(buffer);
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param lineString DOCUMENT ME!
     */
    private void readString(String lineString) {
        // now readString each line and put in the vector;
        String token  = "";
        int    offset = 0;
        int    delim  = lineString.indexOf(TagConstants.CRLF);
        lines = new ArrayList();

        while (delim >= 0) {
            token = lineString.substring(offset, delim);
            lines.add(new ObjectLyrics3Line(token));
            offset = delim + TagConstants.CRLF.length();
            delim  = lineString.indexOf(TagConstants.CRLF, offset);
        }

        if (offset < lineString.length()) {
            token = lineString.substring(offset);
            lines.add(new ObjectLyrics3Line(token));
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    private String writeString() {
        ObjectLyrics3Line line;
        String            str = "";

        for (int i = 0; i < lines.size(); i++) {
            line = (ObjectLyrics3Line) lines.get(i);
            str += (line.writeString() + TagConstants.CRLF);
        }

        return str;

        //return str.substring(0,str.length()-2); // cut off the last CRLF pair
    }
}