/*
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org
 *
 * Copyright (C) Eric Farng 2003
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.farng.mp3.lyrics3;

import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;

import org.farng.mp3.InvalidTagException;
import org.farng.mp3.TagConstants;
import org.farng.mp3.TagOptionSingleton;
import org.farng.mp3.object.ObjectLyrics3Image;


/**
 * Title: Description: Copyright:    Copyright (c) 2002 Company:
 *
 * @author Eric Farng
 * @version $Revision: 1.1 $
 */
public class FieldBodyIMG
    extends AbstractLyrics3v2FieldBody {
    /** DOCUMENT ME! */
    private ArrayList images = new ArrayList();

    /**
     * Creates a new FieldBodyIMG object.
     */
    public FieldBodyIMG() {}

    /**
     * Creates a new FieldBodyIMG object.
     *
     * @param imageString DOCUMENT ME!
     */
    public FieldBodyIMG(String imageString) {
        readString(imageString);
    }

    /**
     * Creates a new FieldBodyIMG object.
     *
     * @param image DOCUMENT ME!
     */
    public FieldBodyIMG(ObjectLyrics3Image image) {
        images.add(image);
    }

    /**
     * Creates a new FieldBodyIMG object.
     *
     * @param file DOCUMENT ME!
     *
     * @throws InvalidTagException DOCUMENT ME!
     * @throws java.io.IOException DOCUMENT ME!
     */
    public FieldBodyIMG(RandomAccessFile file)
                 throws InvalidTagException, java.io.IOException {
        this.read(file);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getIdentifier() {
        return "IMG";
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public int getSize() {
        int                size  = 0;
        ObjectLyrics3Image image;

        for (int i = 0; i < images.size(); i++) {
            image = (ObjectLyrics3Image) images.get(i);
            size += (image.getSize() + 2); // add CRLF pair
        }

        return size - 2; // cut off trailing crlf pair
    }

    /**
     * DOCUMENT ME!
     *
     * @param obj DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean isSubsetOf(Object obj) {
        if ((obj instanceof FieldBodyIMG) == false) {
            return false;
        }

        ArrayList superset = ((FieldBodyIMG) obj).images;

        for (int i = 0; i < images.size(); i++) {
            if (superset.contains(images.get(i)) == false) {
                return false;
            }
        }

        return super.isSubsetOf(obj);
    }

    /**
     * DOCUMENT ME!
     *
     * @param value DOCUMENT ME!
     */
    public void setValue(String value) {
        readString(value);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getValue() {
        return writeString();
    }

    /**
     * DOCUMENT ME!
     *
     * @param image DOCUMENT ME!
     */
    public void addImage(ObjectLyrics3Image image) {
        images.add(image);
    }

    /**
     * DOCUMENT ME!
     *
     * @param obj DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean equals(Object obj) {
        if ((obj instanceof FieldBodyIMG) == false) {
            return false;
        }

        FieldBodyIMG object = (FieldBodyIMG) obj;

        if (this.images.equals(object.images) == false) {
            return false;
        }

        return super.equals(obj);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Iterator iterator() {
        return images.iterator();
    }

    /**
     * DOCUMENT ME!
     *
     * @param file DOCUMENT ME!
     *
     * @throws InvalidTagException DOCUMENT ME!
     * @throws java.io.IOException DOCUMENT ME!
     */
    public void read(RandomAccessFile file)
              throws InvalidTagException, java.io.IOException {
        String imageString;

        byte[] buffer = new byte[5];

        // read the 5 character size
        file.read(buffer, 0, 5);

        int size = Integer.parseInt(new String(buffer, 0, 5));

        if ((size == 0) &&
                (TagOptionSingleton.getInstance()
                     .isLyrics3KeepEmptyFieldIfRead() == false)) {
            throw new InvalidTagException("Lyircs3v2 Field has size of zero.");
        }

        buffer = new byte[size];

        // read the SIZE length description
        file.read(buffer);
        imageString = new String(buffer);
        readString(imageString);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String toString() {
        String str = getIdentifier() + " : ";

        for (int i = 0; i < images.size(); i++) {
            str += (images.get(i)
                    .toString() + " ; ");
        }

        return str;
    }

    /**
     * DOCUMENT ME!
     *
     * @param file DOCUMENT ME!
     *
     * @throws java.io.IOException DOCUMENT ME!
     */
    public void write(RandomAccessFile file)
               throws java.io.IOException {
        int    size   = 0;
        int    offset = 0;
        byte[] buffer = new byte[5];
        String str;

        size = getSize();
        str  = Integer.toString(size);

        for (int i = 0; i < (5 - str.length()); i++) {
            buffer[i] = (byte) '0';
        }

        offset += (5 - str.length());

        for (int i = 0; i < str.length(); i++) {
            buffer[i + offset] = (byte) str.charAt(i);
        }

        offset += str.length();

        file.write(buffer, 0, 5);

        if (size > 0) {
            str    = writeString();
            buffer = new byte[str.length()];

            for (int i = 0; i < str.length(); i++) {
                buffer[i] = (byte) str.charAt(i);
            }

            file.write(buffer);
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param imageString DOCUMENT ME!
     */
    private void readString(String imageString) {
        // now read each picture and put in the vector;
        String token  = "";
        int    offset = 0;
        int    delim  = imageString.indexOf(TagConstants.CRLF);
        images = new ArrayList();

        while (delim >= 0) {
            token = imageString.substring(offset, delim);
            images.add(new ObjectLyrics3Image(token));
            offset = delim + TagConstants.CRLF.length();
            delim  = imageString.indexOf(TagConstants.CRLF, offset);
        }

        if (offset < imageString.length()) {
            token = imageString.substring(offset);
            images.add(new ObjectLyrics3Image(token));
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    private String writeString() {
        String             str   = "";
        ObjectLyrics3Image image;

        for (int i = 0; i < images.size(); i++) {
            image = (ObjectLyrics3Image) images.get(i);
            str += (image.writeString() + TagConstants.CRLF);
        }

        if (str.length() > 2) {
            return str.substring(0, str.length() - 2);
        }

        return str;
    }
}