/*
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org
 *
 * Copyright (C) Eric Farng 2003
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.farng.mp3.id3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;

import org.farng.mp3.InvalidTagException;


/**
 * Title: Description: Copyright:    Copyright (c) 2002 Company:
 *
 * @author Eric Farng
 * @version $Revision: 1.1 $
 */
public class FrameBodyUnsupported
    extends AbstractID3v2FrameBody {
    /** DOCUMENT ME! */
    private String identifier = "";

    /** DOCUMENT ME! */
    private byte[] value;

    /**
     * Creates a new FrameBodyUnsupported object.
     *
     * @param value DOCUMENT ME!
     * @param is6ByteHeader DOCUMENT ME!
     */
    public FrameBodyUnsupported(byte[] value, boolean is6ByteHeader) {
        this.is6ByteHeader = is6ByteHeader;
        this.value         = value;
    }

    /**
     * Creates a new FrameBodyUnsupported object.
     *
     * @param file DOCUMENT ME!
     * @param is6ByteHeader DOCUMENT ME!
     *
     * @throws IOException DOCUMENT ME!
     * @throws InvalidTagException DOCUMENT ME!
     */
    public FrameBodyUnsupported(RandomAccessFile file, boolean is6ByteHeader)
                         throws IOException, InvalidTagException {
        this.is6ByteHeader = is6ByteHeader;
        this.read(file);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getIdentifier() {
        return identifier;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public int getSize() {
        int size = 0;

        if (value != null) {
            size += value.length;
        }

        return size;
    }

    /**
     * DOCUMENT ME!
     *
     * @param obj DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean isSubsetOf(Object obj) {
        if ((obj instanceof FrameBodyUnsupported) == false) {
            return false;
        }

        FrameBodyUnsupported object = (FrameBodyUnsupported) obj;

        String               subset   = new String((byte[]) this.value);
        String               superset = new String((byte[]) object.value);

        if (superset.indexOf(subset) < 0) {
            return false;
        }

        return super.isSubsetOf(obj);
    }

    /**
     * DOCUMENT ME!
     *
     * @param obj DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean equals(Object obj) {
        if ((obj instanceof FrameBodyUnsupported) == false) {
            return false;
        }

        FrameBodyUnsupported object = (FrameBodyUnsupported) obj;

        if (this.identifier.equals(object.identifier) == false) {
            return false;
        }

        if (Arrays.equals(this.value, object.value) == false) {
            return false;
        }

        return super.equals(obj);
    }

    /**
     * DOCUMENT ME!
     *
     * @param file DOCUMENT ME!
     *
     * @throws IOException DOCUMENT ME!
     * @throws InvalidTagException DOCUMENT ME!
     */
    public void read(RandomAccessFile file)
              throws IOException, InvalidTagException {
        int    size;
        byte[] buffer;

        if (is6ByteHeader) {
            // go back and read the 3 byte unsupported identifier;
            file.seek(file.getFilePointer() - 3);
            buffer = new byte[3];
            file.read(buffer);
            identifier = new String(buffer, 0, 3);
        } else {
            // go back and read the 4 byte unsupported identifier;
            file.seek(file.getFilePointer() - 4);
            buffer = new byte[4];
            file.read(buffer);
            identifier = new String(buffer);
        }

        System.out.println("Frame type unsupported : " + identifier);
        size = readHeader(file);

        // read the data
        value = new byte[size];
        file.read(value);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String toString() {
        return "??" + getIdentifier() + " : " + (new String(value));
    }

    /**
     * DOCUMENT ME!
     *
     * @param file DOCUMENT ME!
     *
     * @throws IOException DOCUMENT ME!
     */
    public void write(RandomAccessFile file)
               throws IOException {
        writeHeader(file,
                    this.getSize());
        file.write(value);
    }
}