/*
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org
 *
 * Copyright (C) Eric Farng 2003
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.farng.mp3.id3;

import java.io.IOException;

import org.farng.mp3.InvalidTagException;
import org.farng.mp3.object.ObjectBooleanByte;
import org.farng.mp3.object.ObjectNumberFixedLength;


/**
 * Title: Description: Copyright:    Copyright (c) 2002 Company:
 *
 * @author Eric Farng
 * @version $Revision: 1.1 $
 */
public class FrameBodyRBUF
    extends AbstractID3v2FrameBody {
    /**
     * Creates a new FrameBodyRBUF object.
     */
    public FrameBodyRBUF() {
        //        this.setObject("Buffer Size", new Byte((byte) 0));
        //        this.setObject("Embedded Info Flag", new Boolean(false));
        //        this.setObject("Offset to Next Flag", new Byte((byte) 0));
    }

    /**
     * Creates a new FrameBodyRBUF object.
     *
     * @param bufferSize DOCUMENT ME!
     * @param embeddedInfoFlag DOCUMENT ME!
     * @param offsetToNextTag DOCUMENT ME!
     * @param is6ByteHeader DOCUMENT ME!
     */
    public FrameBodyRBUF(byte bufferSize, boolean embeddedInfoFlag,
                         byte offsetToNextTag, boolean is6ByteHeader) {
        this.setObject("Buffer Size",
                       new Byte(bufferSize));
        this.setObject("Embedded Info Flag",
                       new Boolean(embeddedInfoFlag));
        this.setObject("Offset to Next Flag",
                       new Byte(offsetToNextTag));
        this.is6ByteHeader = is6ByteHeader;
    }

    /**
     * Creates a new FrameBodyRBUF object.
     *
     * @param file DOCUMENT ME!
     * @param is6ByteHeader DOCUMENT ME!
     *
     * @throws IOException DOCUMENT ME!
     * @throws InvalidTagException DOCUMENT ME!
     */
    public FrameBodyRBUF(java.io.RandomAccessFile file, boolean is6ByteHeader)
                  throws IOException, InvalidTagException {
        this.is6ByteHeader = is6ByteHeader;
        this.read(file);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getIdentifier() {
        return "RBUF";
    }

    /**
     * DOCUMENT ME!
     */
    protected void setupObjectList() {
        objectList.add(new ObjectNumberFixedLength("Buffer Size", 3));
        objectList.add(new ObjectBooleanByte("Embedded Info Flag", (byte) 1));
        objectList.add(new ObjectNumberFixedLength("Offset to Next Tag", 4));
    }
}