/*
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org
 *
 * Copyright (C) Eric Farng 2003
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


/**
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org Copyright (C) Eric Farng 2003 This
 * program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version. This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details. You should have received a copy of the GNU
 * General Public License along with this program; if not, write to: Free
 * Software Foundation, Inc. 59 Temple Place, Suite 330 Boston, MA 02111-1307
 * USA
 */
/**
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org Copyright (C) Eric Farng 2003 This
 * program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version. This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details. You should have received a copy of the GNU
 * General Public License along with this program; if not, write to: Free
 * Software Foundation, Inc. 59 Temple Place, Suite 330 Boston, MA 02111-1307
 * USA
 */
package org.farng.mp3.id3;

import java.io.IOException;

import org.farng.mp3.InvalidTagException;
import org.farng.mp3.object.AbstractMP3Object;
import org.farng.mp3.object.ObjectGroupRepeated;
import org.farng.mp3.object.ObjectNumberFixedLength;
import org.farng.mp3.object.ObjectNumberHashMap;
import org.farng.mp3.object.ObjectStringNullTerminated;


/**
 * Title: Description: Copyright:    Copyright (c) 2002 Company:
 *
 * @author Eric Farng
 * @version $Revision: 1.1 $
 */
public class FrameBodyEQU2
    extends AbstractID3v2FrameBody {
    /**
     * Creates a new FrameBodyEQU2 object.
     */
    public FrameBodyEQU2() {
        //        this.setObject("Interpolation Method", new Byte((byte) 0));
        //        this.setObject("Owner", "");
        //        this.addGroup((short) 0, (short) 0);
    }

    /**
     * Creates a new FrameBodyEQU2 object.
     *
     * @param interpolationMethod DOCUMENT ME!
     * @param owner DOCUMENT ME!
     * @param frequency DOCUMENT ME!
     * @param volumeAdjustment DOCUMENT ME!
     * @param is6ByteHeader DOCUMENT ME!
     */
    public FrameBodyEQU2(byte interpolationMethod, String owner,
                         short frequency, short volumeAdjustment,
                         boolean is6ByteHeader) {
        this.setObject("Interpolation Method",
                       new Byte(interpolationMethod));
        this.setObject("Owner", owner);
        this.addGroup(frequency, volumeAdjustment);
        this.is6ByteHeader = is6ByteHeader;
    }

    /**
     * Creates a new FrameBodyEQU2 object.
     *
     * @param file DOCUMENT ME!
     * @param is6ByteHeader DOCUMENT ME!
     *
     * @throws IOException DOCUMENT ME!
     * @throws InvalidTagException DOCUMENT ME!
     */
    public FrameBodyEQU2(java.io.RandomAccessFile file, boolean is6ByteHeader)
                  throws IOException, InvalidTagException {
        this.is6ByteHeader = is6ByteHeader;
        this.read(file);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getIdentifier() {
        return "EQU2" + ((char) 0) + getOwner();
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getOwner() {
        return (String) getObject("Owner");
    }

    /**
     * DOCUMENT ME!
     *
     * @param description DOCUMENT ME!
     */
    public void getOwner(String description) {
        setObject("Owner", description);
    }

    /**
     * DOCUMENT ME!
     *
     * @param frequency DOCUMENT ME!
     * @param volumeAdjustment DOCUMENT ME!
     */
    public void addGroup(short frequency, short volumeAdjustment) {
        ObjectGroupRepeated group  = (ObjectGroupRepeated) this.getObject("Data");
        AbstractMP3Object   freq   = new ObjectNumberFixedLength("Frequency", 2);
        AbstractMP3Object   volume = new ObjectNumberFixedLength("Volume Adjustment",
                                                                 2);
        group.addObject(freq);
        group.addObject(volume);
        this.setObject("Data", group);
    }

    /**
     * DOCUMENT ME!
     */
    protected void setupObjectList() {
        objectList.add(new ObjectNumberHashMap("Interpolation Method", 1));
        objectList.add(new ObjectStringNullTerminated("Owner"));

        ObjectGroupRepeated group = new ObjectGroupRepeated("Data");
        group.addProperty(new ObjectNumberFixedLength("Frequency", 2));
        group.addProperty(new ObjectNumberFixedLength("Volume Adjustment", 2));
        objectList.add(group);
    }
}