/*
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org
 *
 * Copyright (C) Eric Farng 2003
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.farng.mp3.id3;

import java.io.IOException;

import org.farng.mp3.InvalidTagException;
import org.farng.mp3.object.ObjectByteArraySizeTerminated;
import org.farng.mp3.object.ObjectStringNullTerminated;


/**
 * Title: Description: Copyright:    Copyright (c) 2002 Company:
 *
 * @author Eric Farng
 * @version $Revision: 1.1 $
 */
public class FrameBodyCRM
    extends AbstractID3v2FrameBody {
    /**
     * Creates a new FrameBodyCRM object.
     */
    public FrameBodyCRM() {
        //        this.setObject("Owner", "");
        //        this.setObject("Description", "");
        //        this.setObject("Encrypted datablock", new byte[0]);
    }

    /**
     * Creates a new FrameBodyCRM object.
     *
     * @param owner DOCUMENT ME!
     * @param description DOCUMENT ME!
     * @param data DOCUMENT ME!
     * @param is6ByteHeader DOCUMENT ME!
     */
    public FrameBodyCRM(String owner, String description, byte[] data,
                        boolean is6ByteHeader) {
        this.setObject("Owner", owner);
        this.setObject("Description", description);
        this.setObject("Encrypted datablock", data);
        this.is6ByteHeader = is6ByteHeader;
    }

    /**
     * Creates a new FrameBodyCRM object.
     *
     * @param file DOCUMENT ME!
     * @param is6ByteHeader DOCUMENT ME!
     *
     * @throws IOException DOCUMENT ME!
     * @throws InvalidTagException DOCUMENT ME!
     */
    public FrameBodyCRM(java.io.RandomAccessFile file, boolean is6ByteHeader)
                 throws IOException, InvalidTagException {
        this.is6ByteHeader = is6ByteHeader;
        this.read(file);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getIdentifier() {
        return "CRM" + ((char) 0) + getOwner();
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getOwner() {
        return (String) getObject("Owner");
    }

    /**
     * DOCUMENT ME!
     *
     * @param description DOCUMENT ME!
     */
    public void getOwner(String description) {
        setObject("Owner", description);
    }

    /**
     * DOCUMENT ME!
     */
    protected void setupObjectList() {
        objectList.add(new ObjectStringNullTerminated("Owner"));
        objectList.add(new ObjectStringNullTerminated("Description"));
        objectList.add(new ObjectByteArraySizeTerminated("Encrypted datablock"));
    }
}