/// <summary>
/// C# XBGM# Xbox Game Manager.
///  
/// Copyright (C) 2004  KaYa
/// 
/// 
/// This library is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// Bug fixes, suggestions and comments should be sent to xbgm@kayaweed.net
/// 
/// Change Log:
/// 
/// Revision 0.1  2004/07/27 KaYa
/// first release
///
/// </summary>

using System;
using System.Collections;
using System.IO;
using System.Threading;
using Gtk;
using Gdk;
using Xbgm.Xiso;
using Xbgm.Core;

/// <summary>
/// So here is the All GUI in GTK# 
/// There is also oll event_callback for the primary window And xbox Stuff
/// </summary>
namespace Xbgm.Gui
{

/// <summary>
/// So here is the All GUI in GTK# 
/// There is also all event_callback for the primary window And xbox Stuff
/// </summary>
public class MyWindow : Gtk.Window {
		const string VERSION = "0.8";
		const string NAME = "XBGM#";   
		const string WELCOME = ", Copyright (C) 2004-2005 KaYa <xbgm@kayaweed.net>. \nIf you have any questions, comments, or suggestions about this program, please feel free to email them to me. \nYou can always find out the latest news about XBGM# from the official website at http://xbgm.sourceforge.net/.\nXBGM# comes with ABSOLUTELY NO WARRANTY; for details, see the COPYING file. \nThis is free software, and you are welcome to redistribute it under certain conditions; for details, see the COPYING file\n";
		
// Define Linux OS for no thread
		bool 		Linux = false;
// Info on the selected game. 4 string:  0: Name 1:xbe name 2: directory name 3: ID
		ArrayList	CurrentGame = null;
		
// The XBMG configuration
		public Xbgm.Configuration cfg;
		
// Ftp Operations
		public FtpToXbox ftpToXbox;
		
// Popup message (Info & Error) 
		private Popup popup;

		private XisoInfoClass iso = null;
	
		bool freespace = false;
		bool deletesave = false;
		
	#region Gtk# GUI declaration
		public Tooltips tooltips;
	//Notebook1
		private HPaned top;
		private Menu menu = null;
		private ListStore store = null;	
		private Gtk.TreeIter iter;
		private Gtk.TreeView tv;

		private Gtk.Image image;
		private Pixbuf pix;
	
		private Label labelIDresult;
		private Label labelSpaceresult;
		private Label labelSlackresult;
		//private Label labelAllFreespace;
		private Label labelAlltitlesResult;
		private Label labelAllfilesResult;
		private Label labelAllfoldersResult;
		private Label labelAllspaceResult;
		private Label labelAllslackResult;
		private Label labelAllsizeResult;
		private Label labelAllFreespaceResult;
		
		private Label labelResultDriveC;
		private Label labelResultDriveE;
		private Label labelResultDriveF;
		private Label labelResultDriveG;
		private Label DriveG;
		
		private CheckButton DLicons;
	
	//Notebook2
		private ListStore store2 = null;
		private Gtk.TreeIter iter2;
		private Gtk.TreeView tv2;
		private Menu menuiso = null;
		
		private Label labelR1;
		private Label labelR2;
		private Label labelR3;
		private Entry Entrygamexbe;
		private Entry Entrygamedir;
		private Entry Entryxboxdir;

		private Label labelnbbatchentry;
		private Label labelnbbatchsize;
		private Label labelnbbatchfiles;
		
		private CheckButton	halticons;
			
	//Notebook3


	//Notebook4
		public TextView textview;
		public TextBuffer buf;
		
		public uint	IDtimeout = 0;
		private Statusbar statusbar;
	#endregion
	
	/// <summary>
	/// Create the Main GTK# GUI
	/// </summary>
	public MyWindow () : base ("MyWindow")
	{
		this.popup = new Popup(this);
		 
		this.ftpToXbox = new FtpToXbox(new Xbgm.Configuration(), popup);
		this.ftpToXbox.notifyViews += new Notifier(this.updateLabelResults);
	 
	#region Create Main GUI
	 try{
			this.SetDefaultSize (840, 560);
			this.Title = NAME + " " + VERSION;
			this.DeleteEvent += new DeleteEventHandler (OnMyWindowDelete);
			this.BorderWidth = 2;
	 	
	 		// Set the app icon
	 		Gdk.Pixbuf Icon = new Gdk.Pixbuf(null, "xbgmicon.png");
			this.Icon = Icon;
			
			tooltips = new Tooltips ();

			// 1 first split in line		
			VBox vbox = new VBox (false, 0); 
			this.Add (vbox);
	 	
			// Create the Top Toolbar.
			Toolbar Toptoolbar = CreateTopToolbar ();
			vbox.PackStart (Toptoolbar, false, false, 0);

//=================================================
// 			NoteBook 1 Manage Title
			#region NoteBook 1
			Notebook nb = new Notebook ();
	 		VBox vboxnb1 = new VBox (false, 0);
	 		nb.Add(vboxnb1);
	 		nb.SetTabLabelText(vboxnb1, "Manage Titles On Xbox");
	 		vbox.PackStart (nb, true, true, 0);
	 	
			// Create the Toolbar.
			Toolbar Gametoolbar = CreateGameToolbar ();
			vboxnb1.PackStart (Gametoolbar, false, false, 0);

			// Add Horizontal Frame
			top = new HPaned ();
			top.Position = 680;
			vboxnb1.PackStart (top, true, true, 0);
			top.BorderWidth = 0;
			
			// Add a scrolledWindows for the GameList
			ScrolledWindow sw = new ScrolledWindow ();
			top.Add1 (sw);
			
			// Create the treeview containing 6 strings visible + 5 string hiden
			store = new ListStore (typeof (string),
									typeof (string),
									typeof (string),
									typeof (string),
									typeof (string),
									typeof (string),
									typeof (string),
									typeof (string),
									typeof (string),
									typeof (string),
									typeof (string)									
								);
	
			// sort by on name for column 0
			//store.SetSortColumnId(0, 0);
			tv = new TreeView (store);
			tv.HeadersVisible = true;
	 		// I don't know what that but why not?
			//tv.Reorderable = true;
	 		
	 		// Right Click 
	 		// Connect signals for mouse button press and popup menu
            tv.ButtonPressEvent += new ButtonPressEventHandler (OnTreeviewButtonPressEvent);
            tv.PopupMenu += new PopupMenuHandler (PopupMenuCb); 
	 	
			// Got left clickable
			// This crash if not using the mono1.0 command line on WIN32
			// Suppress the crash by catch exception but the GUi it is not fulle functional.
			tv.Selection.Changed += 
				new EventHandler(on_List_selection);
	 	
			// This is bad but if i don't it that way.
			// it is segfaulting on Win32
			// Add column 1
			TreeViewColumn column = new TreeViewColumn ();
			CellRendererText text = new CellRendererText ();
			column.Title = "Title";
			column.Resizable = true;
			column.SortColumnId = 0;
	 		column.MinWidth = 100;
			column.Sizing = TreeViewColumnSizing.Autosize;
			column.PackStart (text, true);
			column.AddAttribute (text, "text", 0);
			tv.AppendColumn(column);

			// 2
			column = new TreeViewColumn ();
			text = new CellRendererText ();
			column.Title = "Size";
			column.Resizable = true;
			column.SortColumnId = 1;
			
			column.Sizing = TreeViewColumnSizing.Autosize;
			column.PackStart (text, true);
			column.AddAttribute (text, "text", 1);
			tv.AppendColumn(column);
			
			// 3 
			column = new TreeViewColumn ();
			text = new CellRendererText ();
			column.Title = "Folder";
			column.Resizable = true;
	 		column.Reorderable = true;
			column.SortColumnId = 0;
			column.MinWidth = 200;
			// specified the size of the column Folder
			/*column.Sizing = TreeViewColumnSizing.Fixed;
			column.FixedWidth = 260;
			*/
			column.Sizing = TreeViewColumnSizing.Autosize;
			column.PackStart (text, true);
			column.AddAttribute (text, "text", 2);
			tv.AppendColumn(column);
			
			// 4
			column = new TreeViewColumn ();
			text = new CellRendererText ();
			column.Title = "Files";
			column.Resizable = true;
			column.SortColumnId = 0;
			
			column.Sizing = TreeViewColumnSizing.Autosize;
			column.PackStart (text, true);
			column.AddAttribute (text, "text", 3);
			tv.AppendColumn(column);
			
			// 5
			column = new TreeViewColumn ();
			text = new CellRendererText ();
			column.Title = "Folders";
			column.Resizable = true;
			column.SortColumnId = 0;
			column.MinWidth = 5;
			column.Sizing = TreeViewColumnSizing.Autosize;
			column.PackStart (text, true);
			column.AddAttribute (text, "text", 4);
			tv.AppendColumn(column);

			// 6
			column = new TreeViewColumn ();
			text = new CellRendererText ();
			column.Title = "Region";
			column.Resizable = true;
			column.SortColumnId = 5;
			column.MinWidth = 5;
		/*	column.MaxWidth = 5;
	 		column.FixedWidth = 5;
	 		column.Sizing = TreeViewColumnSizing.Fixed;
		*/	column.Sizing = TreeViewColumnSizing.Autosize;
			column.PackStart (text, true);
			column.AddAttribute (text, "text", 5);
			tv.AppendColumn(column);

			// 7 hidden ID
			column = new TreeViewColumn ();
			text = new CellRendererText ();
			column.Title = "ID";
			column.Visible = false;
			column.PackStart (text, true);
			column.AddAttribute (text, "text", 6);
			tv.AppendColumn(column);
			
			// 8 hidden Space
			column = new TreeViewColumn ();
			text = new CellRendererText ();
			column.Title = "Space";
			column.Visible = false;
			column.PackStart (text, true);
			column.AddAttribute (text, "text", 7);
			tv.AppendColumn(column);
			
			// 9 hidden Slack
			column = new TreeViewColumn ();
			text = new CellRendererText ();
			column.Title = "Slack";
			column.Visible = false;
			column.PackStart (text, true);
			column.AddAttribute (text, "text", 8);
			tv.AppendColumn(column);
			
			// 10 hidden XBE
			column = new TreeViewColumn ();
			text = new CellRendererText ();
			column.Title = "XBE";
			column.Visible = false;
			column.PackStart (text, true);
			column.AddAttribute (text, "text", 9);
			tv.AppendColumn(column);
			
			// 11 hidden DIR
			column = new TreeViewColumn ();
			text = new CellRendererText ();
			column.Title = "Dir";
			column.Visible = false;
			column.PackStart (text, true);
			column.AddAttribute (text, "text", 10);
			tv.AppendColumn(column);
			sw.Add(tv);
			
			// Split for the right view 			
			VBox vboxinside = new VBox (false, 0); 
			//vboxinside.Visible = true;
			vboxinside.Visible = false;
			top.Add2 (vboxinside);					
		
			// Now that is split 
			// Add the image view
			// Don't show image if check box not Active.
			// Old way to get image from file V0.1
			//pix = GetPixbufFromFile ("xbgm.png"); 
	 		// New way to get image from resource V0.2
	 		pix = new Gdk.Pixbuf (null, "xbgm.png");	
	        image = new Gtk.Image (pix);  // OK
	 	
			vboxinside.PackStart (image);
			
			// Add a frame with a label Title view
			Frame frame = new Frame (" Selected Title ");
			frame.BorderWidth = 3;
			vboxinside.PackStart (frame);

			Table table = new Table (3, 2, true);
	 		//table.SetColSpacing(1, 50);
	 		table.Homogeneous = true;
			frame.Add (table);

			Label labelID = new Label ("ID: ");
			labelID.SetAlignment(1,1);
			table.Attach (labelID, 0, 1, 0, 1);

			Label labelSpace = new Label ("Space:  ");
			labelSpace.SetAlignment(1,2);
			table.Attach (labelSpace,0, 1, 0, 2);

			Label labelSlack = new Label ("Slack:  ");
			labelSlack.SetAlignment(1,3);
			table.Attach (labelSlack, 0, 1, 0, 3);
		
			labelIDresult = new Label ("00000000");
			labelIDresult.SetAlignment(0,1);
			table.Attach (labelIDresult, 1, 2, 0, 1);
		
			labelSpaceresult = new Label ("nb Space");
			labelSpaceresult.SetAlignment(0,2);
			table.Attach (labelSpaceresult, 1, 2, 0, 2);

			labelSlackresult = new Label ("nb Slack");
			labelSlackresult.SetAlignment(0,3);
			table.Attach (labelSlackresult, 1, 2, 0, 3);
		
			// Add a frame label All Titles
			frame = new Frame (" All Titles ");
			frame.BorderWidth = 3;
		
			vboxinside.PackStart (frame);
			
			Table table2 = new Table (7, 2, true);
			frame.Add (table2);

			Label labelAlltitles = new Label ("Titles:  ");
			labelAlltitles.SetAlignment(1,1);
			table2.Attach (labelAlltitles, 0, 1, 0, 1);

			Label labelAllfiles = new Label ("Files:  ");
			labelAllfiles.SetAlignment(1,2);
			table2.Attach (labelAllfiles,0, 1, 0, 2);

			Label labelAllfolders = new Label ("Folders:  ");
			labelAllfolders.SetAlignment(1,3);
			table2.Attach (labelAllfolders, 0, 1, 0, 3);
		
			Label labelAllsize = new Label ("Size:  ");
			labelAllsize.SetAlignment(1,4);
			table2.Attach (labelAllsize, 0, 1, 0, 4);
		
			Label labelAllspace = new Label ("Space:  ");
			labelAllspace.SetAlignment(1,5);
			table2.Attach (labelAllspace, 0, 1, 0, 5);

			Label labelAllslack = new Label ("Slack:  ");
			labelAllslack.SetAlignment(1,6);
			table2.Attach (labelAllslack , 0, 1, 0, 6);
	 	
			Label labelAllFreespace = new Label ("Free Space:  ");
			labelAllFreespace.SetAlignment(1,7);
			table2.Attach (labelAllFreespace , 0, 1, 0, 7);
	 	
			// Result Labels
			labelAlltitlesResult = new Label ("nbTitles");
			labelAlltitlesResult.SetAlignment(0,1);
			table2.Attach (labelAlltitlesResult, 1, 2, 0, 1);

			labelAllfilesResult = new Label ("nbFiles");
			labelAllfilesResult.SetAlignment(0,2);
			table2.Attach (labelAllfilesResult, 1, 2, 0, 2);

			labelAllfoldersResult = new Label ("nbFolders");
			labelAllfoldersResult.SetAlignment(0,3);
			table2.Attach (labelAllfoldersResult, 1, 2, 0, 3);
		
			labelAllsizeResult = new Label ("nbSize");
			labelAllsizeResult.SetAlignment(0,4);
			table2.Attach (labelAllsizeResult, 1, 2, 0, 4);
		
			labelAllspaceResult = new Label ("nbSpace");
			labelAllspaceResult.SetAlignment(0,5);
			table2.Attach (labelAllspaceResult, 1, 2, 0, 5);

			labelAllslackResult = new Label ("nbSlack");
			labelAllslackResult.SetAlignment(0,6);
			table2.Attach (labelAllslackResult, 1, 2, 0, 6);

			labelAllFreespaceResult = new Label ("nbFreeSpace");
			labelAllFreespaceResult.SetAlignment(0,7);
			table2.Attach (labelAllFreespaceResult, 1, 2, 0, 7);
			
			// Add a frame label Free space
			frame = new Frame (" Free Drive space ");
			frame.BorderWidth = 3;
			
			vboxinside.PackStart (frame);
			
			Table table3 = new Table (3, 1, true);
			frame.Add (table3);

			Label DriveC = new Label ("C:  ");
			DriveC.SetAlignment(1,1);
			table3.Attach (DriveC, 0, 1, 0, 1);

			Label DriveE = new Label ("E:  ");
			DriveE.SetAlignment(1,2);
			table3.Attach (DriveE,0, 1, 0, 2);

			Label DriveF = new Label ("F:  ");
			DriveF.SetAlignment(1,3);
			table3.Attach (DriveF, 0, 1, 0, 3);
		
			DriveG = new Label ("G:  ");
			DriveG.SetAlignment(1,4);
			table3.Attach (DriveG, 0, 1, 0, 4);
		 	
			// Result Labels
			labelResultDriveC = new Label ("nbFreeSpace");
			labelResultDriveC.SetAlignment(0,1);
			table3.Attach (labelResultDriveC, 1, 2, 0, 1);

			labelResultDriveE = new Label ("nbFreeSpace");
			labelResultDriveE.SetAlignment(0,2);
			table3.Attach (labelResultDriveE, 1, 2, 0, 2);

			labelResultDriveF = new Label ("nbFreeSpace");
			labelResultDriveF.SetAlignment(0,3);
			table3.Attach (labelResultDriveF, 1, 2, 0, 3);
		
			labelResultDriveG = new Label ("nbFreeSpace");
			labelResultDriveG.SetAlignment(0,4);
			table3.Attach (labelResultDriveG, 1, 2, 0, 4);
			
			DLicons = new CheckButton();
			DLicons.Label = "Download icons";
			DLicons.Active = true;
			vboxinside.PackStart (DLicons, false, false, 0);
			// end the inside Vbox 
			#endregion
//======================================

//=================================================
// 			NoteBook 2 Upload ISO
			#region NoteBook 2
			
			VBox vboxnb2 = new VBox (false, 0);
	 		nb.Add(vboxnb2);
	 		nb.SetTabLabelText(vboxnb2, "Load ISO");
		
	 		Toolbar toolbar3 = CreateISOToolbar ();
			vboxnb2.PackStart (toolbar3, false, false, 0);
	 	
			// Add Vertical Frame
			VPaned vpan = new VPaned ();
			vpan.Position = 290;
			vboxnb2.PackStart (vpan, true, true, 0);
			vpan.BorderWidth = 0;

	 		// Add a scrolledWindows for the ISOList
			ScrolledWindow sw2 = new ScrolledWindow ();

	 		vpan.Add(sw2);
	 	
			// Create the treeview containing 5 string visible + 5 string hide
			store2 = new ListStore (typeof (string),
									typeof (string),
									typeof (string),
									typeof (string),
									typeof (string),
									typeof (string),
									typeof (string),
									typeof (string),
									typeof (string),
									typeof (string));
			
			// sort by on name for column 0
			//store2.SetSortColumnId(0, 0);
			tv2 = new TreeView (store2);
			tv2.HeadersVisible = true;
			tv2.Selection.Changed += 
				new EventHandler(on_ISOList_selection);
			
			// Right Click 
	 		// Connect signals for mouse button press and popup menu
            tv2.ButtonPressEvent += new ButtonPressEventHandler (OnTreeviewUploadISOButtonPressEvent);
            tv2.PopupMenu += new PopupMenuHandler (PopupMenuIsoCb); 
			
			// This is bad but if i don't it that way.
			// if i don't it is segfaulting on Win32
			// Add column 1
			TreeViewColumn column2 = new TreeViewColumn ();
			CellRendererText text2 = new CellRendererText ();
			column2.Title = "XBE Title";
			column2.Resizable = true;
			column2.SortColumnId = 0;
	 	
			column2.Sizing = TreeViewColumnSizing.Autosize;
			column2.PackStart (text2, true);
			column2.AddAttribute (text2, "text", 0);
			tv2.AppendColumn(column2);

			// 2
			column2 = new TreeViewColumn ();
			text2 = new CellRendererText ();
			column2.Title = "Size";
			column2.Resizable = true;
			column2.SortColumnId = 0;
			
			column2.Sizing = TreeViewColumnSizing.Autosize;
			column2.PackStart (text2, true);
			column2.AddAttribute (text2, "text", 1);
			tv2.AppendColumn(column2);
			
			// 3 
			column2 = new TreeViewColumn ();
			text2 = new CellRendererText ();
			column2.Title = "Game Folder";
			column2.Resizable = true;
			column2.SortColumnId = 0;
			column2.Sizing = TreeViewColumnSizing.Autosize;
						
			column2.PackStart (text2, true);
			column2.AddAttribute (text2, "text", 2);
			tv2.AppendColumn(column2);
			
			// 4
			column2 = new TreeViewColumn ();
			text2 = new CellRendererText ();
			column2.Title = "Filename";
			column2.Resizable = true;
			column2.SortColumnId = 0;
			
			column2.Sizing = TreeViewColumnSizing.Autosize;
			column2.PackStart (text2, true);
			column2.AddAttribute (text2, "text", 3);
			tv2.AppendColumn(column2);
	 	
			// 5
			column2 = new TreeViewColumn ();
			text2 = new CellRendererText ();
			column2.Title = "Region";
			column2.Resizable = true;
			column2.SortColumnId = 0;
			
			column2.Sizing = TreeViewColumnSizing.Autosize;
			column2.PackStart (text2, true);
			column2.AddAttribute (text2, "text", 4);
			tv2.AppendColumn(column2);
			
			// 6 ISO Upload info
			column2 = new TreeViewColumn ();
			text2 = new CellRendererText ();
			column2.Title = "Xbox Folder";
			column2.Visible = true;
			column2.Sizing = TreeViewColumnSizing.Autosize;
			column2.PackStart (text2, true);
			column2.AddAttribute (text2, "text", 5);
			tv2.AppendColumn(column2);
			
			// 7 ISO Upload info
			column2 = new TreeViewColumn ();
			text2 = new CellRendererText ();
			column2.Title = "files";
			column2.Visible = false;
			column2.Sizing = TreeViewColumnSizing.Autosize;
			column2.PackStart (text2, true);
			column2.AddAttribute (text2, "text", 6);
			tv2.AppendColumn(column2);
			
			// 8 ISO Upload info
			column2 = new TreeViewColumn ();
			text2 = new CellRendererText ();
			column2.Title = "folders";
			column2.Visible = false;
			column2.Sizing = TreeViewColumnSizing.Autosize;
			column2.PackStart (text2, true);
			column2.AddAttribute (text2, "text", 7);
			tv2.AppendColumn(column2);

			// 9 ISO Upload info
			column2 = new TreeViewColumn ();
			text2 = new CellRendererText ();
			column2.Title = "xisofullfilename";
			column2.Visible = false;
			column2.Sizing = TreeViewColumnSizing.Autosize;
			column2.PackStart (text2, true);
			column2.AddAttribute (text2, "text", 8);
			tv2.AppendColumn(column2);
			
			// 10 ISO Upload info
			column2 = new TreeViewColumn ();
			text2 = new CellRendererText ();
			column2.Title = "iso.totfilesize";
			column2.Visible = false;
			column2.Sizing = TreeViewColumnSizing.Autosize;
			column2.PackStart (text2, true);
			column2.AddAttribute (text2, "text", 9);
			tv2.AppendColumn(column2);

			sw2.Add(tv2);
	 		
	 		HBox hboxnb6 = new HBox (false, 0);
	 		vpan.Add(hboxnb6);
	 		
	 		// Add a frame with a label Title view
			Frame frameTransfertOptions = new Frame (" Transfert Options ");
			frameTransfertOptions.BorderWidth = 2;
	 		//vpan.Add(frameTransfert Options);
	 		hboxnb6.PackStart (frameTransfertOptions, true, true, 5);
	 	
		#region	 ISOoption
		VBox vboxnb3 = new VBox (false, 0);

	 	HBox hboxnbinfo1 = new HBox (false, 0);
	 		Label labelSize = new Label();
	 	/*	Need pango-markup
	 	 * labelSize.UseMarkup = true;
	 		labelSize.Markup = "<b>Size:</b>";
	 	*/
	 		labelSize.Text = "Size:";
	 	hboxnbinfo1.PackStart (labelSize, false, true, 5);
	 		labelR1 = new Label();
	 		labelR1.Text = "R1";
	 	hboxnbinfo1.PackStart (labelR1, false, true, 5);
	 		Label labelFiles = new Label();
	 		labelFiles.Text = "Files:";
	 	hboxnbinfo1.PackStart (labelFiles, false, true, 5);
	 		labelR2 = new Label();
	 		labelR2.Text = "R2";
	 	hboxnbinfo1.PackStart (labelR2, false, true, 5);
	 		Label labelFolders = new Label();
	 		labelFolders.Text = "Folders:";
	 	hboxnbinfo1.PackStart (labelFolders, false, true, 5);	
	 		labelR3 = new Label();
	 		labelR3.Text = "R3";
	 	hboxnbinfo1.PackStart (labelR3, false, true, 5);	 	
	 	vboxnb3.PackStart (hboxnbinfo1, true, true, 0);

	 	HBox hboxnbinfo4 = new HBox (false, 0);
 		Label labelxbe = new Label();
 		labelxbe.Text = "New Title:";
	 	hboxnbinfo4.PackStart (labelxbe, false, false, 5);
 		Entrygamexbe = new Entry();
 		Entrygamexbe.Text = "xbename";
  		Entrygamexbe.Activated += new EventHandler (OnEntrygamexbeActivated);
 		tooltips.SetTip (Entrygamexbe,
                        " Press Enter to valid ",
                        "");
	 	Entrygamexbe.MaxLength = 42;
	 	Entrygamexbe.WidthRequest = 255;
	 	hboxnbinfo4.PackStart (Entrygamexbe, false, false, 10);
	 	vboxnb3.PackStart (hboxnbinfo4, true, true, 0);
	 
	 	HBox hboxnbinfo2 = new HBox (false, 0);
 		Label labelMain = new Label();
 		labelMain.Text = "Main Folder:";
	 	hboxnbinfo2.PackStart (labelMain, false, false, 5);
 		Entryxboxdir = new Entry();
 		Entryxboxdir.Text = "xboxdir";
  		Entryxboxdir.Activated += new EventHandler (OnEntryxboxdirActivated);
 		tooltips.SetTip (Entryxboxdir,
                        " (Evolution-X: 'E', XBMC: 'E:', Avalaunch: 'E:') Press Enter to valid",
                        "");
 		
	 	Entryxboxdir.WidthRequest = 255;
	 	hboxnbinfo2.PackStart (Entryxboxdir, false, false, 10);
 	/*	Label labelHelp = new Label();
 		labelHelp.Text = "(Evolution-X: 'E', XBMC: 'E:', Avalaunch: 'E:')";
	 	hboxnbinfo2.PackStart (labelHelp, false, false, 5);
	*/ 	vboxnb3.PackStart (hboxnbinfo2, true, true, 0);
	
	 	HBox hboxnbinfo3 = new HBox (false, 0);
 		Label labelGame = new Label();
 		labelGame.Text = "Game Folder:";
	 	hboxnbinfo3.PackStart (labelGame, false, false, 5);
 		Entrygamedir = new Entry();
 		Entrygamedir.Text = "gamedir";
  		Entrygamedir.Activated += new EventHandler (OnEntrygamedirActivated);
 		tooltips.SetTip (Entrygamedir,
                        " Press Enter to valid ",
                        "");
	 	Entrygamedir.MaxLength = 42;
	 	Entrygamedir.WidthRequest = 255;
	 	hboxnbinfo3.PackStart (Entrygamedir, false, false, 10);
	 	vboxnb3.PackStart (hboxnbinfo3, true, true, 0);
		#endregion
		
	 		frameTransfertOptions.Add(vboxnb3);
	 		
	 		// Add a frame with Batch Info view
			Frame frameBatchInfo = new Frame (" Batch Info ");
			frameBatchInfo.BorderWidth = 2;

			hboxnb6.PackStart (frameBatchInfo, false, true, 5);

	 		#region	 BatchInfo
	 		VBox vboxBatchInfo = new VBox (false, 0);	 		
	 		frameBatchInfo.Add (vboxBatchInfo);
	 		
	 		Table tablebatchinfo = new Table (3, 2, true);
	 		tablebatchinfo.Homogeneous = true;
			vboxBatchInfo.PackStart (tablebatchinfo, true, true, 5);
			
			Label labelbatchentry = new Label ("Batch Entry: ");
			labelbatchentry.SetAlignment(1,1);
			tablebatchinfo.Attach (labelbatchentry, 0, 1, 0, 1);

			Label labelbatchsize = new Label ("Batch Size: ");
			labelbatchsize.SetAlignment(1,2);
			tablebatchinfo.Attach (labelbatchsize, 0, 1, 0, 2);

			Label labelbatchfile = new Label ("Batch Files: ");
			labelbatchfile.SetAlignment(1,3);
			tablebatchinfo.Attach (labelbatchfile, 0, 1, 0, 3);
			
			labelnbbatchentry = new Label ("nbBatchEntry");
			labelnbbatchentry.SetAlignment(0,1);
			tablebatchinfo.Attach (labelnbbatchentry, 1, 2, 0, 1);

			labelnbbatchsize = new Label ("nbBatchSize");
			labelnbbatchsize.SetAlignment(0,2);
			tablebatchinfo.Attach (labelnbbatchsize, 1, 2, 0, 2);		

			labelnbbatchfiles = new Label ("nbBatchFiles");
			labelnbbatchfiles.SetAlignment(0,3);
			tablebatchinfo.Attach (labelnbbatchfiles, 1, 2, 0, 3);
			#endregion BatchInfo
			
			halticons = new CheckButton();
			halticons.Label = "Shutdown XBOX After Transfert";
			halticons.Active = false;
			vboxBatchInfo.PackStart (halticons, true, true, 5);
			
			#endregion		
//======================================
/*
//=================================================
// 			NoteBook 3 Create ISO
			#region NoteBook 3
			
			VBox vboxnb5 = new VBox (false, 0);
	 		nb.Add(vboxnb5);
	 		nb.SetTabLabelText(vboxnb5, "Create ISO");
		
	 		// Add a frame with a label Title view
			Frame frame4 = new Frame (" Source ");
			frame4.BorderWidth = 4;
			vboxnb5.PackStart (frame4, false, false, 0);
			                   
			HBox hbox = new HBox (false, 2);
			hbox.BorderWidth = 5;
			frame4.Add(hbox);
					
			Button btn = new Button ("Create ISO");
			btn.Clicked += new EventHandler (OnCreateISOClicked);
			hbox.PackStart (btn, false, false, 0);
	
			// Add a frame with a label Title view
			Frame frame5 = new Frame (" PC tools ");
			frame5.BorderWidth = 4;
			vboxnb5.PackStart (frame5, false, false, 0);
			
			HBox hbox2 = new HBox (false, 2);
			hbox2.BorderWidth = 5;
			frame5.Add(hbox2);
			
			Button btmd5 = null;
			btmd5 = new Button ("File MD5");
			btmd5.Clicked += new EventHandler (OnFileMD5Clicked);
			btmd5.CanDefault = true;
			
			hbox2.PackStart(btmd5, false, false, 0);
			
			#endregion
//======================================
*/
//=================================================
// 			NoteBook 4 Log view
			#region NoteBook 4
					
			VBox vboxnb4 = new VBox (false, 0);
	 		nb.Add(vboxnb4);
	 		nb.SetTabLabelText(vboxnb4, "Log view");
		
	 		Toolbar toolbar4 = CreateLogToolbar ();
			vboxnb4.PackStart (toolbar4, false, false, 0);

			// Add a frame with a label Title view
			Frame framelogview = new Frame (" Log Messages ");
			framelogview.BorderWidth = 4;
			
			// Add a scrolledWindows for the ISOList
			//ScrolledWindow sw3 = new ScrolledWindow ();
			//sw3.BorderWidth = 10;
			//frame3.Add(sw3);
			
			// Add a Text View
			// To make a log view better than console
			textview = new TextView ();
			buf = textview.Buffer;
			textview.Editable = false;
			
			//sw3.Add(textview);
			framelogview.Add(textview);

			vboxnb4.PackStart (framelogview, true, true, 0);
			
			#endregion
//======================================

			CurrentGame = new ArrayList();
			
			// Add a status bar
			statusbar = new Statusbar ();
			statusbar.Push (1, "Xbgm# ready.");
			vbox.PackStart (statusbar, false, false, 0);
			//END of first vbox 
		
		}
		catch(Exception ex)	{ Console.WriteLine(ex.Message); }
		#endregion
		
		// Show the all window
		this.ShowAll();
		this.Present();

		// Init the Xiso Info class
		iso = new XisoInfoClass();
		
		// Show welcome message
		AppendText(NAME + " " + VERSION + " " + WELCOME);
		
		// Init the XBMC configuration
		cfg = new Configuration();
		
		// Use G Drive
		if (cfg.getGDrive() == false) {
			DriveG.Visible = false;
			labelResultDriveG.Visible = false;
		}
			
		Entrygamexbe.Hide();
		Entrygamedir.Hide();
		Entryxboxdir.Hide();

		//If linux no thread in game manager
		if (Environment.OSVersion.Platform.ToString().StartsWith("Win"))
			Linux = false;
		else
			Linux = true;
	} // End of Constructor
	
	void OnMyWindowDelete (object o, DeleteEventArgs args)
	{
		Application.Quit ();
	}
	
	#region Tools
	/// <summary>
	/// On bt CreateISO click
	/// </summary>
	/// <returns>void</returns>	
	public void OnCreateISOClicked(object o, EventArgs args)
	{
		//Create ISO from source
		//...
	}
	
	/// <summary>
	/// On bt File MD5 click
	/// </summary>
	/// <returns>void</returns>	
	public void OnFileMD5Clicked(object o, EventArgs args)
	{
		/* Test create XISO 
		XisoCreateClass testdir = new XisoCreateClass();
		testdir.calculate("J:\\DVD\\ROOT\\BOOT\\");
		*/
		FileSelection fDlg = new FileSelection("MD5 a file.");
		fDlg.Complete("*.*");
		int nRc = fDlg.Run();
		fDlg.Hide();

		if(nRc == (int)ResponseType.Ok) 
		{	
			if (System.IO.File.Exists (fDlg.Filename))
			{
		        System.IO.FileStream st=null;
		        try
		        {
		        	// BUG if the file as more than 1 dot (eg: foo.bar.txt)
		         System.Security.Cryptography.MD5CryptoServiceProvider check;
		         st= System.IO.File.Open (fDlg.Filename,System.IO.FileMode.Open,System.IO.FileAccess.Read);
		         check = new System.Security.Cryptography.MD5CryptoServiceProvider();
		         byte[] somme = check.ComputeHash (st);
		         string ret = "";
		         foreach (byte a in somme)
		         {
		            if (a<16)
		                 ret += "0" + a.ToString ("X");
		            else
		                 ret += a.ToString ("X");
		         }
		         #if ( DEBUG )
		         	Console.WriteLine("MD5 = ["+ ret +"]");
		         #endif
		         popup.Info("MD5 for " + System.IO.Path.GetFileName(fDlg.Filename) + "\n" + ret);
		         AppendText("MD5 for " + System.IO.Path.GetFileName(fDlg.Filename) + " " + ret);
		         ret = null;
		        }
		        catch
		        {
		        	AppendText("Fichier non trouv."+ System.IO.Path.GetFileName(fDlg.Filename));
		         throw;
		        }
		        finally
		        {
		         if ( st != null)
		            st.Close();
		        }
		     }
		     else
		     {
		        throw new System.IO.FileNotFoundException ("Fichier non trouv.", fDlg.Filename);
		     } 
		}
	}
	#endregion
	
		#region CreateToolbar
		/// <summary>
		/// Create the Game Toolbar
		/// </summary>
		/// <returns>a toolbar</returns>
		private Toolbar CreateGameToolbar ()
		{
			Toolbar toolbar = new Toolbar ();
			
			toolbar.ToolbarStyle = Gtk.ToolbarStyle.Icons;
			toolbar.IconSize = IconSize.SmallToolbar;
			
			toolbar.AppendItem ("Scans Titles",
				"Scans Titles", String.Empty,
				new Gtk.Image (Stock.Refresh, IconSize.Menu),
				new Gtk.SignalFunc (OnToolbarScanTitlesClicked));
			toolbar.AppendSpace();
	
			pix = new Gdk.Pixbuf (null, "edit.png");
			toolbar.AppendItem ("Rename", 
				"Rename", String.Empty,
				new Gtk.Image (pix),
				new Gtk.SignalFunc (OnToolbarRenameClicked));	
			 
			pix = new Gdk.Pixbuf (null, "play.png");
			//new Gtk.Image (Stock.Execute, IconSize.Menu),
			//new Gtk.Image (pix),
			toolbar.AppendItem ("Launch",
				"Launch Game", String.Empty,
				new Gtk.Image (pix),
				new Gtk.SignalFunc (OnToolbarLaunchClicked));	
			
			toolbar.AppendItem ("Delete",
				"Delete", String.Empty,
				new Gtk.Image (Stock.Delete, IconSize.Menu),
				new Gtk.SignalFunc (OnToolbarDeleteClicked));	
		
			toolbar.AppendSpace();
			
			toolbar.AppendItem ("Save List",
				"Save List", String.Empty,
				new Gtk.Image (Stock.Save, IconSize.Menu),
				new Gtk.SignalFunc (OnToolbarExportClicked));	
	 			
			return toolbar;
		}
		
		/// <summary>
		/// Create the ISO Toolbar
		/// </summary>
		/// <returns>a toolbar</returns>
		private Toolbar CreateISOToolbar ()
		{
			Toolbar toolbar = new Toolbar ();
			
			toolbar.ToolbarStyle = Gtk.ToolbarStyle.Icons;
			toolbar.IconSize = IconSize.SmallToolbar;
			
			toolbar.AppendItem ("_Open",
				"Open ISO", String.Empty,
				new Gtk.Image (Stock.Open, IconSize.Menu),
				new Gtk.SignalFunc (OnToolbarOpenISOClicked));	
			
			toolbar.AppendItem ("FTP Upload ISO",
				"FTP Upload ISO", String.Empty,
				new Gtk.Image (Stock.GotoTop, IconSize.Menu),
				new Gtk.SignalFunc (OnToolbarUploadISOClicked));
		
			toolbar.AppendItem ("Extract ISO",
				"Extract ISO", String.Empty,
				new Gtk.Image (Stock.GotoFirst, IconSize.Menu),
				new Gtk.SignalFunc (OnToolbarExtractISOClicked));
			
			toolbar.AppendSpace();

			toolbar.AppendItem ("Clear Batch",
				"Clear Batch", String.Empty,
				new Gtk.Image (Stock.Clear, IconSize.Menu),
				new Gtk.SignalFunc (OnToolbarClearBatchClicked));
			
			return toolbar;
		}

		/// <summary>
		/// Create the LOG Toolbar
		/// </summary>
		/// <returns>a toolbar</returns>
		private Toolbar CreateLogToolbar ()
		{
			Toolbar toolbar = new Toolbar ();
			
			toolbar.ToolbarStyle = Gtk.ToolbarStyle.Icons;
			toolbar.IconSize = IconSize.SmallToolbar;
			
			toolbar.AppendItem ("Clear view",
				"Clear view", String.Empty,
				new Gtk.Image (Stock.Clear, IconSize.Menu),
				new Gtk.SignalFunc (OnToolbarClearLogClicked));	
			
			toolbar.AppendItem ("Save log as",
				"Save log as", String.Empty,
				new Gtk.Image (Stock.SaveAs, IconSize.Menu),
				new Gtk.SignalFunc (OnToolbarSaveLogClicked));
		
			return toolbar;
		}
		
		/// <summary>
		/// Create the TOP Toolbar
		/// </summary>
		/// <returns>a toolbar</returns>
		private Toolbar CreateTopToolbar ()
		{
			Toolbar toolbar = new Toolbar ();
			
			toolbar.ToolbarStyle = Gtk.ToolbarStyle.Icons;

			toolbar.AppendItem ("Configuration",
				"Configuration", String.Empty,
				new Gtk.Image (Stock.Preferences, IconSize.Button),
				new Gtk.SignalFunc (OnToolbarPrefClicked));
			
			toolbar.AppendSpace();	
		
			pix = new Gdk.Pixbuf (null, "xbmc.png");
			toolbar.AppendItem ("XBMC", 
				"Xbox Media Center", String.Empty,
				new Gtk.Image (pix),
				new Gtk.SignalFunc (OnToolbarXBMCClicked));	

			toolbar.AppendSpace();	
			
			pix = new Gdk.Pixbuf (null, "shutdown.png");
			toolbar.AppendItem ("Shutdown", 
				"Shutdown Xbox", String.Empty,
				new Gtk.Image (pix),
				new Gtk.SignalFunc (OnToolbarShutdownClicked));	
 
			pix = new Gdk.Pixbuf (null, "reboot.png");
			toolbar.AppendItem ("Reboot", 
				"Reboot Xbox", String.Empty,
				new Gtk.Image (pix),
				new Gtk.SignalFunc (OnToolbarRestartClicked));	
			
			toolbar.AppendSpace();
			
			pix = new Gdk.Pixbuf (null, "infoicon.png");
			toolbar.AppendItem ("Information", 
				"Information", String.Empty,
				new Gtk.Image (pix),
				new Gtk.SignalFunc (OnToolbarAboutClicked));	

			return toolbar;
		}
		#endregion
		
		#region OnToolbarTopClicked
		private void OnToolbarPrefClicked ()
		{
			PrefDialog login = new PrefDialog ();
			
			// set conf value to preference dialog
			if (cfg.ReadConf() == true)	{ login.setConfiguration(cfg); }
			
			if ((int)ResponseType.Ok == login.Run())
			{
				cfg.set(login.getConfiguration());
				cfg.SaveConf();
			}
			login.Close();			
			login = null;
		}

		private void OnToolbarXBMCClicked()
		{
			try 
			{
				if (!ReadConf()) return;
				// Do xbox Stuff
				this.ftpToXbox.ActionNotOnGame(FtpToXbox.Action.xbmc);
				AppendText("Xbox Media Center Start");
			}
			catch (Exception ex)
			{
				#if (DEBUG)
				Console.WriteLine("Exception (in MyWindow): " + ex.Message);
				#endif
				popup.Error(ex.Message);
			}
		}
		
		private void OnToolbarShutdownClicked()
		{
			try 
			{
				if(!ReadConf())	return;	

				// Do xbox Stuff
				ftpToXbox.ActionNotOnGame(FtpToXbox.Action.shutdown);
				AppendText("Xbox Shutdown");
			}
			catch (Exception ex)
			{
				#if (DEBUG)
				Console.WriteLine("Exception (in MyWindow): " + ex.Message);
				#endif
				popup.Error(ex.Message);
			}
		}

		private void OnToolbarRestartClicked()
		{
			try 
			{
				// Check Conf
				if(!ReadConf()) return;
					
				// Update configuration in the ftp connection controller
				ftpToXbox.setConfiguration(cfg);

				// Do xbox Stuff
				ftpToXbox.ActionNotOnGame(FtpToXbox.Action.reboot);
				AppendText("Xbox Reboot");
			}
			catch (Exception ex)
			{
				#if (DEBUG)
				Console.WriteLine("Exception (in MyWindow): " + ex.Message);
				#endif
				popup.Error(ex.Message);
			}
		}
		
		private void OnToolbarAboutClicked()
		{
			AboutDialog about = new AboutDialog (this, VERSION);
			#if ( DEBUG )
				Console.WriteLine("Got AboutDialog");	
			#endif	
			about.Run();
			about.Close();
			about = null;
		}
		#endregion

		#region OnToolbarGameClicked
		private void OnToolbarScanTitlesClicked ()
		{	
			if (!ReadConf())
			{
				Console.WriteLine("Failed reading the config, not good!");
				return;
			}
			
			// Clear the Liststore
			store.Clear();
			
			Thread t1 = new Thread(new ThreadStart(f1));

			// Ask for cache if Active in configuration
	/*		if (cache == true) 
			{
				System.Text.StringBuilder StringBuild = new System.Text.StringBuilder ();
				StringBuild.Append("Do you wish to use cache?");
				
				MessageDialog md = new MessageDialog (this, 
				                                      DialogFlags.DestroyWithParent, 
				                                      MessageType.Question, 
				                                      ButtonsType.YesNo, 
				                                      StringBuild.ToString());			
				// need to check what the user choose.
				int result = md.Run ();
				md.Hide ();
				md.Dispose ();
				md.Destroy ();
				StringBuild = null;
				if (result  == (int)ResponseType.Yes)
				{
		*/				
						// So you want to use cache.
						//cache = true;
						
						// Get the Game listing for the Xbox or cache			
						if(cfg.getCache())
						{
							#if ( DEBUG )
								Console.WriteLine("Use cache, parse it...");
							#endif
							AppendText("Use cache to list Xbox Game");
							// if we use cache we have a titles files and icons
							labelAllFreespaceResult.Text = ftpToXbox.GetTitlesCached();

							if(Convert.ToInt32(ftpToXbox.gameSummary.nbTitles) < 1 ||
								ftpToXbox.gameSummary.info == null)
							{
								#if ( DEBUG )
									Console.WriteLine("Use cache but NOT Found launch FTP");
								#endif
							} else {
								updateSummary(ftpToXbox.gameSummary);
							}
						}
						
						// Default case when cache is set to false
						if(Convert.ToInt32(ftpToXbox.gameSummary.nbTitles) < 1 || cfg.getCache() == false)
						{
							if (Linux == false)
								t1.Start();
							else
							{
								f1();
								ftpToXbox.action = FtpToXbox.Action.ready;
							}
						}
	/*			}
				if (result  == (int)ResponseType.No)
				{
					#if ( DEBUG )
						Console.WriteLine("NOT Use cache");
					#endif
					t1.Start();	
				}
			}
			else
			{
				#if ( DEBUG )
					Console.WriteLine("NOT ask cache");
				#endif
				t1.Start();
			}
	*/		
			// Set a  1sec timout to update the GUI
			IDtimeout = Gtk.Timeout.Add((uint)(1000), new Gtk.Function(UpdateStatusBarTimeOut));
		}

		private void f1()
		{
			try
			{
				labelAllFreespaceResult.Text = ftpToXbox.GetTitles(DLicons.Active);
				updateSummary(ftpToXbox.gameSummary);
			}
			catch (Exception ex)
			{
				#if (DEBUG)
					Console.WriteLine(ex.Message);
				#endif
			}
		}

		/// <summary>
		/// Update the status bar with a timeout set to 1 sec.	
		/// Show what we are doing when getting game titles info.
		/// </summary>
		private bool UpdateStatusBarTimeOut()
		{
			if (ftpToXbox.action == FtpToXbox.Action.image)
				statusbar.Push (1 , "Getting Images....");
			else if (ftpToXbox.action == FtpToXbox.Action.scan)
				statusbar.Push (1 , "Scanning Titles....");
			else if (ftpToXbox.action == FtpToXbox.Action.ready)
			{
				statusbar.Push (1 , "XBGM# Ready.");
				Gtk.Timeout.Remove(IDtimeout);
			}
			#if ( DEBUG )
				Console.WriteLine("..");
			#endif
			return true;
		}
		
		private void OnToolbarLaunchClicked()
		{
			// Launch Game by FTP Command
			if (CurrentGame.Count != 0)
			{
				#if ( DEBUG )	
				{
					Console.WriteLine(CurrentGame[0]);
					Console.WriteLine(CurrentGame[1]);
					Console.WriteLine(CurrentGame[2]);
					Console.WriteLine(CurrentGame[3]);
					//Console.WriteLine("user: \"" + ftpinfo.getUser() + "\" pass: \"" + ftpinfo.getPassword() + "\" IP: \"" + ftpinfo.getIp() + "\" Dir: \"" + ftpinfo.getDirectory + "\"");
				}
				#endif
				// DO xbox FTp stuff
				if (ftpToXbox.LaunchGame(CurrentGame))
				{
					// tell the user the game as been launch
					popup.Info(CurrentGame[0] + " Launched");
					AppendText(CurrentGame[0] + " Launched");
				}	
			}
		}
		
		private void OnToolbarLaunchClicked(object o, EventArgs args)
		{
			OnToolbarLaunchClicked();
		}
				
		private void OnToolbarDeleteClicked ()
		{
			if (CurrentGame.Count != 0)
			{
				#if ( DEBUG )
					Console.WriteLine(CurrentGame[2]);
				#endif

				DeleteDialog login = new DeleteDialog (CurrentGame[0].ToString());
				int nRc = login.Run();
				#if ( DEBUG )
					Console.WriteLine("Got DeleteDialog");	
				#endif
				if (login.action == 1)
					deletesave = false;
				if (login.action == 2)
					deletesave = true;
				if (login.action == 3)
					deletesave = true;
				
				login.Close();
				login = null;
				if(nRc == (int)ResponseType.Ok) {
					// DO xbox FTp stuff
					ftpToXbox.DeleteGame(CurrentGame, deletesave);
					AppendText("Game " + CurrentGame[0].ToString() + " deleted");
				}
			}
		}		

		private void OnToolbarDeleteClicked(object o, EventArgs args)
		{
			OnToolbarDeleteClicked();
		}
		
		private void OnToolbarRenameClicked ()
		{
			if (CurrentGame.Count != 0)
			{
				RenameDialog login = new RenameDialog (CurrentGame[0].ToString());
				int nRc = login.Run();
				#if ( DEBUG )
					Console.WriteLine("Got RenameDialog");	
				#endif
				string newgamename  = login.Game;
				#if ( DEBUG )
					Console.WriteLine("New name: " + newgamename);
				#endif
				login.Close();
				login = null;
				
				if(nRc == (int)ResponseType.Ok) {
					// Do xbox FTP stuff
					if (ftpToXbox.RenameGame(CurrentGame, newgamename))
					{
						AppendText("Game " + CurrentGame[0].ToString() + " rename to " + newgamename);
					}
				}
			}
		}

		private void OnToolbarRenameClicked(object o, EventArgs args)
		{
			OnToolbarRenameClicked();
		}
		
		private void OnToolbarExportClicked ()
		{
			if (CurrentGame.Count != 0)
			{
				FileSelection fDlg = new FileSelection("Create a html file.");
	    		fDlg.Complete("*.html");
	    		int nRc = fDlg.Run();
	    		fDlg.Hide();
				
	    		if(nRc == (int)ResponseType.Ok) {
	    			#if ( DEBUG )
						Console.WriteLine(fDlg.Filename);
					#endif
					ExportTo exportto = new ExportTo(popup);
					exportto.HTML(fDlg.Filename, store, iter);
					exportto = null;
				}
	    		fDlg.Destroy();
	    		fDlg = null;
			}
		}
		#endregion
		
		#region OnToolbarISOClicked
		private void OnToolbarOpenISOClicked ()
		{
			// Check Conf
			if(!ReadConf())
				return;
    		FileSelection fDlg = new FileSelection("Choose a ISO file.");
    		fDlg.HideFileopButtons();
			fDlg.Complete("*.iso");
    		int nRc = fDlg.Run();
    		fDlg.Hide();
    		
    		// Do not crash if a directory is selected 
   			if (fDlg.Filename.IndexOf("*.iso") > 0)
   			{
   				// Useless to show the message if Ok hasn't been pressed
    			if(nRc == (int)ResponseType.Ok)
    				Console.WriteLine("You selected a directory, not good!");
    			
    		} else if(nRc == (int)ResponseType.Ok) {
		
				#if ( DEBUG )
					Console.WriteLine(fDlg.Filename);
				#endif
				//XisoInfoClass iso = new XisoInfoClass();
				iso.xisofilename = fDlg.Filename;
				iso.xbe = true;
				iso.Nbfiles = 0;
				iso.totfilesize = 0;
				iso.getfileiniso();
				labelR1.Text = iso.isosize.ToString() + " MB";
				labelR2.Text = iso.Nbfiles.ToString();
				labelR3.Text = iso.Nbdir.ToString();
				Entrygamexbe.Text = iso.GameName;
				//Entryxboxdir.Text = FTPinfo.dir;
				Entryxboxdir.Text = cfg.getFtpInfo().getDirectory();
				Entrygamedir.Text = iso.GameFolder;
				string[] info = null;
				if(iso.GameRegion == 1)
					info = new string[]{iso.GameName, labelR1.Text, iso.GameFolder, System.IO.Path.GetFileName(fDlg.Filename), "NTSC", Entryxboxdir.Text, iso.Nbfiles.ToString() , iso.Nbdir.ToString(), iso.xisofilename, iso.totfilesize.ToString()};
				else if(iso.GameRegion == 2)
					info = new string[]{iso.GameName, labelR1.Text, iso.GameFolder, System.IO.Path.GetFileName(fDlg.Filename), "JP", Entryxboxdir.Text, iso.Nbfiles.ToString() , iso.Nbdir.ToString(), iso.xisofilename, iso.totfilesize.ToString()};
				else if(iso.GameRegion == 4)
					info = new string[]{iso.GameName, labelR1.Text, iso.GameFolder, System.IO.Path.GetFileName(fDlg.Filename), "PAL", Entryxboxdir.Text, iso.Nbfiles.ToString() , iso.Nbdir.ToString(), iso.xisofilename, iso.totfilesize.ToString()};
				else
					info = new string[]{iso.GameName, labelR1.Text, iso.GameFolder, System.IO.Path.GetFileName(fDlg.Filename), "Mix", Entryxboxdir.Text, iso.Nbfiles.ToString() , iso.Nbdir.ToString(), iso.xisofilename, iso.totfilesize.ToString()};
				AddISOInfoToRow(info);
				RefreshBatchInfo();
				// Show entry
				Entrygamexbe.Visible = true;
				Entryxboxdir.Visible = true;
				Entrygamedir.Visible = true;
				info = null;
				//iso = null;

	    		fDlg.Destroy();
				fDlg = null;
			}
		}

		private void OnToolbarUploadISOClicked ()
		{
			//if (iso.xisofilename != null)
			store2.GetIterFirst(out iter2);
			if (store2.IterIsValid(iter2))
			{
				 // Comment because i don't know where to get params, should in extract xiso
		/*		// Check Free space before Upload
				freespace = ftpToXbox.GetFreeSpace(string xboxDir, UInt32 size)
				if (freespace == true) // IF enought space
		*/		
				if( !ExtractXiso() )
				{	// Do not refresh Avalaunch menu else xbgm# will freeze
					#if (DEBUG)
					Console.WriteLine("Extraction cancelled!");
					#endif
					return;
				}
				else 
				{
					// Refresh Avalaunch Menu
					try
					{
						ftpToXbox.ActionNotOnGame(FtpToXbox.Action.refresh);
					}
					catch (Exception ex)
					{
						#if (DEBUG)
						Console.WriteLine("Exception (in MyWindow): " + ex.Message);
						#endif
						popup.Error(ex.Message);
					}
				}
				// Check if i need to Shutdown Xbox
				if (halticons.Active == true) {
					// Shutdown Xbox
					ftpToXbox.ActionNotOnGame(FtpToXbox.Action.shutdown);
				}
				Console.WriteLine("End UploadISO");
				AppendText(buf, "End Upload xISO");
			}
			else
			{
			  AppendText(buf, "You need to select an xISO file.");
			  popup.Info("You need to select an xISO file.");
			}
		}

		private void OnToolbarExtractISOClicked ()
		{ 
			// Iso selection and directory This need GTK 2.0
			//FileChooserAction.SelectFolder
			/*using (FileChooserDialog chooser = 	
			       new FileChooserDialog ("Choose a ISO file", this,
									FileChooserAction.Open, 
									Stock.Cancel, ResponseType.Cancel, Stock.Open, ResponseType.Ok)) {
			chooser.SelectMultiple = false;
			FileFilter myfilter = new FileFilter();
			myfilter.Name = "Xbox iso";
			myfilter.AddPattern("*.iso");
			chooser.AddFilter(myfilter);
			ResponseType response = (ResponseType) chooser.Run();
			if (response == ResponseType.Ok) {
				//myLife.PathToPhoto = chooser.Filename;
				Console.WriteLine("FileChooserDialog filename = '{0}'", chooser.Filename);
				//RefreshFromLife();
			} else {
				Console.WriteLine("FileChooserDialog response = '{0}'", response);
			}
			chooser.Destroy();
			}	
			*/
			// Need to Specifed where to extract iso on HDD
			FileSelection fDlg = new FileSelection("Choose a ISO file.");
			fDlg.HideFileopButtons();
			fDlg.Complete("*.iso");
    		int nRc = fDlg.Run();
    		fDlg.Hide();
			if(nRc == (int)ResponseType.Ok) {
			  	FileSelection DirDlg = new FileSelection("Choose a Destination Directory.");
				//DirDlg.SelectionEntry.Text = System.IO.Path.GetDirectoryName(fDlg.Filename);
    			int nRdir = DirDlg.Run();
    			DirDlg.Hide();
				if(nRdir == (int)ResponseType.Ok) {
					#if ( DEBUG )
						Console.WriteLine("File : [" + fDlg.Filename + "] Dir: [" + DirDlg.Filename + "]");
					#endif
					// Save current path before hdd extracting
					string currentdir = Directory.GetCurrentDirectory();
					iso.xisofilename = fDlg.Filename;
					iso.GameRootFolder = DirDlg.Filename;
					iso.xbe = false;
					iso.Nbfiles = 0;
					iso.totfilesize = 0;
					iso.getfileiniso();
					string gameextractdir = System.IO.Path.GetFileName(fDlg.Filename);
					gameextractdir = gameextractdir.Substring(0 ,System.IO.Path.GetFileName(fDlg.Filename).LastIndexOf('.'));
					iso.GameFolder = gameextractdir;
					gameextractdir = null;
					ExtractXiso();
					// Restore the old current path
					Directory.SetCurrentDirectory(currentdir);
					currentdir = null;
					iso.xisofilename = iso.GameRootFolder = iso.GameName = iso.GameFolder = null;
				//	iso = null;				
				}
    			DirDlg.Destroy();
				DirDlg = null;
			}
    		fDlg.Destroy();
			fDlg = null;
		}
		
		private void OnToolbarClearBatchClicked ()
		{ 
			store2.Clear();
			RefreshBatchInfo();
			labelR1.Text  = "0";
			labelR2.Text = "0";
			labelR3.Text = "0";
			Entrygamexbe.Text = "";
			Entryxboxdir.Text = "";
			Entrygamedir.Text = "";
			Entrygamexbe.Hide();
			Entrygamedir.Hide();
			Entryxboxdir.Hide();
		}
		#endregion

		#region OnToolbarLogClicked
		private void OnToolbarClearLogClicked()
		{
			textview.Buffer.Clear();
		}
		
		private void OnToolbarSaveLogClicked ()
		{
			FileSelection fDlg = new FileSelection("Export Log view.");
			fDlg.Complete("*.txt");
			int nRc = fDlg.Run();
			fDlg.Hide();
			if(fDlg.Filename == null && fDlg.Filename.Length < 1)
				return;
			
			if(nRc == (int)ResponseType.Ok) 
			{	
				StreamWriter outputFilestream = null;
				try {
					outputFilestream = new StreamWriter(fDlg.Filename);
				}
				catch(Exception e) {
					Console.WriteLine("Error: Unable to create output log file. " + 
						e.Message);
					return;
				}
	
				outputFilestream.WriteLine(textview.Buffer.Text);		
				outputFilestream.Close();
				outputFilestream = null;
				#if ( DEBUG )
					Console.WriteLine("Outputting log to file done.");
				#endif
				popup.Info("Log message save to file \n" + System.IO.Path.GetFileName(fDlg.Filename));
				AppendText("Log message save to file " + System.IO.Path.GetFileName(fDlg.Filename));
			}
			fDlg.Destroy();
			fDlg = null;
		}
		#endregion
		
		#region Append Text to Log View
		void AppendText (string text) 
		{
			AppendText (buf, text);
		}
		
		public void AppendTextWithoutScroll (TextBuffer buffer, string text) 
		{
			TextIter iter;
			buffer.MoveMark(buf.InsertMark, buffer.EndIter);
			if(text != null) 
			{
				if (text.Equals ("") == false) 
				{				
					iter = buffer.EndIter;
					buffer.Insert (iter, "["+DateTime.Now.ToShortTimeString()+"] >> " + text);
				}
			}
			iter = buffer.EndIter;
			buffer.Insert (iter, "\n");
		}

		// WriteLine() to output text to Log TextView
		// for displaying result sets and logging messages
		public void AppendText (TextBuffer buffer, string text) 
		{
			AppendTextWithoutScroll(buffer,text);
			while (Application.EventsPending ()) 
				Application.RunIteration ();
			//textview.ScrollToMark (buf.InsertMark, 0.4, true, 0.0, 1.0);
		}
		#endregion
		
		private bool ExtractXiso()
		{
			// Create the GUI for the stats
			ProgressDialog progress = new ProgressDialog ();
			// if we parse the xbe then it is extract over network
			if (iso.xbe == true)
			{
				double totsizebatchxiso = 0;
				// Send ListStore Gtk.TreeIter to ProgressDialog
				progress.xISOAdd(store2, iter2);
				// Generate tot size batch iso
				totsizebatchxiso = Convert.ToDouble((string)store2.GetValue(iter2, 9));
				while (store2.IterNext(ref iter2))
				{
					totsizebatchxiso += Convert.ToDouble((string)store2.GetValue(iter2, 9));
				}	
				//Console.ReadLine();
				progress.UpdateFTPinfo(cfg.getFtpInfo());
				// Check if we got a / at the end xbox game dir.
				if (Entryxboxdir.Text.Length >= 4 && Entryxboxdir.Text.EndsWith("/") == false)
					Entryxboxdir.Text = Entryxboxdir.Text + "/";	
				//Console.WriteLine("totsifebatchxiso ==>" + totsizebatchxiso + "\n");
				// Set Stats for Batch upload Xiso
				progress.UpdateStatBatchXisos(totsizebatchxiso,
				                              Convert.ToDouble(labelnbbatchentry.Text),
				                              false); // FTpavalaunch
				// Set first Xiso for Batch upload Xiso
				progress.SelectXisoInBatchXisos(false);
			}
			else
			{
				// Set Xiso and batch value for extraction on local
				progress.UpdateXiso(iso.xisofilename, iso.GameRootFolder, iso.GameFolder, iso.Nbfiles, iso.totfilesize, true); // HDD
			}
			// Start timer
			DateTime DtStartNow = DateTime.Now;
			// Do the job
			progress.Run();
			// Stop timer
			DateTime DtStopNow = DateTime.Now;
			// When finish or cancel
			// Kill the dialog box
			progress.Close();
			string tmptime = (DtStopNow - DtStartNow).ToString();
			if (progress.IsCancel == false)
				popup.Info("Task completed successfully.\n\nTotal bytes transferred: " + (iso.totfilesize/1024) + " KB\nFiles Transferred: " + iso.Nbfiles + "\nElapsed time: " + tmptime.Substring(0, tmptime.LastIndexOf('.')) 
				      + "\nAverage speed: " + 10000000/1024 * iso.totfilesize/(DtStopNow.Ticks - DtStartNow.Ticks) + "kb/s");
			else
			{
				popup.Info("You cancelled the operation or there has been an error.\n\n" +
							"You will need to reboot the XBOX if your dashboard is Avalaunch.");
				tmptime = null;
				progress = null;
				System.GC.Collect();
				Console.WriteLine("Aborted xISO extraction.\n");
				
				return false;
			}
			
			tmptime = null;
			progress = null;
			// Can't be null, it is a global.
			// we might need later.
			// iso = null;
			// Ask to clean the memory
			System.GC.Collect();
			Console.WriteLine("End Extract xISO\n");
			return true;
		}
		
		#region Treeview_event_right_click Scan Titles
		[GLib.ConnectBefore]
		public void OnTreeviewButtonPressEvent (object o, ButtonPressEventArgs args)
		{
		    Gdk.EventButton eb = args.Event;
			#if ( DEBUG )
				Console.WriteLine ("Button click");
			#endif
			 switch (args.Event.Button)
            {
                case 3:
                        PopupMenuGame (args.Event);
                        break;
        		case 1:
        				#if ( DEBUG )
        					Console.WriteLine ("First click");
            			#endif
        				break;
            } 
		}
		
        private void PopupMenuGame (EventButton ev)
        {
        	#if ( DEBUG )
            	Console.WriteLine ("Popup Menu!");
            #endif
            if (menu == null)
            {
                    menu = new Menu ();
                    AccelGroup group = new AccelGroup ();
               		ImageMenuItem item;
				
					item = new ImageMenuItem (Stock.Execute, group);
            		item.Activated += new EventHandler (OnToolbarLaunchClicked);
            		menu.Append (item);       	
            	
            		item = new Gtk.ImageMenuItem ("Edit", group);
            		pix = new Gdk.Pixbuf (null, "edit.png");
					new Gtk.Image (pix);
            		item.Image = new Gtk.Image (pix);
            		item.Activated += new EventHandler (OnToolbarRenameClicked);
				    menu.Append (item);

                    item = new ImageMenuItem (Stock.Delete, group);
            		item.Activated += new EventHandler (OnToolbarDeleteClicked);
                    menu.Append (item);                                   	
            }
            
            menu.ShowAll ();
            menu.Popup (null, null, null, IntPtr.Zero,
                            (ev != null) ? ev.Button : 0, (ev != null) ? ev.Time : 0);
   		} 
        
        private void PopupMenuCb(object o, PopupMenuArgs args)
        {
        	#if ( DEBUG )
            	Console.WriteLine ("Popup Menu Called!");
            #endif
            PopupMenuGame (null);
        } 
		#endregion
		
		#region Treeview_event_right_click Upload ISO
		[GLib.ConnectBefore]
		public void OnTreeviewUploadISOButtonPressEvent (object o, ButtonPressEventArgs args)
		{
		    Gdk.EventButton eb = args.Event;
			#if ( DEBUG )
				Console.WriteLine ("Button click");
			#endif
			 switch (args.Event.Button)
            {
                case 3:
                        PopupMenuIso (args.Event);
                        break;
        		case 1:
        				#if ( DEBUG )
        					Console.WriteLine ("First click");
            			#endif
        				break;
            } 
		}
		
        private void PopupMenuIso (EventButton ev)
        {
        	#if ( DEBUG )
            	Console.WriteLine ("Popup Menu Iso!");
            #endif
            if (menuiso == null)
            {
                    menuiso = new Menu ();
                    AccelGroup group = new AccelGroup ();
               		ImageMenuItem item;
				
				/*	item = new ImageMenuItem (Stock.Delete, group);
            		item.Activated += new EventHandler (OnToolbarDeleteXisoClicked);
            		menuiso.Append (item); // Will be done with the glade UI      	
				*/
                    item = new ImageMenuItem (Stock.Clear, group);
            		item.Activated += new EventHandler (OnToolbarClearBatchClicked);
                    menuiso.Append (item);                                   	
            }
            
            menuiso.ShowAll ();
            menuiso.Popup (null, null, null, IntPtr.Zero,
                            (ev != null) ? ev.Button : 0, (ev != null) ? ev.Time : 0);
   		} 
        
        public void OnToolbarClearBatchClicked (object o, EventArgs args)
		{
			OnToolbarClearBatchClicked();
		}
        
        private void PopupMenuIsoCb(object o, PopupMenuArgs args)
        {
        	#if ( DEBUG )
            	Console.WriteLine ("Popup Menu Iso Called!");
            #endif
            PopupMenuIso (null);
        } 
		#endregion
		
		// Each arg is a new column
		public void AddTextToRow (params string[] args)
		{	
			iter = store.AppendValues(args);
			tv.Model = store;
		}		
			
		// Each arg is a new column
		public void AddISOInfoToRow (params string[] args)
		{	
			iter2 = store2.AppendValues(args);
			tv2.Model = store2;
		}
		
		public void RefreshBatchInfo()
		{
			int job = 0;
			int size = 0;
			int files = 0;
			string sel;
			string[] strsize;
			
			if (store2.GetIterFirst(out iter2))
			{
				//tv2.ActivateRow(store2.GetPath(iter2), 0);
				job++;
				sel = (string)store2.GetValue(iter2, 1);
				strsize = sel.Split(' ');
				size = Int32.Parse(strsize[0]);
				files = Int32.Parse((string)store2.GetValue(iter2, 6));
				#if (DEBUG)
					Console.WriteLine(strsize[0].ToString() + "  " + 
				                  (string)store2.GetValue(iter2, 6) + "  " + 
				                  (string)store2.GetValue(iter2, 7));
				#endif
				while (store2.IterNext(ref iter2)) {
					#if (DEBUG) 
						Console.WriteLine((string)store2.GetValue(iter2, 1) + "  " +
					                  (string)store2.GetValue(iter2, 6) + "  " +
					                  (string)store2.GetValue(iter2, 7));
					#endif				
					job++;
					sel = (string)store2.GetValue(iter2, 1);
					strsize = sel.Split(' ');
					size = Int32.Parse(strsize[0]) + size;
					files = Int32.Parse((string)store2.GetValue(iter2, 6)) + files;
				}
			}
			labelnbbatchentry.Text = job.ToString();
			labelnbbatchsize.Text = size.ToString() + " MB";
			labelnbbatchfiles.Text = files.ToString();
			sel = null;
			strsize = null;
		}

		// When press Enter Entrygamexbe modify liststore
		private void OnEntrygamexbeActivated(object o, EventArgs args)
		{
			//Console.WriteLine(Entrygamexbe.Text);
			store2.GetIterFirst(out iter2);
			if (tv2.Selection.IterIsSelected(iter2))
			{
				store2.SetValue(iter2, 0, Entrygamexbe.Text.ToString());
			}
			while (store2.IterNext(ref iter2)) 
			{
				if ( tv2.Selection.IterIsSelected(iter2)) {
					store2.SetValue(iter2, 0, Entrygamexbe.Text.ToString());
				}
			}
		}
		
		// When press Enter Entrygamedir modify liststore
		private void OnEntrygamedirActivated(object o, EventArgs args)
		{
			//Console.WriteLine(Entrygamedir.Text);
			store2.GetIterFirst(out iter2);
			if (tv2.Selection.IterIsSelected(iter2))
			{
				store2.SetValue(iter2, 2, Entrygamedir.Text.ToString());
			}
			while (store2.IterNext(ref iter2)) 
			{
				if ( tv2.Selection.IterIsSelected(iter2)) {
					store2.SetValue(iter2, 2, Entrygamedir.Text.ToString());
				}
			}
		}
		
		// When press Enter Entryxboxdir modify liststore
		private void OnEntryxboxdirActivated(object o, EventArgs args)
		{
			//Console.WriteLine(Entryxboxdir.Text);
			store2.GetIterFirst(out iter2);
			if (tv2.Selection.IterIsSelected(iter2))
			{
				store2.SetValue(iter2, 5, Entryxboxdir.Text.ToString());
			}
			while (store2.IterNext(ref iter2)) 
			{
				if ( tv2.Selection.IterIsSelected(iter2)) {
					store2.SetValue(iter2, 5, Entryxboxdir.Text.ToString());
				}
			}
		}
			
		// Get single selection click on liststore ISO
		private void on_ISOList_selection(object o, EventArgs args)
		{				
			store2.GetIterFirst(out iter2);
			if (tv2.Selection.IterIsSelected(iter2))
			{
				labelR1.Text  = (string)store2.GetValue(iter2, 1);
				labelR2.Text = (string)store2.GetValue(iter2, 6);
				labelR3.Text = (string)store2.GetValue(iter2, 7);
				Entrygamexbe.Text = (string)store2.GetValue(iter2, 0);
				Entryxboxdir.Text = (string)store2.GetValue(iter2, 5);
				Entrygamedir.Text = (string)store2.GetValue(iter2, 2);
				#if (DEBUG) 
					Console.WriteLine((string)store2.GetValue(iter2, 1) + " " + (string)store2.GetValue(iter2, 7)  + " " +(string)store2.GetValue(iter2, 6));
				#endif	
			}
			while (store2.IterNext(ref iter2)) 
			{
				if ( tv2.Selection.IterIsSelected(iter2)) {
				labelR1.Text  = (string)store2.GetValue(iter2, 1);
				labelR2.Text = (string)store2.GetValue(iter2, 6);
				labelR3.Text = (string)store2.GetValue(iter2, 7);
				Entrygamexbe.Text = (string)store2.GetValue(iter2, 0);
				Entryxboxdir.Text = (string)store2.GetValue(iter2, 5);
				Entrygamedir.Text = (string)store2.GetValue(iter2, 2);
				#if (DEBUG) 
					Console.WriteLine((string)store2.GetValue(iter2, 1) + " " + (string)store2.GetValue(iter2, 7)  + " " +(string)store2.GetValue(iter2, 6));
				#endif	
				}
			}

		}
		
		// Get single selection click on liststore
		private void on_List_selection(object o, EventArgs args)
		{	
			string sel;

			store.GetIterFirst(out iter);
			if (tv.Selection.IterIsSelected(iter)) 
			{
				sel = (string)store.GetValue(iter, 0);
				labelIDresult.Text = (string)store.GetValue(iter, 6);
				labelSpaceresult.Text = (string)store.GetValue(iter, 7) + " MB";
				labelSlackresult.Text = (string)store.GetValue(iter, 8) + " MB";
				#if ( DEBUG )
					Console.WriteLine("Result First sel: " + sel);
				#endif
				
				UpdateSelectedTitleImage((string)store.GetValue(iter, 6));
				if (CurrentGame != null)
				{
					CurrentGame.Clear();
				}
				// Create my list of the current game with info i need 
				CurrentGame.Add(sel); // name
				CurrentGame.Add((string)store.GetValue(iter, 9)); // XBE
				CurrentGame.Add((string)store.GetValue(iter, 10)); // dir
				CurrentGame.Add(labelIDresult.Text); // ID
				#if ( DEBUG )
					Console.WriteLine("Nb info in CurrentGame: " + CurrentGame.Count);
					Console.WriteLine("==> {0},{1},{2},{3}", CurrentGame[0],
					                  CurrentGame[1], CurrentGame[2],
					                  CurrentGame[3]);
				#endif
			}
			
			while (store.IterNext(ref iter)) {
				if ( tv.Selection.IterIsSelected(iter)) {
					sel = (string)store.GetValue(iter, 0);
					labelIDresult.Text = (string)store.GetValue(iter, 6);
					labelSpaceresult.Text = (string)store.GetValue(iter, 7) + " MB";
					labelSlackresult.Text = (string)store.GetValue(iter, 8) + " MB";
					#if ( DEBUG )
						Console.WriteLine("Result sel: " + sel);
					#endif
					
					UpdateSelectedTitleImage((string)store.GetValue(iter, 6));
					if (CurrentGame != null)
					{
						CurrentGame.Clear();
					}
					// Create my list of the current game with info i need 
					CurrentGame.Add(sel); // name
					CurrentGame.Add((string)store.GetValue(iter, 9)); // XBE
					CurrentGame.Add((string)store.GetValue(iter, 10)); // dir
					CurrentGame.Add(labelIDresult.Text); // ID
					#if ( DEBUG )
						Console.WriteLine("Nb info in CurrentGame: " + CurrentGame.Count);
						Console.WriteLine("==> {0},{1},{2},{3}", CurrentGame[0],
						                  CurrentGame[1], CurrentGame[2],
						                  CurrentGame[3]);
					#endif	
				}
			}
			sel = null;
		}

		// Get Pixbuf from BMP image for title		
	    static Gdk.Pixbuf GetPixbufFromFile (string filename)
	    {
	        try {
	            Pixbuf p = new Pixbuf (filename);
	            return p;
	
	        } catch (GLib.GException e) {
	            Console.WriteLine (e.GetType ());
	            Console.WriteLine ("Cannot Open image file.");
	           	// Don't know but it kill the application
	            //Environment.Exit (1);
	            return null;
	        }
	
	    }
	
		public void UpdateSelectedTitleImage(string id)
		{
			if (DLicons.Active)
			{
				try
				{
				// Bad this is growing in memory for each image pixbuf .
				// event if the image was all ready open
				Pixbuf p = GetPixbufFromFile ("titleimage/" + id + ".bmp");
				image.Pixbuf = p;
				}	
				catch(Exception e) {
					Console.WriteLine("Error: Unable to open cache icon file.");
					Console.WriteLine(e.Message);
					AppendText("Error: Unable to open cache icon file." + e.Message);
					return;
				}	
			}
		}
					
		//
		// **** NEW ******
		//
		private void updateSummary(Parser.Summary s)
		{
			// Put all result to Label to show All Tiltles info
			labelAlltitlesResult.Text = s.nbTitles.ToString();
			labelAllfilesResult.Text = s.totnbFiles.ToString();
			labelAllfoldersResult.Text = s.totnbFolders.ToString();
			labelAllsizeResult.Text = s.totSizeMb;
			labelAllspaceResult.Text = s.totSpaceMb;
			labelAllslackResult.Text = s.slackMb;
			
			updateGameInformation(s.info);
		}
		
		private void updateGameInformation(ArrayList info)
		{
			// Sort title by game title
			store.SetSortColumnId(0, SortType.Ascending);
			
			#if (DEBUG)
				Console.WriteLine("Number of games: " + info.Count);
			#endif
			
			foreach(string[] game in info)
			{
				AddTextToRow(game);
			}
		}
		
		private void updateLabelResults(string[] rootspace)
		{
			foreach(string space in rootspace)
			{
				//Console.WriteLine("Space:" + space + "]");
				string[] free = space.Split(' ');
				//Console.WriteLine("[" + free[24].ToString() +"] == [" + Entryxboxdir.Text.Substring(0, 2) +"]");
				if(free[24].Equals("C:"))
				{
					labelResultDriveC.Text = free[26].ToString() + " MB";
				}
				else if(free[24].Equals("E:"))
				{
					labelResultDriveE.Text = free[26].ToString() + " MB";
				}
				else if(free[24].Equals("F:"))
				{
					labelResultDriveF.Text = free[26].ToString() + " MB";
				}
				if((cfg.getGDrive() == true) && free[24].Equals("G:"))
				{
					labelResultDriveF.Text = free[26].ToString() + " MB";
					labelResultDriveG.Visible = true;
					DriveG.Visible = true;
				}
				else
				{
					labelResultDriveG.Visible = false;
					DriveG.Visible = false;
				}
				free = null;
			}
		}
		
		private bool ReadConf()
		{
			cfg.ReadConf();

			// Check Conf
			if(cfg.getFtpInfo().getIp() == null)
				return false;

			// Update configuration in the ftp connection controller
			ftpToXbox.setConfiguration(cfg);

			return true;
		}
	}
} // End NameSpace
