unit IdIntercept;

interface

uses
  Classes,
  IdBaseComponent;

type
  TIdConnectionIntercept = class;
  TIdInterceptNotifyEvent = procedure(ASender: TIdConnectionIntercept) of object;
  TIdInterceptStreamEvent = procedure(ASender: TIdConnectionIntercept; AStream: TStream) of object;

  TIdConnectionIntercept = class(TIdBaseComponent)
  protected
    FConnection: TComponent;
    FIsClient: Boolean;
    FOnConnect: TIdInterceptNotifyEvent;
    FOnDisconnect: TIdInterceptNotifyEvent;
    FOnReceive: TIdInterceptStreamEvent;
    FOnSend: TIdInterceptStreamEvent;
  public
    procedure Connect(AConnection: TComponent); virtual;
    constructor Create(AOwner: TComponent); override;
    procedure Disconnect; virtual;
    procedure Receive(ABuffer: TStream); virtual;
    procedure Send(ABuffer: TStream); virtual;
    //
    property Connection: TComponent read FConnection;
    property IsClient: Boolean read FIsClient;
  published
    property OnConnect: TIdInterceptNotifyEvent read FOnConnect write FOnConnect;
    property OnDisconnect: TIdInterceptNotifyEvent read FOnDisconnect write FOnDisconnect;
    property OnReceive: TIdInterceptStreamEvent read FOnReceive write FOnReceive;
    property OnSend: TIdInterceptStreamEvent read FOnSend write FOnSend;
  end;

  TIdServerIntercept = class(TIdBaseComponent)
  public
    procedure Init; virtual; abstract;
    function Accept(AConnection: TComponent): TIdConnectionIntercept; virtual; abstract;
  end;

implementation

{ TIdIntercept }

procedure TIdConnectionIntercept.Disconnect;
begin
  if Assigned(OnDisconnect) then begin
    OnDisconnect(Self);
  end;
  FConnection := nil;
end;

procedure TIdConnectionIntercept.Connect(AConnection: TComponent);
begin
  FConnection := AConnection;
  if Assigned(OnConnect) then begin
    OnConnect(Self);
  end;
end;

constructor TIdConnectionIntercept.Create(AOwner: TComponent);
begin
  inherited;
  FIsClient := True;
end;

procedure TIdConnectionIntercept.Receive(ABuffer: TStream);
begin
  if Assigned(OnReceive) then begin
    OnReceive(Self, ABuffer);
  end;
end;

procedure TIdConnectionIntercept.Send(ABuffer: TStream);
begin
  if Assigned(OnSend) then begin
    OnSend(Self, ABuffer);
  end;
end;

end.
