unit IdAssignedNumbers;

interface

{These values are all from RFC 1700}

const  {Port values}
  IdPORT_TCPMUX  = 1;
  IdPORT_COMPRESSNET_MGM = 2; //Management Utility
  IdPORT_COMPRESSNET_CMP = 3; //Compression Proces
  IdPORT_RJE     = 5;  //Remote Job Entry
  IdPORT_ECHO    = 7;
  IdPORT_DISCARD = 9;
  IdPORT_SYSTAT  = 11;
  IdPORT_DAYTIME = 13;
  IdPORT_NETSTAT = 15;
  IdPORT_QOTD    = 17;
  IdPORT_MSP     = 18;  //Message Send Protocol
  IdPORT_CHARGEN = 19; {UDP Server!}
  IdPORT_FTP_DATA = 20; //FTP Data default port
  IdPORT_FTP     = 21;
  IdPORT_SSH     = 22; //SSH Remote Login Protocol
  IdPORT_TELNET  = 23;
  IdPORT_ANYTERMINIL = 24; //any private mail system
  IdPORT_SMTP    = 25;
  IdPORT_NSW_FE  = 27; //NSW New User System FE
  IdPORT_MSG_ICMP = 29;
  IdPORT_MSG_AUTH = 31; //MSG Authentication
  IdPORT_DSP     = 33; //Display Support Protocol
  IdPORT_ANYPRINTER = 34; //any private printer server

  IdPORT_TIME    = 37;
  IdPORT_RAP     = 38; //Remote Access Protocol
  IdPORT_RLP     = 39; //Resource Location Protocol
  IdPORT_GRAPHICS = 41; //Graphics
  IdPORT_NAMESERVER = 42;  //Host Name Server
  IdPORT_WHOIS   = 43;
  IdPORT_MPM_FLAGS = 44; //MPM Flags Protocol
  IdPORT_MPM       = 45; //Message Processing Protocol
  IdPORT_MPM_SND   = 46; //MPM (Default Send)
  IdPORT_NI_FTP    = 47;
  IdPORT_AUDITD    = 48; //Digital Audit Daemon
  IdPORT_BBN_LOGIN = 49; //Login Host Protocol
  IdPORT_RE_MAIL_CK = 50; //Remote Mail Checking Protocol
  IdPORT_LA_MAINT  = 51; //IMP Logical Address Maintenance
  IdPORT_XNS_TIME  = 52; //XNS Time Protocol
  IdPORT_DOMAIN  = 53;
  IdPORT_XNS_CH  = 54; //XNS Clearinghouse
  IdPORT_ISI_GL  = 55; //ISI Graphics Language
  IdPORT_XNS_AUTH = 56; //XNS Authentication
  IdPORT_ANYPRIVATE_TERMINAL = 57; //any private terminal access
  IdPORT_XNS_MAIL = 58; //XNS Mail
  IdPORT_ANY_FILE = 59; // Any private file service
  IdPORT_NI_MAIL = 61;
  IdPORT_ACAS    = 62; //ACA Services
  IdPORT_WHOIS_PLUS = 63; //WhoIs++
  IdPORT_COVIA   = 64;  //Communications Integrator (CI)
  IdPORT_TACACS_DS = 65; //  TACACS-Database Service
  IdPORT_SQLNET = 66; //Oracle SQL*NET
  IdPORT_BOOTPS = 67; //Bootstrap Protocol Server - DHCP uses this as well
  IdPORT_BOOTPC = 68; //Bootstrap Protocol Client - DHCP uses this as well
  IdPORT_TFTP    = 69;
  IdPORT_GOPHER  = 70;
  IdPORT_NETRJS1 = 71; //Network Job Service
  IdPORT_NETRJS2 = 72;
  IdPORT_NETRJS3 = 73;
  IdPORT_NETRJS4 = 74;
  IdPORT_ANYDIAL = 75; //Any dial-out service
  IdPORT_DEOS    = 76; //Distributed External Object Store
  IdPORT_ANYRJE  = 77; //Any RJE Service
  IdPORT_VETTCP  = 78;
  IdPORT_FINGER  = 79;
  IdPORT_HTTP    = 80;
  IdPORT_HOSTS2_NS = 81; //HOSTS2 Name Server
  IdPORT_XFER    = 82; //XFER Utility
  IdPORT_MIT_ML_DEV = 83; //MIT ML Device
  IdPORT_CTF     = 84; //Common Trace Facility
  IdPORT_MIT_ML_DEV2 = 85; //MIT ML Device
  IdPORT_MFCOBOL = 86; //Micro Focus Cobol
  IdPORT_ANYTERMINALLINK = 87; //Any private terminal link
  IdPORT_KERBEROS = 88; //kerberos
  IdPORT_SU_MIT_TG = 89; //SU/MIT Telnet Gateway
  IdPORT_DNSIX = 90; // DNSIX Securit Attribute Token Map
  IdPORT_MIT_DOV = 91; //MIT Dover Spooler
  IdPORT_NPP = 92; //Network Printing Protocol
  IdPORT_DCP = 93; //Device Control Protocol
  IdPORT_OBJCALL = 94; //Tivoli Object Dispatcher
  IdPORT_SUPDUP = 95; //SUPDUP
  IdPORT_DIXIE = 96;  //DIXIE Protocol Specification
  IdPORT_SWIFT_RVF = 97; //Swift Remote Virtural File Protocol
  IdPORT_TACNEWS = 98; //TAC News
  IdPORT_METAGRAM = 99; //    Metagram Relay
  IdPORT_NEWACCT = 100; //    [unauthorized use]
  IdPORT_HOSTNAME = 101;
  IdPORT_ISO_TSAP = 102; // ISO-TSAP Class 0
  IdPORT_GPPITNP = 103; // Genesis Point-to-Point Trans Net
  IdPORT_ACR_NAME = 104; //ACR-NEMA Digital Imag. & Comm. 300
  IdPORT_CSNET_NS = 105; //  Mailbox Name Nameserver
  IdPORT_3COM_TSMUX = 106; //  3COM-TSMUX
  IdPORT_RTELNET = 107;// Remote Telnet Service
  IdPORT_SNAGAS  = 108;// SNA Gateway Access Server
  IdPORT_POP2    = 109;
  IdPORT_POP3    = 110;
  IdPORT_SUNRPC  = 111;// SUN Remote Procedure Call
  IdPORT_McIDAS  = 112;// McIDAS Data Transmission Protocol
  {This is called AUT in the RFC.  The protocol was renamed to IdentD to better
  refect what the protocol was doing}
  IdPORT_AUTH    = 113;
  IdPORT_AUDIONEWS = 114;//  Audio News Multicast
  IdPORT_SFTP = 115; //tcp  Simple File Transfer Protocol
  IdPORT_ANSANOTIFY = 116; //  ANSA REX Notify
  IdPORT_UUCP_PATH = 117; // UUCP Path Service
  IdPORT_SQLSERV = 118;//tcp    SQL Services
  IdPORT_NNTP    = 119;
  IdPORT_CFDPTKT = 120;//tcp    CFDPTKT
  IdPORT_ERPC = 121;//tcp    Encore Expedited Remote Pro.Call
  IdPORT_SMAKYNET = 122;//tcp    SMAKYNET
  IdPORT_SNTP    = 123;
  IdPORT_ANASTRADER = 124;// ANSA REX Trader
  IdPORT_LOCUS_MAP = 125;// Locus PC-Interface Net Map Ser
  IdPORT_UNITARY = 126;// Unisys Unitary Login
  IdPORT_locus_con = 127;// Locus PC-Interface Conn Server
  IdPORT_GSS_XLICEN = 128;//  GSS X License Verification
  IdPORT_PWDGEN = 129;//    Password Generator Protocol
  IdPORT_CISCO_FNA = 130;// cisco FNATIVE
  IdPORT_cisco_tna = 131;// cisco TNATIVE
  IdPORT_cisco_sys = 132;//cisco SYSMAINT
  IdPORT_statsrv = 133;// Statistics Service
  IdPORT_ingres_net = 134;//INGRES-NET Service
  IdPORT_loc_srv = 135;//Location Service
  IdPORT_profile = 136;// PROFILE Naming System
  IdPORT_netbios_ns = 137;//  NETBIOS Name Service
  IdPORT_netbios_dgm = 138;// NETBIOS Datagram Service
  IdPORT_netbios_ssn = 139;// NETBIOS Session Service
  IdPORT_emfis_data = 140;//  EMFIS Data Service
  IdPORT_emfis_cntl = 141;// EMFIS Control Service
  IdPORT_bl_idm     = 142;//Britton-Lee IDM
  IdPORT_IMAP4      = 143;
  IdPORT_news       = 144;//NewS
  IdPORT_uaac       = 145;//UAAC Protocol
  IdPORT_iso_tp0    = 146;//ISO-IP0
  IdPORT_iso_ip     = 147;//ISO-IP
  IdPORT_cronus     = 148;//CRONUS-SUPPORT
  IdPORT_aed_512    = 149;//AED 512 Emulation Service
  IdPORT_sql_net    = 150;//SQL-NET
  IdPORT_hems       = 151;//HEMS
  IdPORT_bftp       = 152;// Background File Transfer Program
  IdPORT_sgmp       = 153;// SGMP
  IdPORT_netsc_prod = 154;// NETSC
  IdPORT_netsc_dev  = 155;// NETSC
  IdPORT_sqlsrv     = 156;// SQL Service
  IdPORT_knet_cmp   = 157;// KNET/VM Command/Message Protocol
  IdPORT_pcmail_srv = 158;// PCMail Server
  IdPORT_nss_routing = 159;// NSS-Routing
  IdPORT_sgmp_traps  = 160;// SGMP-TRAPS
  IdPORT_snmp        = 161;// SNMP
  IdPORT_snmptrap    = 162;// SNMPTRAP
  IdPORT_cmip_man    = 163;// CMIP/TCP Manager
  IdPORT_cmip_agent  = 164;// CMIP/TCP Agent
  IdPORT_xns_courier = 165;// Xerox
  IdPORT_s_net       = 166;// Sirius Systems
  IdPORT_namp        = 167;// NAMP
  IdPORT_rsvd        = 168;// tcp    RSVD
  IdPORT_send        = 169;//tcp    SEND
  IdPORT_print_srv   = 170;//tcp    Network PostScript
  IdPORT_multiplex   = 171;// Network Innovations Multiplex
  IdPORT_cl_1        = 172;//Network Innovations CL/1
  IdPORT_xyplex_mux  = 173;//Xyplex
  IdPORT_mailq      = 174; //    MAILQ
  IdPORT_vmnet       = 175;//  VMNET
  IdPORT_genrad_mux   = 176;//   GENRAD-MUX
  IdPORT_xdmcp        = 177;// X Display Manager Control Protocol
  IdPORT_NextStep     = 178;//    NextStep Window Server
  IdPORT_bgp          = 179;//    Border Gateway Protocol
  IdPORT_ris          = 180;//  Intergraph
  IdPORT_unify        = 181;//  Unify
  IdPORT_audit        = 182;//   Unisys Audit SITP
  IdPORT_ocbinder     = 183;//    OCBinder
  IdPORT_ocserver     = 184;//    OCServer
  IdPORT_remote_kis   = 185;//   Remote-KIS
  IdPORT_kis          = 186;//    KIS Protocol
  IdPORT_aci          = 187;//   Application Communication Interface
  IdPORT_mumps        = 188;// Plus Five's MUMPS
  IdPORT_qft          = 189;// Queued File Transport
  IdPORT_gacp         = 190;//   Gateway Access Control Protocol
  IdPORT_prospero     = 191;//  Prospero Directory Service
  IdPORT_osu_nms      = 192;//  OSU Network Monitoring System
  IdPORT_srmp         = 193;// Spider Remote Monitoring Protocol
{not sure about this one
irc             194/tcp    Internet Relay Chat Protocol
irc             194/udp    Internet Relay Chat Protocol
#                          Jarkko Oikarinen <jto@TOLSUN.OULU.FI>
}
  IdPORT_dn6_nlm_aud  = 195;// DNSIX Network Level Module Audit
  IdPORT_dn6_smm_red  = 196;// DNSIX Session Mgt Module Audit Redir
  IdPORT_dls          = 197;// Directory Location Service
  IdPORT_dls_mon      = 198;// Directory Location Service Monitor
  IdPORT_smux         = 199;//SMUX
  IdPORT_src          = 200;//IBM System Resource Controller
  IdPORT_at_rtmp      = 201;//AppleTalk Routing Maintenance
  IdPORT_at_nbp       = 202;//ppleTalk Name Binding
  IdPORT_at_3         = 203;//AppleTalk Unused
  IdPORT_at_echo      = 204;//AppleTalk Echo
  IdPORT_at_5         = 205;//AppleTalk Unused
  IdPORT_at_zis       = 206;//AppleTalk Zone Information
  IdPORT_at_7         = 207;//AppleTalk Unused
  IdPORT_at_8         = 208;//AppleTalk Unused
  IdPORT_qmtp         = 209;//the Quick Mail Transfer Protocol
  IdPORT_z39_50       = 210;//ANSI Z39.50
  IdPORT_914c_g       = 211;//Texas Instruments 914C/G Terminal
  IdPORT_anet         = 212;//ATEXSSTR
  IdPORT_ipx          = 213;//IPX
  IdPORT_vmpwscs      = 214;//VM PWSCS
  IdPORT_softpc       = 215;//Insignia Solutions
  IdPORT_CAIlic       = 216;//Computer Associates Int'l License Server
  IdPORT_dbase        = 217;//dBASE Unix
  IdPORT_mpp          = 218;// Netix Message Posting Protocol
  IdPORT_uarps        = 219;// Unisys ARPs
  IdPORT_imap3        = 220;// Interactive Mail Access Protocol v3
  IdPORT_fln_spx      = 221;// Berkeley rlogind with SPX auth
  IdPORT_rsh_spx      = 222;// Berkeley rshd with SPX auth
  IdPORT_cdc          = 223;//Certificate Distribution Center

  IdPORT_sur_meas     = 243;// Survey Measurement

  IdPORT_link         = 245;// LINK
  IdPORT_dsp3270      = 246;// Display Systems Protocol
  IdPORT_pdap         = 344;// Prospero Data Access Protocol
  IdPORT_pawserv      = 345;// Perf Analysis Workbench
  IdPORT_zserv        = 346;//Zebra server
  IdPORT_fatserv      = 347;//Fatmen Server
  IdPORT_csi_sgwp     = 348;//Cabletron Management Protocol

  IdPORT_clearcase    = 371;//Clearcase
  IdPORT_ulistserv    = 372;//Unix Listserv
  IdPORT_legent_1     = 373;//Legent Corporation
  IdPORT_legent_2     = 374;//Legent Corporation
  IdPORT_hassle       = 375;//Hassle
  IdPORT_nip          = 376; // Amiga Envoy Network Inquiry Proto
  IdPORT_tnETOS       = 377;//NEC Corporation
  IdPORT_dsETOS       = 378;//NEC Corporation
  IdPORT_is99c        = 379;//TIA/EIA/IS-99 modem client
  IdPORT_is99s        = 380;//TIA/EIA/IS-99 modem server
  IdPORT_hp_collector = 381;//hp performance data collector
  IdPORT_hp_managed_node = 382;//hp performance data managed node
  IdPORT_hp_alarm_mgr  = 383;//hp performance data alarm manager
  IdPORT_arns          = 384;//A Remote Network Server System
  IdPORT_ibm_app       = 385;//IBM Application
  IdPORT_asa           = 386;//ASA Message Router Object Def.
  IdPORT_aurp          = 387;//Appletalk Update-Based Routing Pro.
  IdPORT_unidata_ldm   = 388;//Unidata LDM Version 4
  IdPORT_ldap          = 389;//Lightweight Directory Access Protocol
  IdPORT_uis           = 390;//UIS
  IdPORT_synotics_relay = 391;//SynOptics SNMP Relay Port
  IdPORT_synotics_broker = 392;//SynOptics Port Broker Port
  IdPORT_dis            = 393;//Data Interpretation System
  IdPORT_embl_ndt       = 394;//EMBL Nucleic Data Transfer
  IdPORT_etcp           = 395;//NETscout Control Protocol
  IdPORT_netware_ip     = 396;//Novell Netware over IP
  IdPORT_mptn           = 397;//Multi Protocol Trans. Net.
  IdPORT_kryptolan      = 398;//Kryptolan
  IdPORT_iso_tsap_c2    = 399;//ISO Transport Class 2 Non-Control over TCP
  IdPORT_work_sol       = 400;//Workstation Solutions
  IdPORT_ups            = 401;//Uninterruptible Power Supply
  IdPORT_genie          = 402;//Genie Protocol
  IdPORT_decap          = 403;//decap
  IdPORT_nced           = 404;//nced
  IdPORT_ncld           = 405;//ncld
  IdPORT_imsp           = 406;//Interactive Mail Support Protocol
  IdPORT_timbuktu       = 407;//Timbuktu
  IdPORT_prm_sm         = 408;//Prospero Resource Manager Sys. Man.
  IdPORT_prm_nm         = 409;//Prospero Resource Manager Node Man.
  IdPORT_decladebug     = 410;//DECLadebug Remote Debug Protocol
  IdPORT_rmt            = 411;//Remote MT Protocol
  IdPORT_synoptics_trap = 412;//Trap Convention Port
  IdPORT_smsp           = 413;//SMSP
  IdPORT_infoseek       = 414;//InfoSeek
  IdPORT_bnet           = 415;//BNet
  IdPORT_silverplatter  = 416;//Silverplatter
  IdPORT_onmux          = 417;//Onmux
  IdPORT_hyper_g        = 418;//Hyper-G
  IdPORT_ariel1         = 419;//Ariel
  IdPORT_smpte          = 420;//SMPTE
  IdPORT_ariel2         = 421;//Ariel
  IdPORT_ariel3         = 422;//Ariel
  IdPORT_opc_job_start  = 423;//IBM Operations Planning and Control Start
  IdPORT_opc_job_track  = 424;//IBM Operations Planning and Control Track
  IdPORT_icad_el        = 425;//ICAD
  IdPORT_smartsdp       = 426;//smartsdp
  IdPORT_svrloc         = 427;//Server Location
  IdPORT_ocs_cmu        = 428;//OCS_CMU
  IdPORT_ocs_amu        = 429;//OCS_AMU
  IdPORT_utmpsd         = 430;//UTMPSD
  IdPORT_utmpcd         = 431;//UTMPCD
  IdPORT_iasd           = 432;//IASD
  IdPORT_nnsp           = 433;//NNSP
  IdPORT_mobileip_agent = 434;//MobileIP-Agent
  IdPORT_mobilip_mn     = 435;//MobilIP-MN
  IdPORT_dna_cml        = 436;//DNA-CML
  IdPORT_comscm         = 437;//comscm
  IdPORT_dsfgw          = 438;//dsfgw
  IdPORT_dasp           = 439;//dasp      Thomas Obermair
  IdPORT_sgcp           = 440;//sgcp
  IdPORT_decvms_sysmgt  = 441;//decvms-sysmgt
  IdPORT_cvc_hostd      = 442;//cvc_hostd
  IdPORT_SSL     = 443;
  IdPORT_npp2    = 444;//Simple Network Paging Protocol [RFC1568]
  IdPORT_microsoft_ds = 445;//Microsoft-DS
  IdPORT_ddm_rdb = 446; //DDM-RDB
  IdPORT_ddm_dfm = 447;//DDM-RFM
  IdPORT_ddm_byte = 448;//DDM-BYTE
  IdPORT_as_servermap = 449;//AS Server Mapper
  IdPORT_tserver      = 450;//TServer
  IdPORT_sfs_smp_net  = 451;//Cray Network Semaphore server
  IdPORT_sfs_config = 452;//Cray SFS config server
  IdPORT_creativeserver = 453;//CreativeServer
  IdPORT_contentserver  = 454;//ContentServer
  IdPORT_creativepartnr = 455;//CreativePartnr
  IdPORT_macon_tcp      = 456;//macon-tcp
  IdPORT_scohelp        = 457;//scohelp
  IdPORT_appleqtc       = 458;//apple quick time
  IdPORT_ampr_rcmd      = 459;//ampr-rcmd
  IdPORT_skronk         = 460;//skronk
  IdPORT_datasurfsrv    = 461;//DataRampSrv
  IdPORT_datasurfsrvsec = 462;//DataRampSrvSec
  IdPORT_alpes          = 463;//alpes
  IdPORT_kpasswd        = 464;//kpasswd
  IdPORT_ssmtp          = 465;//ssmtp
  IdPORT_digital_vrc    = 466;//digital-vrc
  IdPORT_mylex_mapd     = 467;//mylex-mapd
  IdPORT_photuris       = 468;//proturis
  IdPORT_rcp            = 469;//Radio Control Protocol
  IdPORT_scx_proxy      = 470;//scx-proxy
  IdPORT_mondex         = 471;//Mondex
  IdPORT_ljk_login      = 472;//jk-login
  IdPORT_hybrid_pop     = 473;//hybrid-pop
  IdPORT_tn_tl_w1       = 474;//tcp    tn-tl-w1
  IdPORT_tn_tl_w2       = 474;//udp    tn-tl-w2
  IdPORT_tcpnethaspsrv  = 475;//tcp    tcpnethaspsrv
  IdPORT_tn_tl_fd1      = 476;//tn-tl-fd1
  IdPORT_ss7ns          = 477;//ss7ns
  IdPORT_spsc           = 478;//spsc
  IdPORT_iafserver      = 479;//iafserver
  IdPORT_iafdbase       = 480;//iafdbase
  IdPORT_ph             = 481;//Ph service
  IdPORT_bgs_nsi        = 482;//bgs-nsi
  IdPORT_ulpnet         = 483;//ulpnet
  IdPORT_integra_sme    = 484;//Integra Software Management Environment
  IdPORT_powerburst     = 485;//Air Soft Power Burst
  IdPORT_avian          = 486;//avian
  IdPORT_saft           = 487;//saft
  IdPORT_gss_http       = 488;//gss-http
  IdPORT_nest_protocol  = 489;//nest-protocol
  IdPORT_micom_pfs      = 490;//micom-pfs
  IdPORT_go_login       = 491;//go-login
  IdPORT_ticf_1         = 492;//Transport Independent Convergence for FNA
  IdPORT_ticf_2         = 493;//Transport Independent Convergence for FNA
  IdPORT_pov_ray        = 494;//tcp    POV-Ray

  Id_PORT_exec   = 512; {/tcp    remote process execution;
                          authentication performed using
                          passwords and UNIX loppgin names      }

  Id_PORT_biff   = 512;{udp    used by mail system to notify users
                          of new mail received; currently
                          receives messages only from
                          processes on the same machine }
  Id_PORT_login  = 513;{tcp    remote login a la telnet;
                          automatic authentication performed
                          based on priviledged port numbers
                          and distributed data bases which
                          identify "authentication domains"   }
  IdPORT_who     = 513;{udp    maintains data bases showing who's
                          logged in to machines on a local
                          net and the load average of the
                          machine }
  IdPORT_cmd     = 514;{tcp    like exec, but automatic
                           authentication is performed as for
                           login server }
  IdPORT_syslog  = 514;{udp }
  IdPORT_LPD     = 515;
  IdPORT_talk    = 517;{tcp    like tenex link, but across
                          machine - unfortunately, doesn't
                          use link protocol (this is actually
                          just a rendezvous port from which a
                          tcp connection is established)}
  IdPORT_ntalk   = 518;
  IdPORT_utime   = 519; //    unixtime
  IdPORT_efs     = 520; //tcp    extended file name server
  IdPORT_router  = 520; {udp    local routing process (on site);
                          uses variant of Xerox NS routing
                          information protocol    }
  IdPORT_timed   = 525; // timeserver
  IdPORT_tempo   = 526; // newdate
  IdPORT_courier = 530; // rpc
  IdPORT_conference = 531;//chat
  IdPORT_netnews    = 532;//readnews
  IdPORT_netwall    = 533;// for emergency broadcasts

  IdPORT_apertus_ldp = 539;// Apertus Technologies Load Determination
  IdPORT_uucp       = 540;// uucpd
  IdPORT_uucp_rlogin = 541;//uucp-rlogin
  IdPORT_klogin      = 543;//
  IdPORT_kshell      = 544;//krcmd
  IdPORT_appleqtcsrvr = 545; // appleqtcsrvr
  IdPORT_dhcp_client_v6  = 546; //DHCP Client   IP 6
  IdPORT_dhcp_server_v6  = 547; // DHCP Server  IP 6

  IdPORT_new_rwho     = 550; // new-who
  IdPORT_cybercash    = 551; // cybercash
  IdPORT_deviceshare  = 552; // deviceshare
  IdPORT_pirp         = 553; //  pirp

  IdPORT_dsf          = 555;
  IdPORT_remotefs     = 556; //rfs server
  IdPORT_openvms_sysipc = 557;// openvms-sysipc
  IdPORT_sdnskmp      = 558;// SDNSKMP
  IdPORT_teedtap      = 559;// TEEDTAP
  IdPORT_rmonitor     = 560;// rmonitord
  IdPORT_monitor      = 561;//
  IdPORT_chshell      = 562;// chcmd
  IdPORT_SNEWS        = 563;
  IdPORT_9pfs         = 564;/// plan 9 file service
  IdPORT_whoami       = 565;// whoami
  IdPORT_streettalk   = 566;// streettalk
  IdPORT_banyan_rpc   = 567;//banyan-rpc
  IdPORT_ms_shuttle   = 568;//microsoft shuttle
  IdPORT_ms_rome      = 569;//microsoft rome
  IdPORT_meter        = 570;//demon
  IdPORT_meter_udemon = 571;//udemon
  IdPORT_sonar        = 572;//sonar
  IdPORT_banyan_vip   = 573;//banyan-vip
  IdPORT_ftp_agent    = 574;//FTP Software Agent System
  IdPORT_vemmi        = 575;//VEMMI

  IdPORT_ipcserver    = 600;//Sun IPC server

  IdPORT_nqs          = 607;//nqs
  IdPORT_urm          = 606;//Cray Unified Resource Manager

  IdPORT_sift_uft     = 608;//Sender-Initiated/Unsolicited File Transfer
  IdPORT_npmp_trap    = 609;//npmp-trap
  IdPORT_npmp_local   = 610;//npmp-local
  IdPORT_npmp_gui     = 611;//npmp-gui

  IdPORT_servstat     = 633;// Service Status update (Sterling Software)
  IdPORT_ginad        = 634;// ginad

  IdPORT_mdqs         = 666;//
  IdPORT_doom         = 666;//doom Id Software

  IdPORT_elcsd        = 704;//errlog copy/server daemon

  IdPORT_entrustmanager = 709;//EntrustManager

  IdPORT_netviewdm1     = 729;//IBM NetView DM/6000 Server/Client
  IdPORT_netviewdm2     = 730;//IBM NetView DM/6000 send/tcp
  IdPORT_netviewdm3     = 731;//IBM NetView DM/6000 receive/tcp
  IdPORT_netgw          = 741;//netGW
  IdPORT_netrcs         = 742;//Network based Rev. Cont. Sys.

  IdPORT_flexlm         = 744;//Flexible License Manager

  IdPORT_fujitsu_dev    = 747;//Fujitsu Device Control
  IdPORT_ris_cm         = 748;//Russell Info Sci Calendar Manager
  IdPORT_kerberos_adm   = 749;//kerberos administration
  IdPORT_rfile          = 750;//tcp
  IdPORT_loadav         = 750;//udp
  IdPORT_pump           = 751;
  IdPORT_qrh            = 752;
  IdPORT_rrh            = 753;
  IdPORT_tell           = 754;// send
  IdPORT_nlogin         = 758;
  IdPORT_con            = 759;
  IdPORT_ns             = 760;
  IdPORT_rxe            = 761;
  IdPORT_quotad         = 762;
  IdPORT_cycleserv      = 763;
  IdPORT_omserv         = 764;
  IdPORT_webster        = 765;
  IdPORT_phonebook      = 767;// phone
  IdPORT_vid            = 769;
  IdPORT_cadlock        = 770;
  IdPORT_rtip   = 771;
  IdPORT_cycleserv2 = 772;
  IdPORT_submit = 773;//tcp
  IdPORT_notify = 773;//udp
  IdPORT_rpasswd = 774;//tcp
  IdPORT_acmaint_dbd = 774; //udp
  IdPORT_entomb = 775;
  IdPORT_acmaint_transd = 775;
  IdPORT_wpages = 776;
  IdPORT_wpgs   = 780;
  IdPORT_concert = 786;//Concert
  IdPORT_mdbs_daemon = 800;

  IdPORT_device = 801;

  IdPORT_accessbuilder = 888;//udp        AccessBuilder

  IdPORT_vsinet = 996;//tcp    vsinet
  IdPORT_maitrd = 997; //tcp
  IdPORT_busboy = 998;//tcp
  IdPORT_puparp = 998;//udp
  {There are port conflicts - beware}
  IdPORT_garcon = 999;//tcp
  IdPORT_applix = 999;//udp       Applix ac
  IdPORT_puprouter = 999;//tcp

  IdPORT_cadlock2 = 1000;//tcp
  IdPORT_ock = 1000;  //udp

  {These were added simply for compatibility and were not listed in RFC 1700}

  IdPORT_DICT    = 2628;
  IdPORT_IRC     = 6667;

const

  Id_AIVN_Rserved = 0;//                Reserved                                [JBP]
  Id_AIVN_IP = 4; //       IP       Internet Protocol                [RFC791,JBP]
  Id_AIVN_ST = 5; //       ST       ST Datagram Mode                [RFC1190,JWF]
  Id_AIVN_SIP = 6; //       SIP      Simple Internet Protocol                [RH6]
  Id_AIVN_TP_IX = 7; //       TP/IX    TP/IX: The Next Internet                [RXU]
  Id_AIVN_PIP = 8; //       PIP      The P Internet Protocol                 [PXF]
  Id_AIVN_Tuba = 9; //       TUBA     TUBA                                    [RXC]
  Id_AIVN_Reserved2 = 15; //                Reserved


const
  {Assigned Internet Protocol Numbers from RFC 1700}
  Id_AIPN_Reserved = 0;
  Id_AIPN_ICMP = 1; //     ICMP        Internet Control Message       [RFC792,JBP]
  Id_AIPN_IGMP = 2; //     IGMP        Internet Group Management     [RFC1112,JBP]
  Id_AIPN_GGP  = 3; //     GGP         Gateway-to-Gateway              [RFC823,MB]
  Id_AIPN_IP   = 4; //     IP          IP in IP (encasulation)               [JBP]
  Id_AIPN_ST   = 5; //     ST          Stream                 [RFC1190,IEN119,JWF]
  Id_AIPN_TCP  = 6; //     TCP         Transmission Control           [RFC793,JBP]
  Id_AIPN_UCL  = 7; //     UCL         UCL                                    [PK]
  Id_AIPN_EGP  = 8; //     EGP         Exterior Gateway Protocol     [RFC888,DLM1]
  Id_AIPN_IGP  = 9; //     IGP         any private interior gateway          [JBP]
  Id_AIPN_BBN_RCC_MON = 10; //     BBN-RCC-MON BBN RCC Monitoring                    [SGC]
  Id_AIPN_NVP_II = 11; //     NVP-II      Network Voice Protocol         [RFC741,SC3]
  Id_AIPN_PUP    = 12; //     PUP         PUP                             [PUP,XEROX]
  Id_AIPN_ARGUS  = 13; //     ARGUS       ARGUS                                [RWS4]
  Id_AIPN_EMCON  = 14; //    EMCON       EMCON                                 [BN7]
  Id_AIPN_XNET   = 15; //     XNET        Cross Net Debugger            [IEN158,JFH2]
  Id_AIPN_CHAOS  = 16; //     CHAOS       Chaos                                 [NC3]
  Id_AIPN_UDP    = 17; //     UDP         User Datagram                  [RFC768,JBP]
  Id_AIPN_MUX    = 18; //     MUX         Multiplexing                    [IEN90,JBP]
  Id_AIPN_DCN_MEAS = 19; //    DCN-MEAS    DCN Measurement Subsystems           [DLM1]
  Id_AIPN_HMP      = 20; //     HMP         Host Monitoring                [RFC869,RH6]
  Id_AIPN_PRM      = 21; //     PRM         Packet Radio Measurement              [ZSU]
  Id_AIPN_XNS_IDP = 22; //     XNS-IDP     XEROX NS IDP               [ETHERNET,XEROX]
  Id_AIPN_TRUNK_1 = 23; //     TRUNK-1     Trunk-1                              [BWB6]
  Id_AIPN_TRUNK_2 = 24; //     TRUNK-2     Trunk-2                              [BWB6]
  Id_AIPN_LEAF_1  = 25; //     LEAF-1      Leaf-1                               [BWB6]
  Id_AIPN_LEAF_2  = 26; //     LEAF-2      Leaf-2                               [BWB6]
  Id_AIPN_RDP     = 27; //     RDP         Reliable Data Protocol         [RFC908,RH6]
  Id_AIPN_IRTP    = 28; //     IRTP        Internet Reliable Transaction  [RFC938,TXM]
  Id_AIPN_ISO_TP4 = 29; //     ISO-TP4     ISO Transport Protocol Class 4 [RFC905,RC77]
  Id_AIPN_NETBLT  = 30; //     NETBLT      Bulk Data Transfer Protocol    [RFC969,DDC1]
  Id_AIPN_NFE_NSP = 31; //     MFE-NSP     MFE Network Services Protocol  [MFENET,BCH2]
  Id_AIPN_MERIT_IMP = 32; //     MERIT-INP   MERIT Internodal Protocol             [HWB]
  Id_AIPN_SEP       = 33; //     SEP         Sequential Exchange Protocol        [JC120]
  Id_AIPN_3PC       = 34; //     3PC         Third Party Connect Protocol         [SAF3]
  Id_AIPN_IDPR      = 35; //     IDPR        Inter-Domain Policy Routing Protocol [MXS1]
  Id_AIPN_XTP       = 36; //     XTP         XTP                                   [GXC]
  Id_AIPN_DDP       = 37; //     DDP         Datagram Delivery Protocol            [WXC]
  Id_AIPN_IDPR_CMTP      = 38; //     IDPR-CMTP   IDPR Control Message Transport Proto [MXS1]
  Id_AIPN_TP_PLUS_PLUS   = 39; //     TP++        TP++ Transport Protocol               [DXF]
  Id_AIPN_IL        =  40; //     IL          IL Transport Protocol                [DXP2]
  Id_AIPN_SIP       =  41; //     SIP         Simple Internet Protocol              [SXD]
  Id_AIPN_SDRP      =  42; //     SDRP        Source Demand Routing Protocol       [DXE1]
  Id_AIPN_SIP_SR    =  43; //     SIP-SR      SIP Source Route                      [SXD]
  Id_AIPN_SIP_FRAG  =  44; //     SIP-FRAG    SIP Fragment                          [SXD]
  Id_AIPN_IDRP =  45; //     IDRP        Inter-Domain Routing Protocol   [Sue Hares]
  Id_AIPN_RSVP =  46; //    RSVP        Reservation Protocol           [Bob Braden]
  Id_AIPN_GRE  =  47; //     GRE         General Routing Encapsulation     [Tony Li]
  Id_AIPN_MHRP =  48; //     MHRP        Mobile Host Routing Protocol[David Johnson]
  Id_AIPN_BNA  =  49; //     BNA         BNA                          [Gary Salamon]
  Id_AIPN_SIPP_ESB = 50; //     SIPP-ESP    SIPP Encap Security Payload [Steve Deering]
  Id_AIPN_SIPP_AH  = 51; //     SIPP-AH     SIPP Authentication Header  [Steve Deering]
  Id_AIPN_I_NLSP   = 52; //     I-NLSP      Integrated Net Layer Security  TUBA [GLENN]
  Id_AIPN_SWIPE = 53; //     SWIPE       IP with Encryption                    [JI6]
  Id_AIPN_NHRP  = 54; //     NHRP        NBMA Next Hop Resolution Protocol
  Id_AIPN_Any_Host_Internal = 61; // any host internal protocol            [JBP]
  Id_AIPN_CFTP  = 62; //     CFTP        CFTP                            [CFTP,HCF2]
  Id_AIPN_Any_LAN = 63; //                 any local network                     [JBP]
  Id_AIPN_SAT_EXPACK = 64; //     SAT-EXPAK   SATNET and Backroom EXPAK             [SHB]
  Id_AIPN_KRYPTOLAN = 65; //    KRYPTOLAN   Kryptolan                            [PXL1]
  Id_AIPN_RVD = 66; //     RVD         MIT Remote Virtual Disk Protocol      [MBG]
  Id_AIPN_IPPC = 67; //     IPPC        Internet Pluribus Packet Core         [SHB]
  Id_AIPN_Any_Distributed_File_System = 68; //any distributed file system           [JBP]
  Id_AIPN_SAT_MON = 69; //     SAT-MON     SATNET Monitoring                     [SHB]
  Id_AIPN_VISA = 70;//     VISA        VISA Protocol                        [GXT1]
  Id_AIPN_IPCV = 71;//     IPCV        Internet Packet Core Utility          [SHB]
  Id_AIPN_CPNX = 72; //     CPNX        Computer Protocol Network Executive  [DXM2]
  Id_AIPN_CPHB = 73; //     CPHB        Computer Protocol Heart Beat         [DXM2]
  Id_AIPN_WSM  = 74; //    WSN         Wang Span Network                     [VXD]
  Id_AIPN_PVP  = 75; //     PVP         Packet Video Protocol                 [SC3]
  Id_AIPN_BR_SAT_MON = 76; //     BR-SAT-MON  Backroom SATNET Monitoring            [SHB]
  Id_AIPN_SUN_ND  = 77; //     SUN-ND      SUN ND PROTOCOL-Temporary             [WM3]
  Id_AIPN_WB_MON  = 78; //     WB-MON      WIDEBAND Monitoring                   [SHB]
  Id_AIPN_EXPAK   = 79; //     WB-EXPAK    WIDEBAND EXPAK                        [SHB]
  Id_AIPN_ISO_IP  = 80; //     ISO-IP      ISO Internet Protocol                 [MTR]
  Id_AIPN_VMTP    = 81; //     VMTP        VMTP                                 [DRC3]
  Id_AIPN_SECURE_VMTP = 82; //     SECURE-VMTP SECURE-VMTP                          [DRC3]
  Id_AIPN_VINES = 83; //     VINES       VINES                                 [BXH]
  Id_AIPN_TTP =  84;//     TTP         TTP                                   [JXS]
  Id_AIPN_NSFNET_IGP = 85;//     NSFNET-IGP  NSFNET-IGP                            [HWB]
  Id_AIPN_DGP = 86;//     DGP         Dissimilar Gateway Protocol     [DGP,ML109]
  Id_AIPN_TCF = 87; //     TCF         TCF                                  [GAL5]
  Id_AIPN_IGRP = 88;//     IGRP        IGRP                            [CISCO,GXS]
  Id_AIPN_OSPFIGP = 89;//     OSPFIGP     OSPFIGP                      [RFC1583,JTM4]
  Id_AIPN_Sprite_RPC = 90; //     Sprite-RPC  Sprite RPC Protocol            [SPRITE,BXW]
  Id_AIPN_LARP = 91; //     LARP        Locus Address Resolution Protocol     [BXH]
  Id_AIPN_MTP = 92;//     MTP         Multicast Transport Protocol          [SXA]
  Id_AIPN_AX_25 = 93;//     AX.25       AX.25 Frames                         [BK29]
  Id_AIPN_IPIP = 94;//     IPIP        IP-within-IP Encapsulation Protocol   [JI6]
  Id_AIPN_MICP =  95;//     MICP        Mobile Internetworking Control Pro.   [JI6]
  Id_AIPN_SCC_SP = 96;//     SCC-SP      Semaphore Communications Sec. Pro.    [HXH]
  Id_AIPN_ETHERIP = 97;//     ETHERIP     Ethernet-within-IP Encapsulation     [RXH1]
  Id_AIPN_ENCAP = 98; //    ENCAP       Encapsulation Header         [RFC1241,RXB3]
  Id_AIPN_Any_Private_Encryption =  99; //any private encryption scheme         [JBP]
  Id_AIPN_GMTP = 100;//     GMTP        GMTP                                 [RXB5]
  Id_AIPN_Reserved2 =  255;//                Reserved

  {Operating SYstem names}
  Id_OS_Agis = 'AEGIS';
  Id_OS_Amiga_1_2 ='AMIGA-OS-1.2';
  Id_OS_Amiga_1_3 = 'AMIGA-OS-1.3';
  Id_OS_Amiga_2_0 = 'AMIGA-OS-2.0';
  Id_OS_Amiga_2_1 = 'AMIGA-OS-2.1';
  Id_OS_Amiga_3_0 = 'AMIGA-OS-3.0';
  Id_OS_Amiga_3_1 = 'AMIGA-OS-3.1';
  Id_OS_Apollo = 'APOLLO';
  Id_OS_AIX_370 = 'AIX/370';
  Id_OS_AIX_PS2 = 'AIX-PS/2';
  Id_OS_BS_2000 = 'BS-2000';
  Id_OS_Cedar   = 'CEDAR';
  Id_OS_CGW = 'CGW';
  Id_OS_CHORUS = 'CHORUS';
  Id_OS_Chrysalis = 'CHRYSALIS';
  Id_OS_CMOS = 'CMOS';
  Id_OS_CMS ='CMS';
  Id_OS_COS = 'COS';
  Id_OS_CPIX = 'CPIX';
  Id_OS_CTOS = 'CTOS';
  Id_OS_CTSS = 'CTSS';
  Id_OS_DCN  = 'DCN';
  Id_OS_DDNOS = 'DDNOS';
  Id_OS_DOMAIN = 'DOMAIN';
  Id_OS_DOS = 'DOS';
  Id_OS_EDX = 'EDX';
  Id_OS_ELF = 'ELF';
  Id_OS_EMBOS = 'EMBOS';
  Id_OS_EMMOS = 'EMMOS';
  Id_OS_EPOS  = 'EPOS';
  Id_OS_FOONEX = 'FOONEX';
  Id_OS_FORTH = 'FORTH';
  Id_OS_FUZZ = 'FUZZ';
  Id_OS_GCOS = 'GCOS';
  Id_OS_GPOS = 'GPOS';
  Id_OS_HDOS = 'HDOS';
  Id_OS_Imagen = 'IMAGEN';
  Id_OS_Intercom = 'INTERCOM';
  Id_OS_Impress = 'IMPRESS';
  Id_OS_Interlisp = 'INTERLISP';
  Id_OS_IOS       = 'IOS';
  Id_OS_IRIX      = 'IRIX';
  Id_OS_ISI       = 'ISI-68020';
  Id_OS_ITS       = 'ITS';
  Id_OS_LISP      = 'LISP';
  Id_OS_LISPM     = 'LISPM';
  Id_OS_LOCUS     = 'LOCUS';
  Id_OS_MACOS     = 'MACOS';
  Id_OS_MINOS     = 'MINOS';
  Id_OS_MOS = 'MOS';
  Id_OS_MPE5 = 'MPE5';
  Id_OS_MPEV = 'MPE/V';
  Id_OS_MPEIX = 'MPE/IX';
  Id_OS_MSDOS = 'MSDOS';
  Id_OS_MULTICS = 'MULTICS';
  Id_OS_MUSIC = 'MUSIC';
  Id_OS_MUSICSP = 'MUSIC/SP';
  Id_OS_MVS = 'MVS';
  Id_OS_MVSSP = 'MVS/SP';
  Id_OS_NEXUS = 'NEXUS';
  Id_OS_NMS = 'NMS';
  Id_OS_NONSTOP = 'NONSTOP';
  Id_OS_NOS_2 = 'NOS-2';
  Id_OS_NTOS  = 'NTOS';
  Id_OS_OpenVMS = 'OPENVMS';
  Id_OS_OSDDP = 'OS/DDP';
  Id_OS_OS_2 = 'OS/2';
  Id_OS_OS_4 = 'OS4';
  Id_OS_OS_6 = 'OS86';
  Id_OS_OSX  = 'OSX';
  Id_OS_PCDOS = 'PCDOS';
  Id_OS_PERQOS = 'PERQ/OS';
  Id_OS_PLI = 'PLI';
  Id_OS_PSDDOSMIT = 'PSDOS/MIT';
  Id_OS_Primos = 'PRIMOS';
  Id_OS_RMXRDOS = 'RMX/RDOS';
  Id_OS_ROS = 'ROS';
  Id_OS_RSX11M = 'RSX11M';
  Id_OS_RTE_A = 'RTE-A';
  Id_Satops = 'SATOPS';
  Id_OS_SCO_Open_Desktop_1_0 = 'SCO-OPEN-DESKTOP-1.0';
  Id_OS_SCO_Open_Desktop_1_1 = 'SCO-OPEN-DESKTOP-1.1';
  Id_OS_SCO_Open_Desktop_2_0 = 'SCO-OPEN-DESKTOP-2.0';
  Id_OS_SCO_Open_Desktop_3_0 = 'SCO-OPEN-DESKTOP-3.0';
  Id_OS_SCO_Open_Desktop_Lite_3_0 = 'SCO-OPEN-DESKTOP-LITE-3.0';
  Id_OS_SCO_Open_Server_3_0 = 'SCO-OPEN-SERVER-3.0';
  Id_OS_SCO_Unix_3_2_0 = 'SCO-UNIX-3.2.0';
  Id_OS_SCO_Unix_3_2V2_0 = 'SCO-UNIX-3.2V2.0';
  Id_OS_SCO_Unix_3_2V1_0 = 'SCO-UNIX-3.2V2.1';
  Id_OS_SCO_Unix_S_2V4_0 = 'SCO-UNIX-3.2V4.0';
  Id_OS_SCO_Unix_3_2V4_1 = 'SCO-UNIX-3.2V4.1';
  Id_OS_SCO_Unix_3_2V4_2 = 'SCO-UNIX-3.2V4.2';
  Id_OS_SCO_Xenix_386_2_3_2 = 'SCO-XENIX-386-2.3.2';
  Id_OS_SCO_Xenix_386_2_3_3 = 'SCO-XENIX-386-2.3.3';
  Id_OS_SCO_Xenix_386_2_3_4 = 'SCO-XENIX-386-2.3.4';
  Id_OS_SCS = 'SCS';
  Id_OS_SIMP = 'SIMP';
  Id_OS_SUN = 'SUN';
  Id_OS_SUN_OS_3_5 = 'SUN-OS-3.5';
  Id_OS_SUN_OS_4_0 = 'SUN-OS-4.0';
  Id_OS_Swift = 'SWIFT';
  Id_OS_Tac = 'TAC';
  Id_OS_Tandem = 'TANDEM';
  Id_OS_Tenex = 'TENEX';
  Id_OS_The_Major_BBS = 'THE-MAJOR-BBS';
  Id_OS_Tops10 = 'TOPS10';
  Id_OS_Tops20 = 'TOPS20';
  Id_OS_TOS = 'TOS';
  Id_OS_TP3010 = 'TP3010';
  Id_OS_TRSDOS = 'TRSDOS';
  Id_OS_Ultrix = 'ULTRIX';
  Id_OS_Unix = 'UNIX';
  Id_OS_Unix_BSD = 'UNIX-BSD';
  Id_OS_Unix_V1AT = 'UNIX-V1AT';
  Id_OS_Unix_V = 'UNIX-V';
  Id_OS_Unix_V_1 = 'UNIX-V.1';
  Id_OS_Unix_V_2 = 'UNIX-V.2';
  Id_OS_Unix_V_3 = 'UNIX-V.3';
  Id_OS_Unix_PC = 'UNIX-PC';
  Id_OS_Unix_Unknown = 'UNKNOWN';
  Id_OS_UT2D = 'UT2D';
  Id_OS_V = 'V';
  Id_OS_VM = 'VM';
  Id_OS_VM_370 = 'VM/370';
  Id_OS_VM_CMS = 'VM/CMS';
  Id_OS_VM_SP = 'VM/SP';
  Id_OS_VMS = 'VMS';
  Id_OS_VMS_Eunice = 'VMS/EUNICE';
  Id_OS_VRTX = 'VRTX';
  Id_OS_Waits = 'WAITS';
  Id_OS_Wang = 'WANG';
  Id_OS_Win32 = 'WIN32';
  Id_OS_Wyse_Wyxware = 'WYSE-WYXWARE';
  Id_OS_X11R3 = 'X11R3';
  Id_OS_XDE = 'XDE';
  Id_OS_Xenix = 'XENIX';

const
{ Machine Names }

  Id_MN_Amiga_500 = 'AMIGA-500';
  Id_MN_Amiga_500_010 = 'AMIGA-500/010';
  Id_MN_Amiga_500_020 = 'AMIGA-500/020';
  Id_MN_Amiga_500_EC030 = 'AMIGA-500/EC030';
  Id_MN_Amiga_500_030 = 'AMIGA-500/030';
  Id_MN_Amiga_600 = 'AMIGA-600';
  Id_MN_Amiga_1000 = 'AMIGA-1000';
  Id_MN_Amiga_1000_010 = 'AMIGA-1000/010';
  Id_MN_Amiga_1000_020 = 'AMIGA-1000/020';
  Id_MN_Amiga_1000_EC030 = 'AMIGA-1000/EC030';
  Id_MN_Amiga_1000_030 = 'AMIGA-1000/030';
  Id_MN_Amiga_1200 = 'AMIGA-1200';
  Id_MN_Amiga_1200_EC030 = 'AMIGA-1200/EC030';
  Id_MN_Amiga_1200_030 = 'AMIGA-1200/030';
  Id_MN_Amiga_1200_EC040 = 'AMIGA-1200/EC040';
  Id_MN_Amiga_1200_LC040 = 'AMIGA-1200/LC040';
  Id_MN_Amiga_1200_040 = 'AMIGA-1200/040';
  Id_MN_Amiga_2000 = 'AMIGA-2000';
  Id_MN_Amiga_2000_010 = 'AMIGA-2000/010';
  Id_MN_Amiga_2000_020 = 'AMIGA-2000/020';
  Id_MN_Amiga_2000_EC030 = 'AMIGA-2000/EC030';
  Id_MN_Amiga_2000_030 = 'AMIGA-2000/030';
  Id_MN_Amiga_2000_LC040 = 'AMIGA-2000/LC040';
  Id_MN_Amiga_2000_EC040 = 'AMIGA-2000/EC040';
  Id_MN_Amiga_2000_040 = 'AMIGA-2000/040';
  Id_MN_Amiga_3000 = 'AMIGA-3000';
  Id_MN_Amiga_3000_EC040 = 'AMIGA-3000/EC040';
  Id_MN_Amiga_3000_LC040 = 'AMIGA-3000/LC040';
  Id_MN_Amiga_3000_040 = 'AMIGA-3000/040';
  Id_MN_Amiga_3000_060 = 'AMIGA-3000/060';
  Id_MN_Amiga_4000_EC030 = 'AMIGA-4000/EC030';
  Id_MN_Amiga_4000_030 = 'AMIGA-4000/030';
  Id_MN_Amiga_4000_LC040 = 'AMIGA-4000/LC040';
  Id_MN_Amiga_4000_040 = 'AMIGA-4000/040';
  Id_MN_Amiga_4000_060 = 'AMIGA-4000/060';
  Id_MN_Alto = 'ALTO';
  Id_MN_Altos_6800 = 'ALTOS-6800';
  Id_MN_Amdahl_V7 = 'AMDAHL-V7';
  Id_MN_Apollo = 'APOLLO';
  Id_MN_Apple_Macintosh = 'APPLE-MACINTOSH';
  Id_MN_Apple_Powerbook = 'APPLE-POWERBOOK';
  Id_MN_Atari_104ST = 'ATARI-104ST';
  Id_MN_ATT_3B1 = 'ATT-3B1';
  Id_MN_ATT_3B2 = 'ATT-3B2';
  Id_MN_ATT_3B20 = 'ATT-3B20';
  Id_MN_ATT_7300 = 'ATT-7300';
  Id_MN_AXP = 'AXP';
  Id_MN_BBN_C_60 = 'BBN-C/60';
  Id_MN_Burroughs_B_29 = 'BURROUGHS-B/29';
  Id_MN_Burroughs_B_4800 = 'BURROUGHS-B/4800';
  Id_MN_Butterfly = 'BUTTERFLY';
  Id_MN_C_30 = 'C/30';
  Id_MN_C_70 = 'C/70';
  Id_MN_Cadlinc = 'CADLINC';
  Id_MN_CadR = 'CADR';
  Id_MN_CDC_170 = 'CDC-170';
  Id_MN_CDC_170_750 = 'CDC-170/750';
  Id_MN_CDC_173 = 'CDC-173';
  Id_MN_CDTV = 'CDTV';
  Id_MN_CDTV_060 = 'CDTV/060';
  Id_MN_CD32 = 'CD32';
  Id_MN_Celerity_1200 = 'CELERITY-1200';
  Id_MN_Club_386 = 'CLUB-386';
  Id_MN_Compaq_386_20 = 'COMPAQ-386/20';
  Id_MN_Comten_3690 = 'COMTEN-3690';
  Id_MN_CP8040 = 'CP8040';
  Id_MN_Cray_1 = 'CRAY-1';
  Id_MN_Cray_X_MP = 'CRAY-X/MP';
  Id_MN_Cray_2 = 'CRAY-2';
  Id_MN_CTIWS_117 = 'CTIWS-117';
  Id_MN_Dandelion = 'DANDELION';
  Id_MN_DEC_10 = 'DEC-10';
  Id_MN_DEC_1050 = 'DEC-1050';
  Id_MN_DEC_1077 = 'DEC-1077';
  Id_MN_DEC_1080 = 'DEC-1080';
  Id_MN_DEC_1090 = 'DEC-1090';
  Id_MN_DEC_1090B = 'DEC-1090B';
  Id_MN_DEC_1090T = 'DEC-1090T';
  Id_MN_DEC_2020T = 'DEC-2020T';
  Id_MN_DEC_2040 = 'DEC-2040';
  Id_MN_DEC_2040T = 'DEC-2040T';
  Id_MN_DEC_2050T = 'DEC-2050T';
  Id_MN_DEC_2060 = 'DEC-2060';
  Id_MN_DEC_2060T = 'DEC-2060T';
  Id_MN_DEC_2065 = 'DEC-2065';
  Id_MN_DEC_AXP = 'DEC-AXP';
  Id_MN_DEC_Falcon = 'DEC-FALCON';
  Id_MN_DEC_KS10 = 'DEC-KS10';
  Id_MN_DECStation = 'DECSTATION';
  Id_MN_DEC_VAX = 'DEC-VAX';
  Id_MN_DEC_VAXCluster = 'DEC-VAXCLUSTER';
  Id_MN_DEC_VAXStation = 'DEC-VAXSTATION';
  Id_MN_DEC_VAX_11730 = 'DEC-VAX-11730';
  Id_MN_Dorado = 'DORADO';
  Id_MN_DPS8_70M = 'DPS8/70M';
  Id_MN_Elxsi_6400 = 'ELXSI-6400';
  Id_MN_EverEx_386 = 'EVEREX-386';
  Id_MN_Foonly_F2 = 'FOONLY-F2';
  Id_MN_Foonly_F3 = 'FOONLY-F3';
  Id_MN_Foonly_F4 = 'FOONLY-F4';
  Id_MN_Gould = 'GOULD';
  Id_MN_Gould_6050 = 'GOULD-6050';
  Id_MN_Gould_6080 = 'GOULD-6080';
  Id_MN_Gould_9050 = 'GOULD-9050';
  Id_MN_Gould_9080 = 'GOULD-9080';
  Id_MN_H_316 = 'H-316';
  Id_MN_H_60_68 = 'H-60/68';
  Id_MN_H_68 = 'H-68';
  Id_MN_H_68_80 = 'H-68/80';
  Id_MN_H_89 = 'H-89';
  Id_MN_Honeywell_DPS_6 = 'HONEYWELL-DPS-6';
  Id_MN_Honeywell_BPS_8_70 = 'HONEYWELL-DPS-8/70';
  Id_MN_HP3000 = 'HP3000';
  Id_MN_HP3000_64 = 'HP3000/64';
  Id_MN_IBM_158 = 'IBM-158';
  Id_MN_IBM_360_67 = 'IBM-360/67';
  Id_MN_IBM_370_3033 = 'IBM-370/3033';
  Id_MN_IBM_3081 = 'IBM-3081';
  Id_MN_IBM_3084QX = 'IBM-3084QX';
  Id_MN_IBM_3101 = 'IBM-3101';
  Id_MN_IBM_4331 = 'IBM-4331';
  Id_MN_IBM_4341 = 'IBM-4341';
  Id_MN_IBM_4361 = 'IBM-4361';
  Id_MN_IBM_4381 = 'IBM-4381';
  Id_MN_IBM_4956 = 'IBM-4956';
  Id_MN_IBM_6152 = 'IBM-6152';
  Id_MN_IBM_PC = 'IBM-PC';
  Id_MN_IBM_PC_AT = 'IBM-PC/AT';
  Id_MN_IBM_PC_RT = 'IBM-PC/RT';
  Id_MN_IBM_PC_XT = 'IBM-PC/XT';
  Id_MN_IBM_RS_6000 = 'IBM-RS/6000';
  Id_MN_IBM_Series_1 = 'IBM-SERIES/1';

  Id_MN_Imagen = 'IMAGEN';
  Id_MN_Imagen_8_300 = 'IMAGEN-8/300';
  Id_MN_Imsai = 'IMSAI';
  Id_MN_Integrated_Solutions = 'INTEGRATED-SOLUTIONS';
  Id_MN_Integrated_Solutions_68K = 'INTEGRATED-SOLUTIONS-68K';
  Id_MN_Integrated_Solutions_Creator = 'INTEGRATED-SOLUTIONS-CREATOR';
  Id_MN_Integrated_Solutions_Creator_8 = 'INTEGRATED-SOLUTIONS-CREATOR-8';
  Id_MN_INTEL_386 = 'INTEL-386';
  Id_MN_INTEL_IPSC = 'INTEL-IPSC';
  Id_MN_Is_1 = 'IS-1';
  Id_MN_Is_68010 = 'IS-68010';
  Id_MN_LMI = 'LMI';
  Id_MN_LSI_11 = 'LSI-11';
  Id_MN_LSI_11_2 = 'LSI-11/2';
  Id_MN_LSI_11_23 = 'LSI-11/23';
  Id_MN_LSI_11_73 = 'LSI-11/73';
  Id_MN_M68000 = 'M68000';
  Id_MN_Mac_II = 'MAC-II';
  Id_MN_Mac_Powerbook = 'MAC-POWERBOOK';
  Id_MN_MacIntosh = 'MACINTOSH';
  Id_MN_MassComp = 'MASSCOMP';
  Id_MN_MC500 = 'MC500';
  Id_MN_68000 = 'MC68000';
  Id_MN_Microport = 'MICROPORT';
  Id_MN_MicroVAX = 'MICROVAX';
  Id_MN_MicroVAX_I = 'MICROVAX-I';
  Id_MN_MV_8000 = 'MV/8000';
  Id_MN_NAS3_5 = 'NAS3-5';
  Id_MN_NCR_Comten_3690 = 'NCR-COMTEN-3690';
  Id_MN_Next_N1000_316 = 'NEXT/N1000-316';
  Id_MN_Now = 'NOW';
  Id_MN_Onyx_Z8000 = 'ONYX-Z8000';

  Id_MN_PDP_11 = 'PDP-11';
  Id_MN_PDP_11_3 = 'PDP-11/3';
  Id_MN_PDP_11_23 = 'PDP-11/23';
  Id_MN_PDP_11_24 = 'PDP-11/24';
  Id_MN_PDP_11_34 = 'PDP-11/34';
  Id_MN_PDP_11_40 = 'PDP-11/40';
  Id_MN_PDP_11_44 = 'PDP-11/44';
  Id_MN_PDP_11_45 = 'PDP-11/45';
  Id_MN_PDP_11_50 = 'PDP-11/50';
  Id_MN_PDP_11_70 = 'PDP-11/70';
  Id_MN_PDP_11_73 = 'PDP-11/73';
  Id_MN_PE_7_32 = 'PE-7/32';
  Id_MN_PE_3205 = 'PE-3205';
  Id_MN_PE_Perq = 'PERQ';
  Id_MN_Plexus_P_60 = 'PLEXUS-P/60';
  Id_MN_PLI = 'PLI';

  Id_MN_Pluribus = 'PLURIBUS';
  Id_MN_Prime_2350 = 'PRIME-2350';
  Id_MN_Prime_2450 = 'PRIME-2450';
  Id_MN_Prime_2755 = 'PRIME-2755';
  Id_MN_Prime_9655 = 'PRIME-9655';
  Id_MN_Prime_9755 = 'PRIME-9755';
  Id_MN_Prime_9955II = 'PRIME-9955II';
  Id_MN_Prime_2250 = 'PRIME-2250';
  Id_MN_Prime_2655 = 'PRIME-2655';
  Id_MN_Prime_9955 = 'PRIME-9955';
  Id_MN_Prime_9950 = 'PRIME-9950';
  Id_MN_Prime_9650 = 'PRIME-9650';
  Id_MN_Prime_9750 = 'PRIME-9750';
  Id_MN_Prime_750 = 'PRIME-750';
  Id_MN_Prime_850 = 'PRIME-850';
  Id_MN_Prime_550II = 'PRIME-550II';
  Id_MN_Pyramid_90 = 'PYRAMID-90';
  Id_MN_Pyramid_90MX = 'PYRAMID-90MX';
  Id_MN_Pyramid_90X = 'PYRAMID-90X';
  Id_MN_Ridge = 'RIDGE';
  Id_MN_Ridge_32 = 'RIDGE-32';
  Id_MN_Ridge_32C = 'RIDGE-32C';
  Id_MN_ROLM_1666 = 'ROLM-1666';
  Id_MN_RS_6000 = 'RS/6000';
  Id_MN_S1_MKIIA = 'S1-MKIIA';
  Id_MN_SMI = 'SMI';
  Id_MN_Sequent_Balance_8000 = 'SEQUENT-BALANCE-8000';
  Id_MN_Emens = 'SIEMENS';
  Id_MN_Silicon_Graphics = 'SILICON-GRAPHICS';
  Id_MN_Silicon_Graphics_Iris = 'SILICON-GRAPHICS-IRIS';

  Id_MN_SGI_Iris_2400 = 'SGI-IRIS-2400';
  Id_MN_SGI_Iris_2500 = 'SGI-IRIS-2500';
  Id_MN_SGI_Iris_3010 = 'SGI-IRIS-3010';
  Id_MN_SGI_Iris_3020 = 'SGI-IRIS-3020';
  Id_MN_SGI_Iris_3030 = 'SGI-IRIS-3030';
  Id_MN_SGI_Iris_3110 = 'SGI-IRIS-3110';
  Id_MN_SGI_Iris_3115 = 'SGI-IRIS-3115';
  Id_MN_SGI_Iris_3120 = 'SGI-IRIS-3120';
  Id_MN_SGI_Iris_3130 = 'SGI-IRIS-3130';
  Id_MN_SGI_Iris_4D_20 = 'SGI-IRIS-4D/20';
  Id_MN_SGI_Iris_4D_20G = 'SGI-IRIS-4D/20G';
  Id_MN_SGI_Iris_4D_25 = 'SGI-IRIS-4D/25';
  Id_MN_SGI_Iris_4D_25G = 'SGI-IRIS-4D/25G';
  Id_MN_SGI_Iris_4D_25S = 'SGI-IRIS-4D/25S';
  Id_MN_SGI_Iris_4D_50 = 'SGI-IRIS-4D/50';
  Id_MN_SGI_Iris_4D_50G = 'SGI-IRIS-4D/50G';
  Id_MN_SGI_Iris_4D_50GT = 'SGI-IRIS-4D/50GT';
  Id_MN_SGI_Iris_4D_60 = 'SGI-IRIS-4D/60';
  Id_MN_SGI_Iris_4D_60G = 'SGI-IRIS-4D/60G';
  Id_MN_SGI_Iris_4D_60T = 'SGI-IRIS-4D/60T';
  Id_MN_SGI_Iris_4D_60GT = 'SGI-IRIS-4D/60GT';
  Id_MN_SGI_Iris_4D_70 = 'SGI-IRIS-4D/70';
  Id_MN_SGI_Iris_4D_70G = 'SGI-IRIS-4D/70G';
  Id_MN_SGI_Iris_4D_70GT = 'SGI-IRIS-4D/70GT';
  Id_MN_SGI_Iris_4D_80GT = 'SGI-IRIS-4D/80GT';
  Id_MN_SGI_Iris_4D_80S = 'SGI-IRIS-4D/80S';
  Id_MN_SGI_Iris_4D_120GTX = 'SGI-IRIS-4D/120GTX';
  Id_MN_SGI_Iris_4D_120S = 'SGI-IRIS-4D/120S';
  Id_MN_SGI_Iris_4D_210GTX = 'SGI-IRIS-4D/210GTX';
  Id_MN_SGI_Iris_4D_210S = 'SGI-IRIS-4D/210S';
  Id_MN_SGI_Iris_4D_220GTX = 'SGI-IRIS-4D/220GTX';
  Id_MN_SGI_Iris_4D_220S = 'SGI-IRIS-4D/220S';
  Id_MN_SGI_Iris_4D_240GTX = 'SGI-IRIS-4D/240GTX';
  Id_MN_SGI_Iris_4D_240S = 'SGI-IRIS-4D/240S';
  Id_MN_SGI_Iris_4D_280GTX = 'SGI-IRIS-4D/280GTX';
  Id_MN_SGI_Iris_4D_280S = 'SGI-IRIS-4D/280S';
  Id_MN_SGI_Iris_CS_12 = 'SGI-IRIS-CS/12';
  Id_MN_SGI_Iris_4Server_8 = 'SGI-IRIS-4SERVER-8';
  Id_MN_Sperry_DCP_10 = 'SPERRY-DCP/10';
  Id_MN_Sun = 'SUN';
  Id_MN_Sun_2 = 'SUN-2';
  Id_MN_Sun_2_50 = 'SUN-2/50';
  Id_MN_Sun_2_100 = 'SUN-2/100';
  Id_MN_Sun_2_120 = 'SUN-2/120';
  Id_MN_Sun_2_130 = 'SUN-2/130';
  Id_MN_Sun_2_140 = 'SUN-2/140';
  Id_MN_Sun_2_150 = 'SUN-2/150';
  Id_MN_Sun_2_160 = 'SUN-2/160';
  Id_MN_Sun_2_170 = 'SUN-2/170';
  Id_MN_Sun_3_50 = 'SUN-3/50';
  Id_MN_Sun_3_60 = 'SUN-3/60';
  Id_MN_Sun_3_75 = 'SUN-3/75';
  Id_MN_Sun_3_80 = 'SUN-3/80';
  Id_MN_Sun_3_110 = 'SUN-3/110';
  Id_MN_Sun_3_140 = 'SUN-3/140';
  Id_MN_Sun_3_150 = 'SUN-3/150';
  Id_MN_Sun_3_160 = 'SUN-3/160';
  Id_MN_Sun_3_180 = 'SUN-3/180';
  Id_MN_Sun_3_200 = 'SUN-3/200';
  Id_MN_Sun_3_260 = 'SUN-3/260';
  Id_MN_Sun_3_280 = 'SUN-3/280';
  Id_MN_Sun_3_470 = 'SUN-3/470';
  Id_MN_Sun_3_480 = 'SUN-3/480';
  Id_MN_Sun_4_60 = 'SUN-4/60';
  Id_MN_Sun_4_110 = 'SUN-4/110';
  Id_MN_Sun_4_150 = 'SUN-4/150';
  Id_MN_Sun_4_200 = 'SUN-4/200';
  Id_MN_Sun_4_260 = 'SUN-4/260';
  Id_MN_Sun_4_280 = 'SUN-4/280';
  Id_MN_Sun_4_330 = 'SUN-4/330';
  Id_MN_Sun_4_370 = 'SUN-4/370';
  Id_MN_Sun_4_390 = 'SUN-4/390';
  Id_MN_Sun_50 = 'SUN-50';
  Id_MN_Sun_100 = 'SUN-100';
  Id_MN_Sun_120 = 'SUN-120';
  Id_MN_Sun_130 = 'SUN-130';
  Id_MN_Sun_150 = 'SUN-150';
  Id_MN_Sun_170 = 'SUN-170';
  Id_MN_Sun_386i_250 = 'SUN-386i/250';
  Id_MN_Sun_68000 = 'SUN-68000';
  Id_MN_Symbolics_3600 = 'SYMBOLICS-3600';
  Id_MN_Symbolics_3670 = 'SYMBOLICS-3670';
  Id_MN_Symmetric_375 = 'SYMMETRIC-375';
  Id_MN_Symult = 'SYMULT';
  Id_MN_Tandem_TXP = 'TANDEM-TXP';
  Id_MN_Tandy_6000 = 'TANDY-6000';
  Id_MN_Tek_6130 = 'TEK-6130';
  Id_MN_TI_Explorer = 'TI-EXPLORER';
  Id_MN_TP_4000 = 'TP-4000';
  Id_MN_TRS_80 = 'TRS-80';
  Id_MN_Univac_1100 = 'UNIVAC-1100';
  Id_MN_Univac_1100_60 = 'UNIVAC-1100/60';
  Id_MN_Univac_1100_62 = 'UNIVAC-1100/62';
  Id_MN_Univac_1100_63 = 'UNIVAC-1100/63';
  Id_MN_Univac_1100_64 = 'UNIVAC-1100/64';
  Id_MN_Univac_1100_70 = 'UNIVAC-1100/70';
  Id_MN_Univac_1160 = 'UNIVAC-1160';
  Id_MN_Unknown = 'UNKNOWN';
  Id_MN_VAX = 'VAX';
  Id_MN_VAX_11_725 = 'VAX-11/725';
  Id_MN_VAX_11_730 = 'VAX-11/730';
  Id_MN_VAX_11_750 = 'VAX-11/750';
  Id_MN_VAX_11_780 = 'VAX-11/780';
  Id_MN_VAX_11_785 = 'VAX-11/785';
  Id_MN_VAX_11_790 = 'VAX-11/790';
  Id_MN_VAX_11_8600 = 'VAX-11/8600';
  Id_MN_VAX_8600 = 'VAX-8600';
  Id_MN_VAXCluster = 'VAXCLUSTER';
  Id_MN_VAXStation = 'VAXSTATION';
  Id_MN_Wang_PC002 = 'WANG-PC002';
  Id_MN_Wang_VS100 = 'WANG-VS100';
  Id_MN_Wang_VS400 = 'WANG-VS400';
  Id_MN_Wyse_386 = 'WYSE-386';
  Id_MN_Wyse_WN5004 = 'WYSE-WN5004';
  Id_MN_Wyse_WN5008 = 'WYSE-WN5008';
  Id_MN_Wyse_WN5104 = 'WYSE-WN5104';
  Id_MN_Wyse_WN5108 = 'WYSE-WN5108';
  Id_MN_Wyse_WX15C = 'WYSE-WX15C';
  Id_MN_Wyse_WX17C = 'WYSE-WX17C';
  Id_MN_Wyse_WX17M = 'WYSE-WX17M';
  Id_MN_Wyse_WX19C = 'WYSE-WX19C';
  Id_MN_Wyse_WX19M = 'WYSE-WX19M';
  Id_MN_Wyse_WYX14M = 'WYSE-WYX14M';
  Id_MN_Wyse_WYX5 = 'WYSE-WYX5';
  Id_MN_Xerox_1108 = 'XEROX-1108';
  Id_MN_Xerox_8010 = 'XEROX-8010';
  Id_MN_Zenith_148 = 'ZENITH-148';

const
  Id_CS_US_ASCII = 'US-ASCII';      // see ANSI_X3.4-1968 below                 [RFC1521,NSB]
  Id_CS_ISO_8859_1 = 'ISO-8859-1'; //     see ISO_8859-1:1987 below                [RFC1521,NSB]
  Id_CS_ISO_8859_2 = 'ISO-8859-2'; //     see ISO_8859-2:1987 below                [RFC1521,NSB]
  Id_CS_ISO_8859_3 = 'ISO-8859-3'; //    see ISO_8859-3:1988 below                [RFC1521,NSB]
  Id_CS_ISO_8859_4 = 'ISO-8859-4'; //     see ISO_8859-4:1988 below                [RFC1521,NSB]
  Id_CS_ISO_8859_5 = 'ISO-8859-5'; //     see ISO_8859-5:1988 below                [RFC1521,NSB]
  Id_CS_ISO_8859_6 = 'ISO-8859-6'; //     see ISO_8859-6:1987 below                [RFC1521,NSB]
  Id_CS_ISO_8859_7 = 'ISO-8859-7'; //     see ISO_8859-7:1987 below                [RFC1521,NSB]
  Id_CS_ISO_8859_8 = 'ISO-8859-8'; //     see ISO_8859-8:1988 below                [RFC1521,NSB]
  Id_CS_ISO_8859_9 = 'ISO-8859-9'; //    see ISO_8859-9:1989 below

const
//These are multicast group IP addresses
  Id_IPMC_Base_Address = '224.0.0.0'; //Base Address [RFC1112,JBP]
  Id_IPMC_All_Systems = '224.0.0.1'; //All Systems on this Subne  [RFC1112,JBP]
  Id_IPMC_All_Routers = '224.0.0.2'; //All Routers on this Subnet [JBP]
  Id_IPMC_Unassigned = '224.0.0.3'; // Unassigned  [JBP]
  Id_IPMC_DVMRP_Routers = '224.0.0.4';// DVMRP    Routers [RFC1075,JBP]
  Id_IPMC_OSPFIGP_All_Routers = '224.0.0.5'; //OSPFIGP  OSPFIGP All Routers [RFC1583,JXM1]
  Id_IPMC_OSPFIGP_Designated_Routers = '224.0.0.6'; //OSPFIGP  OSPFIGP Designated Routers      [RFC1583,JXM1]
  Id_IPMC_ST_Routers = '224.0.0.7';// ST Routers [RFC1190,KS14]
  Id_IPMC_ST_Hosts ='224.0.0.8'; //ST Hosts  [RFC1190,KS14]
  Id_IPMC_RIP2_Routers = '224.0.0.9'; //RIP2 Routers  [GSM11]
  Id_IPMC_IGRP_Routers = '224.0.0.10'; // IGRP Routers [Dino Farinacci]
  Id_IPMC_Mobile_Agents ='224.0.0.11';// Mobile-Agents [Bill Simpson]
//224.0.0.12-224.0.0.255 Unassigned                            [JBP]
  Id_IPMC_Unassigned_MIN = '224.0.0.12';
  Id_IPMC_Unassigned_MAX = '224.0.0.255';

  Id_IPMC_VMTP_Managers = '224.0.1.0';// VMTP Managers Group  [RFC1045,DRC3]
  Id_IPMC_NTP_Protocol = '224.0.1.1'; // NTP      Network Time Protocol [RFC1119,DLM1]
  Id_IPMC_SGI_Dogfight  ='224.0.1.2';// SGI-Dogfight [AXC]
  Id_IPMC_Rwhod = '224.0.1.3'; //Rwhod [SXD]
  Id_IPMC_VNP = '224.0.1.4'; //VNP  [DRC3]
  Id_IPMC_Artificial_Horizons = '224.0.1.5'; //Artificial Horizons - Aviator [BXF]
  Id_IPMC_NSS = '224.0.1.6';// NSS - Name Service Server [BXS2]
  Id_IPMC_AUDIONEWS = '224.0.1.7'; //AUDIONEWS - Audio News Multicast [MXF2]
  Id_IPMC_SUN_NIS_Plus_Information = '224.0.1.8';// SUN NIS+ Information Service [CXM3]
  Id_IPMC_MTP_Protocol = '224.0.1.9';// MTP Multicast Transport Protocol [SXA]
  Id_IPMC_IETF_1_Low_Audio = '224.0.1.10'; // IETF-1-LOW-AUDIO    [SC3]
  Id_IPMC_IETF_1_Audio = '224.0.1.11'; //IETF-1-AUDIO [SC3]
  Id_IPMC_IETF_1_Video = '224.0.1.12';// IETF-1-VIDEO [SC3]
  Id_IPMC_IETF_2_Low_Audio = '224.0.1.13';// IETF-2-LOW-AUDIO  [SC3]
  Id_IPMC_IETF_2_Audio = '224.0.1.14';// IETF-2-AUDIO [SC3]
  Id_IPMC_IETF_2_Video = '224.0.1.15';// IETF-2-VIDEO [SC3]
  Id_IPMC_Music_Service = '224.0.1.16'; // MUSIC-SERVICE  [Guido van Rossum]
  Id_IPMC_SEANET_TELEMETRY = '224.0.1.17';// SEANET-TELEMETRY [Andrew Maffei]
  Id_IPMC_SEANET_IMAGE = '224.0.1.18'; // SEANET-IMAGE  [Andrew Maffei]
  Id_IPMC_MLOADD = '224.0.1.19'; // MLOADD [Braden]
  Id_IPMC_Private_Expiriment = '224.0.1.20'; //any private experiment   [JBP]
  Id_IPMC_DVMRP_on_MOSPF = '224.0.1.21'; // DVMRP on MOSPF [John Moy]
  Id_IPMC_SVRLOC = '224.0.1.22';// SVRLOC  <veizades@ftp.com>
  Id_IPMC_XINGTV = '224.0.1.23';// XINGTV <hgxing@aol.com>
  Id_IPMC_Microsoft_DS = '224.0.1.24'; // microsoft-ds  <arnoldm@microsoft.com>
  Id_IPMC_NBC_Pro = '224.0.1.25'; //nbc-pro <bloomer@birch.crd.ge.com>
  Id_IPMC_NBC_Pfn = '224.0.1.26'; //nbc-pfn <bloomer@birch.crd.ge.com>

implementation

end.
