package com.superhac.JXBStreamer.Gui;

import java.io.File;
import java.util.ArrayList;

import javax.swing.table.AbstractTableModel;

public class ShareTableModel extends AbstractTableModel {

	final static long serialVersionUID = 488534534L; 
	public String[] colNames = {"Share's"}; 
	
	ArrayList<File> shares;
	
	/** Creates a new instance of IncommingConnTableModel */
    public ShareTableModel(ArrayList<File> shares) {
        super(); 
        this.shares = shares;
        
    }
    
    public String getColumnName(int col) {
        return colNames[col].toString();
    }
    public int getRowCount() { return shares.size(); }
    public int getColumnCount() { return colNames.length; }
    public Object getValueAt(int row, int col) {
       
        File file = (File) shares.get(row);
        
        switch (col) {
            
            case 0: 
                return file.getAbsolutePath();
           
        }
        
        return "";
    }
    public boolean isCellEditable(int row, int col)
        { return false; }
    
    public void addSharePath(File file)
    {
    	shares.add(file);
    	this.fireTableDataChanged();
    }
    
    public void removeSharePath(int index)
    {
    	shares.remove(index);
    	this.fireTableDataChanged();
    }
    
}
