package com.superhac.JXBStreamer.Gui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;

public class SaveAndLoadSettings implements Serializable {

	final static long serialVersionUID = 453334534L; 
	public int portNumber = 1400;

	public boolean enableAutoDiscovery = true;

	public ArrayList<File> shares = new ArrayList<File>();

	public void saveSettings() {
		try {
			 //Serialize to a file
			ObjectOutput out = new ObjectOutputStream(new FileOutputStream("jxb.cfg"));
			
			out.writeObject(this);
			out.close();

		} catch (IOException e) {

			//System.out.println("Cannot save!: " + e);
		}

	}

	public SaveAndLoadSettings loadSettings() {
		try {
			// Deserialize from a file
			File file = new File("jxb.cfg");
			ObjectInputStream in = new ObjectInputStream(new FileInputStream(
					file));
			// Deserialize the object
			SaveAndLoadSettings newSettings = (SaveAndLoadSettings) in
					.readObject();
			in.close();

			return newSettings;

		} catch (ClassNotFoundException e) {
			//System.out.println("Cannot load!: " + e);
		} catch (IOException e) {
			//System.out.println("Cannot load!: " + e);
		}

		return null;

	}

	

}
