package com.superhac.JXBStreamer.Core;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.logging.Logger;

/**
 * This class handles the encoding of the XML file data in the XBMSP protocol.
 * <p>
 * <p>
 * More information can be found at <a
 * href="http://www.superhac.com">Superhac.com</a>
 * 
 * @author Steven Scott (superhac007@gmail.com)
 */

public class XBMSPxmlEncoder {

	static private Logger logger;

	static {
		// if (com.superhac.JXBStreamer.Core.Debug.debug)
		logger = com.superhac.JXBStreamer.Core.Debug.getLogger();
	}

	/**
	 * Encodes a file or directory entry info into the XBMSP protocol format.
	 * 
	 * @param entry
	 *            the file for which the encoded information should be generated
	 * @return the encoded XML
	 */
	protected static String encodeEntry(File entry) {
		String data = null;

		// Is this a directoy?
		if (entry.isDirectory()) {
			if (com.superhac.JXBStreamer.Core.Debug.debug)
				logger.info("Encoding directory entry in XML..");

			data = "<DIRECTORYITEM>";
			data += "<NAME>" + entry.getName() + "</NAME>";
			// data += "<PATHNAME DEPTH=\"1\">";
			// data += "<COMPONENT LEVEL
			// =\"1\">"+entry.getName()+"</COMPONENT>";
			// data += "</PATHNAME>";
			data += "<INFO></INFO>";
			data += "<ATTRIB>directory</ATTRIB>";
			data += "</DIRECTORYITEM>";

		} else // its a file
		{
			if (com.superhac.JXBStreamer.Core.Debug.debug)
				logger.info("Encoding a file entry in XML..");

			data = "<DIRECTORYITEM>";
			data += "<NAME>" + entry.getName() + "</NAME>";
			data += "<PATHNAME DEPTH=\"1\">";
			data += "<COMPONENT LEVEL =\"1\">" + entry.getName()
					+ "</COMPONENT>";
			data += "</PATHNAME>";
			data += "<ATTRIB>file</ATTRIB>";
			data += "<SIZE>" + entry.length() + "</SIZE>";
			data += "<TIME>";
			// not correct for all fields! correct later
			data += "<ACCESS>" + entry.lastModified() + "</ACCESS>";
			data += "<MODIFICATION>" + entry.lastModified() + "</MODIFICATION>";
			data += "<CHANGE>" + entry.lastModified() + "</CHANGE>";
			// ********************************
			data += "</TIME>";
			data += "<INFO></INFO>";
			data += "</DIRECTORYITEM>";
		}

		byte[] convert = data.getBytes();

		try {
			data = new String(convert, "US-ASCII");
		} catch (UnsupportedEncodingException e) {
			System.out.println("ERROR: " + e);
			System.exit(1);
		}

		return data;

	}

}
