/*
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org
 *
 * Copyright (C) Eric Farng 2003
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.farng.mp3.id3;

import java.io.IOException;

import org.farng.mp3.InvalidTagException;
import org.farng.mp3.object.ObjectByteArraySizeTerminated;
import org.farng.mp3.object.ObjectNumberHashMap;
import org.farng.mp3.object.ObjectStringNullTerminated;


/**
 * Title: Description: Copyright:    Copyright (c) 2002 Company:
 *
 * @author Eric Farng
 * @version $Revision: 1.1 $
 */
public class FrameBodyGEOB
    extends AbstractID3v2FrameBody {
    /**
     * Creates a new FrameBodyGEOB object.
     */
    public FrameBodyGEOB() {
        //        this.setObject("TextEncoding", new Byte((byte) 0));
        //        this.setObject("MIME Type", "");
        //        this.setObject("Filename", "");
        //        this.setObject("Description", "");
        //        this.setObject("Encapsulated Object", new byte[0]);
    }

    /**
     * Creates a new FrameBodyGEOB object.
     *
     * @param textEncoding DOCUMENT ME!
     * @param mimeType DOCUMENT ME!
     * @param filename DOCUMENT ME!
     * @param description DOCUMENT ME!
     * @param object DOCUMENT ME!
     * @param is6ByteHeader DOCUMENT ME!
     */
    public FrameBodyGEOB(byte textEncoding, String mimeType, String filename,
                         String description, byte[] object,
                         boolean is6ByteHeader) {
        this.setObject("TextEncoding",
                       new Byte(textEncoding));
        this.setObject("MIME Type", mimeType);
        this.setObject("Filename", filename);
        this.setObject("Description", description);
        this.setObject("Encapsulated Object", object);
        this.is6ByteHeader = is6ByteHeader;
    }

    /**
     * Creates a new FrameBodyGEOB object.
     *
     * @param file DOCUMENT ME!
     * @param is6ByteHeader DOCUMENT ME!
     *
     * @throws IOException DOCUMENT ME!
     * @throws InvalidTagException DOCUMENT ME!
     */
    public FrameBodyGEOB(java.io.RandomAccessFile file, boolean is6ByteHeader)
                  throws IOException, InvalidTagException {
        this.is6ByteHeader = is6ByteHeader;
        this.read(file);
    }

    /**
     * DOCUMENT ME!
     *
     * @param description DOCUMENT ME!
     */
    public void setDescription(String description) {
        setObject("Description", description);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getDescription() {
        return (String) getObject("Description");
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getIdentifier() {
        return "GEOB" + ((char) 0) + getDescription();
    }

    /**
     * DOCUMENT ME!
     */
    protected void setupObjectList() {
        objectList.add(new ObjectNumberHashMap(ObjectNumberHashMap.TEXT_ENCODING,
                                               1));
        objectList.add(new ObjectStringNullTerminated("MIME Type"));
        objectList.add(new ObjectStringNullTerminated("Filename"));
        objectList.add(new ObjectStringNullTerminated("Description"));
        objectList.add(new ObjectByteArraySizeTerminated("Encapsulated Object"));
    }
}