/*
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org
 *
 * Copyright (C) Eric Farng 2003
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.farng.mp3.filename;

import java.util.Iterator;


/**
 * <p>
 * Title:
 * </p>
 * 
 * <p>
 * Description:
 * </p>
 * 
 * <p>
 * Copyright: Copyright (c) 2003
 * </p>
 * 
 * <p>
 * Company:
 * </p>
 *
 * @author $author$
 * @version $Revision: 1.1 $
 */
public class FilenameParenthesisIterator
    implements Iterator {
    /** DOCUMENT ME! */
    private Iterator afterIterator = null;

    /** DOCUMENT ME! */
    private Iterator beforeIterator = null;

    /** DOCUMENT ME! */
    private Iterator middleIterator = null;

    /**
     * Creates a new FilenameParenthesisIterator object.
     *
     * @param filenameParenthesis DOCUMENT ME!
     */
    public FilenameParenthesisIterator(FilenameParenthesis filenameParenthesis) {
        if (filenameParenthesis.getBeforeComposite() != null) {
            beforeIterator = filenameParenthesis.getBeforeComposite()
                             .iterator();
        }

        if (filenameParenthesis.getMiddleComposite() != null) {
            middleIterator = filenameParenthesis.getMiddleComposite()
                             .iterator();
        }

        if (filenameParenthesis.getAfterComposite() != null) {
            afterIterator = filenameParenthesis.getAfterComposite()
                            .iterator();
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean hasNext() {
        boolean nextFlag = false;

        if (beforeIterator != null) {
            nextFlag = nextFlag || beforeIterator.hasNext();
        }

        if (middleIterator != null) {
            nextFlag = nextFlag || middleIterator.hasNext();
        }

        if (afterIterator != null) {
            nextFlag = nextFlag || afterIterator.hasNext();
        }

        return nextFlag;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Object next() {
        if ((beforeIterator != null) && beforeIterator.hasNext()) {
            return beforeIterator.next();
        } else if ((middleIterator != null) && middleIterator.hasNext()) {
            return middleIterator.next();
        } else if ((afterIterator != null) && afterIterator.hasNext()) {
            return afterIterator.next();
        }

        return null;
    }

    /**
     * DOCUMENT ME!
     *
     * @throws java.lang.UnsupportedOperationException DOCUMENT ME!
     */
    public void remove() {
        /**
         * @todo Implement this java.util.Iterator method
         */
        throw new java.lang.UnsupportedOperationException("Method remove() not yet implemented.");
    }
}