/*
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org
 *
 * Copyright (C) Eric Farng 2003
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.farng.mp3.id3;

import java.io.IOException;
import java.io.RandomAccessFile;

import org.farng.mp3.InvalidTagException;
import org.farng.mp3.TagUtilities;


/**
 * Title:       ID3v2_2Frame Description: This class is the frame header used
 * in ID3v2.2 tags Copyright:   Copyright (c) 2002 Company:
 *
 * @author Eric Farng
 * @version $Revision: 1.1 $
 */
public class ID3v2_2Frame
    extends AbstractID3v2Frame {
    /**
     * Creates a new ID3v2_2Frame object.
     */
    public ID3v2_2Frame() {}

    /**
     * Creates a new ID3v2_2Frame object.
     *
     * @param file DOCUMENT ME!
     *
     * @throws IOException DOCUMENT ME!
     * @throws InvalidTagException DOCUMENT ME!
     */
    public ID3v2_2Frame(RandomAccessFile file)
                 throws IOException, InvalidTagException {
        this.read(file);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public int getSize() {
        return body.getSize() + 3 + 3;
    }

    /**
     * DOCUMENT ME!
     *
     * @param file DOCUMENT ME!
     *
     * @throws IOException DOCUMENT ME!
     * @throws InvalidTagException DOCUMENT ME!
     */
    public void read(RandomAccessFile file)
              throws IOException, InvalidTagException {
        int    size;
        byte[] buffer = new byte[3];

        // lets scan for a non-zero byte;
        long filePointer;
        byte b;

        do {
            filePointer = file.getFilePointer();
            b           = file.readByte();
            org.farng.mp3.id3.AbstractID3v2.paddingCounter++;
        } while (b == 0);

        file.seek(filePointer);
        org.farng.mp3.id3.AbstractID3v2.paddingCounter--;

        // read the 3 chracter identifier
        file.read(buffer, 0, 3);

        String identifier = new String(buffer, 0, 3);

        // is this a valid identifier?
        if (isValidID3v2FrameIdentifier(identifier) == false) {
            file.seek(file.getFilePointer() - 2);
            throw new InvalidTagException(identifier +
                                          " is not a valid ID3v2.20 frame");
        }

        body = readBody(identifier, file, true);
    }

    /**
     * DOCUMENT ME!
     *
     * @param file DOCUMENT ME!
     *
     * @throws IOException DOCUMENT ME!
     *
     * @todo-javadoc fill this out
     */
    public void write(RandomAccessFile file)
               throws IOException {
        byte[] buffer = new byte[4];

        String str = TagUtilities.truncate(getIdentifier(),
                                           3);

        for (int i = 0; i < str.length(); i++) {
            buffer[i] = (byte) str.charAt(i);
        }

        file.write(buffer,
                   0,
                   str.length());

        body.write(file);
    }
}