/*
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org
 *
 * Copyright (C) Eric Farng 2003
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.farng.mp3.id3;

import java.io.IOException;
import java.io.RandomAccessFile;

import org.farng.mp3.InvalidTagException;


/**
 * Title: Description:  DEPRECATED Copyright:    Copyright (c) 2002 Company:
 *
 * @author Eric Farng`
 * @version $Revision: 1.1 $
 */
public class FrameBodyRVAD
    extends AbstractID3v2FrameBody {
    /** DOCUMENT ME! */
    byte bytesUsed = 16;

    /**
     * DOCUMENT ME!
     *
     * @todo-javadoc write equals functin for this too
     */
    byte increment = 0;

    /** DOCUMENT ME! */
    long peakBass = 0;

    /** DOCUMENT ME! */
    long peakCenter = 0;

    /** DOCUMENT ME! */
    long peakLeft = 0;

    /** DOCUMENT ME! */
    long peakLeftBack = 0;

    /** DOCUMENT ME! */
    long peakRight = 0;

    /** DOCUMENT ME! */
    long peakRightBack = 0;

    /** DOCUMENT ME! */
    long relativeBass = 0;

    /** DOCUMENT ME! */
    long relativeCenter = 0;

    /** DOCUMENT ME! */
    long relativeLeft = 0;

    /** DOCUMENT ME! */
    long relativeLeftBack = 0;

    /** DOCUMENT ME! */
    long relativeRight = 0;

    /** DOCUMENT ME! */
    long relativeRightBack = 0;

    /**
     * Creates a new FrameBodyRVAD object.
     */
    public FrameBodyRVAD() {
        //        this.increment = 0;
        //        this.bytesUsed = (byte) 0;
        //        this.relativeRight = 0;
        //        this.relativeLeft = 0;
        //        this.peakRight = 0;
        //        this.peakLeft = 0;
        //        this.relativeRightBack = 0;
        //        this.relativeLeftBack = 0;
        //        this.peakRightBack = 0;
        //        this.peakLeftBack = 0;
        //        this.relativeCenter = 0;
        //        this.peakCenter = 0;
        //        this.relativeBass = 0;
        //        this.peakBass = 0;
    }

    /**
     * Creates a new FrameBodyRVAD object.
     *
     * @param increment DOCUMENT ME!
     * @param bitsUsed DOCUMENT ME!
     * @param relativeRight DOCUMENT ME!
     * @param relativeLeft DOCUMENT ME!
     * @param peakRight DOCUMENT ME!
     * @param peakLeft DOCUMENT ME!
     * @param relativeRightBack DOCUMENT ME!
     * @param relativeLeftBack DOCUMENT ME!
     * @param peakRightBack DOCUMENT ME!
     * @param peakLeftBack DOCUMENT ME!
     * @param relativeCenter DOCUMENT ME!
     * @param peakCenter DOCUMENT ME!
     * @param relativeBass DOCUMENT ME!
     * @param peakBass DOCUMENT ME!
     * @param is6ByteHeader DOCUMENT ME!
     */
    public FrameBodyRVAD(byte increment, byte bitsUsed, long relativeRight,
                         long relativeLeft, long peakRight, long peakLeft,
                         long relativeRightBack, long relativeLeftBack,
                         long peakRightBack, long peakLeftBack,
                         long relativeCenter, long peakCenter,
                         long relativeBass, long peakBass, boolean is6ByteHeader) {
        this.increment         = increment;
        this.bytesUsed         = (byte) (((bitsUsed - 1) / 8) + 1); // convert to bytes.
        this.relativeRight     = relativeRight;
        this.relativeLeft      = relativeLeft;
        this.peakRight         = peakRight;
        this.peakLeft          = peakLeft;
        this.relativeRightBack = relativeRightBack;
        this.relativeLeftBack  = relativeLeftBack;
        this.peakRightBack     = peakRightBack;
        this.peakLeftBack      = peakLeftBack;
        this.relativeCenter    = relativeCenter;
        this.peakCenter        = peakCenter;
        this.relativeBass      = relativeBass;
        this.peakBass          = peakBass;
        this.is6ByteHeader     = is6ByteHeader;
    }

    /**
     * Creates a new FrameBodyRVAD object.
     *
     * @param file DOCUMENT ME!
     * @param is6ByteHeader DOCUMENT ME!
     *
     * @throws IOException DOCUMENT ME!
     * @throws InvalidTagException DOCUMENT ME!
     */
    public FrameBodyRVAD(java.io.RandomAccessFile file, boolean is6ByteHeader)
                  throws IOException, InvalidTagException {
        this.is6ByteHeader = is6ByteHeader;
        this.read(file);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getIdentifier() {
        return "RVAD";
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public int getSize() {
        int size = 2 + (bytesUsed * 4);

        if ((relativeRightBack != 0) || (relativeLeftBack != 0) ||
                (peakRightBack != 0) || (peakLeftBack != 0)) {
            size += (bytesUsed * 4);
        }

        if ((relativeCenter != 0) || (peakCenter != 0)) {
            size += (bytesUsed * 2);
        }

        if ((relativeBass != 0) || (peakBass != 0)) {
            size += (bytesUsed * 2);
        }

        return size;
    }

    /**
     * DOCUMENT ME!
     *
     * @param file DOCUMENT ME!
     *
     * @throws IOException DOCUMENT ME!
     * @throws InvalidTagException DOCUMENT ME!
     */
    public void read(RandomAccessFile file)
              throws IOException, InvalidTagException {
        int    size;
        int    offset = 0;
        byte[] buffer;
        String str;

        size   = readHeader(file);
        buffer = new byte[size];
        file.read(buffer);
        str = new String(buffer);

        this.increment = buffer[offset++];
        this.bytesUsed = (byte) (((buffer[offset++] - 1) / 8 * 8) + 1);

        for (int i = 0; i < (int) bytesUsed; i++) {
            relativeRight = (relativeRight << 8) + buffer[i + offset];
        }

        offset += bytesUsed;

        for (int i = 0; i < (int) bytesUsed; i++) {
            relativeLeft = (relativeLeft << 8) + buffer[i + offset];
        }

        offset += bytesUsed;

        for (int i = 0; i < (int) bytesUsed; i++) {
            peakRight = (peakRight << 8) + buffer[i + offset];
        }

        offset += bytesUsed;

        for (int i = 0; i < (int) bytesUsed; i++) {
            peakLeft = (peakLeft << 8) + buffer[i + offset];
        }

        offset += bytesUsed;

        if (size > (2 + (bytesUsed * 4))) {
            for (int i = 0; i < (int) bytesUsed; i++) {
                relativeRightBack = (relativeRightBack << 8) +
                                    buffer[i + offset];
            }

            offset += bytesUsed;

            for (int i = 0; i < (int) bytesUsed; i++) {
                relativeLeftBack = (relativeLeftBack << 8) +
                                   buffer[i + offset];
            }

            offset += bytesUsed;

            for (int i = 0; i < (int) bytesUsed; i++) {
                peakRightBack = (peakRightBack << 8) + buffer[i + offset];
            }

            offset += bytesUsed;

            for (int i = 0; i < (int) bytesUsed; i++) {
                peakLeftBack = (peakLeftBack << 8) + buffer[i + offset];
            }

            offset += bytesUsed;
        }

        if (size > (2 + (bytesUsed * 8))) {
            for (int i = 0; i < (int) bytesUsed; i++) {
                relativeCenter = (relativeCenter << 8) + buffer[i + offset];
            }

            offset += bytesUsed;

            for (int i = 0; i < (int) bytesUsed; i++) {
                peakCenter = (peakCenter << 8) + buffer[i + offset];
            }

            offset += bytesUsed;
        }

        if (size > (2 + (bytesUsed * 10))) {
            for (int i = 0; i < (int) bytesUsed; i++) {
                relativeBass = (relativeBass << 8) + buffer[i + offset];
            }

            offset += bytesUsed;

            for (int i = 0; i < (int) bytesUsed; i++) {
                peakBass = (peakBass << 8) + buffer[i + offset];
            }

            offset += bytesUsed;
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String toString() {
        return increment + " " + (bytesUsed * 8) + " " + // convert back to bits
               relativeRight + " " + relativeLeft + " " + peakRight + " " +
               peakLeft + " " + relativeRightBack + " " + relativeLeftBack +
               " " + peakRightBack + " " + peakLeftBack + " " + relativeCenter +
               " " + peakCenter + " " + relativeBass + " " + peakBass + " " +
               is6ByteHeader;
    }

    /**
     * DOCUMENT ME!
     *
     * @param file DOCUMENT ME!
     *
     * @throws IOException DOCUMENT ME!
     */
    public void write(RandomAccessFile file)
               throws IOException {
        byte[] buffer;
        int    offset = 0;

        writeHeader(file,
                    this.getSize());

        buffer = new byte[this.getSize()];

        buffer[offset++] = this.increment;
        buffer[offset++] = this.bytesUsed;

        for (int i = 0; i < (int) bytesUsed; i++) {
            buffer[i + offset] = (byte) (relativeRight >> ((bytesUsed - i - 1) * 8));
        }

        offset += this.bytesUsed;

        for (int i = 0; i < (int) bytesUsed; i++) {
            buffer[i + offset] = (byte) (relativeLeft >> ((bytesUsed - i - 1) * 8));
        }

        offset += this.bytesUsed;

        for (int i = 0; i < (int) bytesUsed; i++) {
            buffer[i + offset] = (byte) (peakRight >> ((bytesUsed - i - 1) * 8));
        }

        offset += this.bytesUsed;

        for (int i = 0; i < (int) bytesUsed; i++) {
            buffer[i + offset] = (byte) (peakLeft >> ((bytesUsed - i - 1) * 8));
        }

        offset += this.bytesUsed;

        if ((relativeRightBack != 0) || (relativeLeftBack != 0) ||
                (peakRightBack != 0) || (peakLeftBack != 0)) {
            for (int i = 0; i < (int) bytesUsed; i++) {
                buffer[i + offset] = (byte) (relativeRightBack >> ((bytesUsed -
                                     i - 1) * 8));
            }

            offset += this.bytesUsed;

            for (int i = 0; i < (int) bytesUsed; i++) {
                buffer[i + offset] = (byte) (relativeLeftBack >> ((bytesUsed -
                                     i - 1) * 8));
            }

            offset += this.bytesUsed;

            for (int i = 0; i < (int) bytesUsed; i++) {
                buffer[i + offset] = (byte) (peakRightBack >> ((bytesUsed - i -
                                     1) * 8));
            }

            offset += this.bytesUsed;

            for (int i = 0; i < (int) bytesUsed; i++) {
                buffer[i + offset] = (byte) (peakLeftBack >> ((bytesUsed - i -
                                     1) * 8));
            }

            offset += this.bytesUsed;
        }

        if ((relativeCenter != 0) || (peakCenter != 0)) {
            for (int i = 0; i < (int) bytesUsed; i++) {
                buffer[i + offset] = (byte) (relativeCenter >> ((bytesUsed - i -
                                     1) * 8));
            }

            offset += this.bytesUsed;

            for (int i = 0; i < (int) bytesUsed; i++) {
                buffer[i + offset] = (byte) (peakCenter >> ((bytesUsed - i - 1) * 8));
            }

            offset += this.bytesUsed;
        }

        if ((relativeBass != 0) || (peakBass != 0)) {
            for (int i = 0; i < (int) bytesUsed; i++) {
                buffer[i + offset] = (byte) (relativeBass >> ((bytesUsed - i -
                                     1) * 8));
            }

            offset += this.bytesUsed;

            for (int i = 0; i < (int) bytesUsed; i++) {
                buffer[i + offset] = (byte) (peakBass >> ((bytesUsed - i - 1) * 8));
            }

            offset += this.bytesUsed;
        }

        file.write(buffer);
    }
}