/*
 * MP3 Tag library. It includes an implementation of the ID3 tags and Lyrics3
 * tags as they are defined at www.id3.org
 *
 * Copyright (C) Eric Farng 2003
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.farng.mp3.id3;

import java.io.IOException;
import java.io.RandomAccessFile;

import org.farng.mp3.InvalidTagException;


/**
 * Title: Description: Copyright:    Copyright (c) 2002 Company:
 *
 * @author Eric Farng
 * @version $Revision: 1.1 $
 */
public class FrameBodyASPI
    extends AbstractID3v2FrameBody {
    /** DOCUMENT ME! */
    short[] fraction = null;

    /** DOCUMENT ME! */
    int bitsPerPoint = 0;

    /** DOCUMENT ME! */
    int dataLength = 0;

    /**
     * DOCUMENT ME!
     *
     * @todo-javadoc write equals functin for this too
     */
    int dataStart = 0;

    /** DOCUMENT ME! */
    int indexPoints = 0;

    /**
     * Creates a new FrameBodyASPI object.
     */
    public FrameBodyASPI() {
        //        this.dataStart = 0;
        //        this.dataLength = 0;
        //        this.indexPoints = 0;
        //        this.bitsPerPoint = 0;
        //        this.fraction = new short[0];
    }

    /**
     * Creates a new FrameBodyASPI object.
     *
     * @param dataStart DOCUMENT ME!
     * @param dataLength DOCUMENT ME!
     * @param indexPoints DOCUMENT ME!
     * @param bitsPerPoint DOCUMENT ME!
     * @param fraction DOCUMENT ME!
     * @param is6ByteHeader DOCUMENT ME!
     */
    public FrameBodyASPI(int dataStart, int dataLength, int indexPoints,
                         int bitsPerPoint, short[] fraction,
                         boolean is6ByteHeader) {
        this.dataStart     = dataStart;
        this.dataLength    = dataLength;
        this.indexPoints   = indexPoints;
        this.bitsPerPoint  = bitsPerPoint;
        this.fraction      = fraction;
        this.is6ByteHeader = is6ByteHeader;
    }

    /**
     * Creates a new FrameBodyASPI object.
     *
     * @param file DOCUMENT ME!
     * @param is6ByteHeader DOCUMENT ME!
     *
     * @throws IOException DOCUMENT ME!
     * @throws InvalidTagException DOCUMENT ME!
     */
    public FrameBodyASPI(java.io.RandomAccessFile file, boolean is6ByteHeader)
                  throws IOException, InvalidTagException {
        this.is6ByteHeader = is6ByteHeader;
        this.read(file);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getIdentifier() {
        return "ASPI";
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public int getSize() {
        return 4 + 4 + 2 + 1 + (this.fraction.length * 2);
    }

    /**
     * DOCUMENT ME!
     *
     * @param file DOCUMENT ME!
     *
     * @throws IOException DOCUMENT ME!
     * @throws InvalidTagException DOCUMENT ME!
     */
    public void read(RandomAccessFile file)
              throws IOException, InvalidTagException {
        int    size;
        int    delim;
        int    offset = 0;
        byte[] buffer;
        String str;

        size = readHeader(file);

        if (size == 0) {
            throw new InvalidTagException("Empty Frame");
        }

        this.dataStart    = file.readInt();
        this.dataLength   = file.readInt();
        this.indexPoints  = file.readShort();
        this.bitsPerPoint = file.readByte();

        fraction = new short[indexPoints];

        for (int i = 0; i < indexPoints; i++) {
            if (bitsPerPoint == 8) {
                fraction[i] = file.readByte();
            } else if (bitsPerPoint == 16) {
                fraction[i] = file.readShort();
            } else {
                throw new InvalidTagException("ASPI bits per point wasn't 8 or 16");
            }
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String toString() {
        return getIdentifier() + " " + this.dataStart + " " + this.dataLength +
               " " + this.indexPoints + " " + this.bitsPerPoint + " " +
               this.fraction.toString() + " " + this.is6ByteHeader;
    }

    /**
     * DOCUMENT ME!
     *
     * @param file DOCUMENT ME!
     *
     * @throws IOException DOCUMENT ME!
     */
    public void write(RandomAccessFile file)
               throws IOException {
        byte[] buffer;
        int    offset = 0;

        writeHeader(file,
                    this.getSize());

        file.writeInt(this.dataStart);
        file.writeInt(this.dataLength);
        file.writeShort(this.indexPoints);
        file.writeByte(16);

        for (int i = 0; i < indexPoints; i++) {
            file.writeShort(this.fraction[i]);
        }
    }
}