package kr.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * Synchronizes the existence of an element between several collections. (i.e.
 * if an element is removed from this collection, it is removed from all collections
 * this CollectionSync knows about)
 */
public class CollectionSync {
	private List<Collection> collections = new ArrayList<Collection>();

	public void addCollection(Collection c)
	{
		this.collections.add(c);
	}
	
	public void deleteFromAll(Object o)
	{
		for(Collection c : collections)
		{
			c.remove(o);
		}
	}
}
