package kr.miditunemodel;

import kr.util.ListenerManager;
import kr.util.audio.AudioClip;
import kr.util.audio.MidiAudioClip;

public class NoteEventGuiModel extends EventGuiModel<NoteEvent>
{
	public NoteEventGuiModel(MidiTuneModel midiTuneModel) {
		super(midiTuneModel.getNoteEventGroup());
		this.realTimeMidiAudioClip = new MidiAudioClip(48000);		
	}
	
	public enum MessageType { REAL_TIME_NOTE_UPDATED, TEXT_UPDATED };

	private byte playedNote = -1;
	private MidiAudioClip realTimeMidiAudioClip;

	public void playNote(byte playedNote) {
		if(playedNote == this.playedNote) return;
		this.playedNote = playedNote; 
		realTimeMidiAudioClip.playMidi(playedNote);
		ListenerManager.inst().notify(this, MessageType.REAL_TIME_NOTE_UPDATED);
	}

	/**
	 * This is just the current note that is actually being played through
	 * the speakers. It is not related to a NoteEvent
	 */
	public byte getPlayedNote() {
		return playedNote;
	}

	public AudioClip getRealTimeMidiAudioClip() {
		return realTimeMidiAudioClip;
	}
	
	public void updateText(NoteEvent e, String text)
	{
		e.setKRText(text);
		ListenerManager.inst().notify(this, MessageType.TEXT_UPDATED);
	}

}
