package kr.miditunemodel;



import kr.util.Util;

public class NoteEvent extends Event
{
	//it seems that all text corresponds to the same time as a note in KR,
	//so we do the same here.
	String text = "";

	byte note;

	private int strength;
	
	/**
	 * Organizes kr tags (+,.,$) and
	 * strips out non supported characters
	 */
	public void setKRText(String message) {
		text = Util.removeCharsNotIn(message," ABCDEFGHIJKLMNOPQRSTUVWXYZ'abcdefghijklmnopqrstuvwxyz-+.$");
		
		boolean dotExists = text.indexOf('.') != -1;
		boolean dollarExists = text.indexOf('$') != -1;
		boolean plusExists = text.indexOf('+') != -1;
		
		text = Util.removeChars(text, '.','+','$');
		
		if(dollarExists && !dotExists)
			dotExists = true;
		
		if(isHead()) plusExists = false;
		
		text = (plusExists ? "+" : "")  + text + (dotExists ? "." : "") + (dollarExists ? "$" : "");
	}

	public NoteEvent(byte[] message, long micros) {
		super(Type.TUNE, micros);
		note = message[1];
		strength = message[2];
	}

	public NoteEvent(byte note, int strength, long micros) {
		super(Type.TUNE, micros);
		this.note = note;
		this.strength = strength;
	}

	public boolean isContinuation() {
		return text.indexOf("+") != -1;
	}
	
	public boolean isStanzaEnd()
	{
		return text.indexOf(".") != -1;
	}

	public boolean isUncountedStanzaEnd()
	{
		return text.indexOf("$") != -1;
	}

	public String getText() {
		return text;
	}

	public void setText(String text) {
		this.text = text;
	}

	public int compareTo(Event e)
	{
		int v = super.compareTo(e);
		
		if(v==0)
		{
			//System.out.println(this+" compareTo "+e+" is 0");
		}
		
		return v;
	}
	
	public String toString()
	{
		return String.format("%s(micros=%d,note=%02x,text=%s," +
				"strength=%02x)",
				super.toString(),getMicros(),note,getText(),
				strength);
	}

	public byte getNote() {
		return note;
	}

	public void setNote(byte note) {
		this.note = note;
	}

	@Override
	public NoteEvent clone() {
		NoteEvent c = new NoteEvent(note, strength, getMicros());
		c.setEndMicros(getEndMicros());
		
		return c;
	}

}