package kr.miditunemodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import kr.miditunemodel.MidiTuneModel.MessageType;
import kr.undo.Operation;
import kr.undo.Transaction;

/**
 * A Transaction of operations involving midi notes
 */
public class MidiNoteTransaction extends MidiTransaction<NoteEvent>
{
	public MidiNoteTransaction(NoteEventGroup g)
	{
		super(g);
	}
	
	@Override
	/**
	 * Has the side effect of resorting the notes in the group
	 */
	protected boolean isValid() {
		//The midi tune model will check if the result is invalid 
		//(notes are overlapping, etc.), after performing the transaction
		return eventGroup.reseat(getEvents());
	}

}
