package kr.gui.midigraph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;

import kr.gui.GuiModel;
import kr.util.audio.MidiAudioClip;
import kr.util.ft.SpectrumAnalyzer;

public class ScaleUI extends UI
{
	private int minNote;
	private int maxNote;
	private MidiTuneGraph comp;
	private GuiModel gm;

	public ScaleUI(GuiModel gm, MidiTuneGraph comp, int minNote, int maxNote)
	{
		this.gm = gm;
		this.comp = comp;
		this.minNote = minNote;
		this.maxNote = maxNote;
	}
	
	
	public void drawScale(Graphics2D g, int startX, int endX)
	{
		int w = comp.getWidth();
		int h = comp.getHeight();
		double step = h / (maxNote - minNote + 1.);
		
		//if the step is so small we would end up painting the same note twice at the same pos,
		//skip some notes
		if(step < 1) step = step * Math.ceil(2. / step);

		double start = step/2.;

		g.setColor(Color.LIGHT_GRAY);
		for(double i = start; i < h; i+= step)
		{
			g.drawLine(startX, (int)Math.round(i), endX, (int)Math.round(i));
		}
	}
	
	public int noteToPixels(int note) {
		return comp.getHeight()-(int)Math.round(comp.getHeight()/(maxNote - minNote + 1.) * (note - minNote + .5));
	}

	public byte pixelsToNote(int y) {
		return (byte)(Math.round(((double)comp.getHeight()-y-1) / comp.getHeight() * (maxNote - minNote + 1) + .5 + minNote));
	}


}
