package kr.gui.midigraph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;

import kr.miditunemodel.NoteEvent;

public class NoteUI extends UI
{
	private static final int NOTE_BUD_HALF_WIDTH = 2;
	private static final int NOTE_BUD_HALF_HEIGHT = 2;
	private static final int SELECTED_NOTE_BUD_HALF_WIDTH = 3;
	private static final int SELECTED_NOTE_BUD_HALF_HEIGHT = 3;
	
	private static final int CONTINUATION_SHIFT = 5;
	
	private static final Color STANZA_END = Color.BLACK;
	private static final Color NOT_COUNTED_STANZA_END = Color.GRAY;
	
	private ScaleUI scaleUI;
	private MidiTuneGraph mg;
	
	public NoteUI(ScaleUI scaleUI, MidiTuneGraph mg)
	{
		this.scaleUI = scaleUI;
		this.mg = mg;
	}
	
	public void drawNoteLine(Graphics2D g, NoteEvent ne, boolean selected) 
	{
	    int startX = mg.microsToPixels(ne.getMicros());
	    int endX = mg.microsToPixels(ne.getEndMicros());
	    int y = scaleUI.noteToPixels(ne.getNote());
	    
	    
        g.setColor(Color.BLUE);

//        int straightXStart = startX;
//	    if(ne.isContinuation())
//	    	straightXStart = Math.min(startX + CONTINUATION_SHIFT, endX);
        
        g.drawLine(startX, y, endX, y);
        
        int noteBudHalfWidth, noteBudHalfHeight;
        if(selected)
        {
        	g.setColor(Color.BLACK);
        	noteBudHalfWidth = SELECTED_NOTE_BUD_HALF_WIDTH;
        	noteBudHalfHeight = SELECTED_NOTE_BUD_HALF_HEIGHT;
        }
        else
        {
        	noteBudHalfWidth = NOTE_BUD_HALF_WIDTH;
        	noteBudHalfHeight = NOTE_BUD_HALF_HEIGHT;
        }

        
        drawNoteBud(g, startX, y, noteBudHalfWidth, noteBudHalfHeight);
        drawNoteBud(g, endX, y, noteBudHalfWidth, noteBudHalfHeight);
        
        if(ne.isStanzaEnd())
        {
        	g.setColor(STANZA_END);
        	g.drawLine(endX,0,endX,mg.getHeight());
        }
        else if(ne.isUncountedStanzaEnd())
        {
        	g.setColor(STANZA_END);
        	g.drawLine(endX,0,endX,mg.getHeight());
        }
	}

	private void drawNoteBud(Graphics2D g, int x, int y, int noteBudHalfWidth, int noteBudHalfHeight) {
		g.fillRect(x - noteBudHalfWidth, y - noteBudHalfHeight, 2 * noteBudHalfWidth + 1, 2 * noteBudHalfHeight + 1);
	}

	public void drawContinuationLine(Graphics2D g, NoteEvent ne1, NoteEvent ne2) {
	    int startX = mg.microsToPixels(ne1.getEndMicros());
	    int endX = mg.microsToPixels(ne2.getMicros());
	    int startY = scaleUI.noteToPixels(ne1.getNote());
	    int endY = scaleUI.noteToPixels(ne2.getNote());

        g.setColor(Color.BLUE);
        
        g.drawLine(startX, startY, endX, endY);
	}

}
