package kr.gui;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

import kr.AudioModel;
import kr.MidiFileModel;
import kr.gui.GuiModel;
import kr.miditunemodel.MidiTuneModel;
import kr.util.Listener;
import kr.util.ListenerManager;
import kr.util.NotificationManager;

/**
 * This represents the state of the entire application
 */
public class Model implements Listener 
{

	private GuiModel guiModel;
	private AudioModel audioModel;
	private MidiFileModel midiFileModel;
	
	public enum MessageType { MAX_MILLIS_UPDATED } ;
	
	public Model()
	{
		midiFileModel = new MidiFileModel();
		audioModel = new AudioModel();
		guiModel = new GuiModel(audioModel, midiFileModel.getMidiTuneModel());
		
		ListenerManager.inst().registerListener(audioModel, this);
		ListenerManager.inst().registerListener(midiFileModel.getMidiTuneModel(), this);
	}

	public MidiTuneModel getMidiModel() {
		return midiFileModel.getMidiTuneModel();
	}

	public AudioModel getAudioModel() {
		return audioModel;
	}

	public GuiModel getGuiModel()
	{
		return guiModel;
	}

	public int getMaxMilliSeconds() {
		
		return 
		Math.max(midiFileModel.getMidiTuneModel().getMaxMilliSeconds(), audioModel.getMaxMilliSeconds());
	}

	public MidiFileModel getMidiFileModel() {
		return midiFileModel;
	}

	public void notify(Object source, Object type, Object... values) {
		if(source == audioModel || source == midiFileModel.getMidiTuneModel() 
				&& type == MidiTuneModel.MessageType.LENGTH_UPDATED)
		{
			ListenerManager.inst().notify(this, MessageType.MAX_MILLIS_UPDATED);
		}
		
	}

	public void loadKRPackage(File krFile) {
		try
		{
			ZipFile zf = new ZipFile(krFile);
			
			
		}
		catch(IOException e)
		{
			e.printStackTrace();
			NotificationManager.inst().error("Cannot read KR zip file: "+e);
		}
		
	}
}
