package kr.gui;

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.sound.midi.Track;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;

import kr.MidiFileModel;
import kr.gui.util.MilliTimeLabelTable;
import kr.midireader.MidiAnalyzer;

public class MidiChooserPanel extends JDialog
{
	private MidiFileModel midiFileModel;
	JButton select;
	JRadioButton [] lyrics, tune, krEvents;

	public MidiChooserPanel(MidiFileModel midiFileModel, JFrame owner)
	{
		super(owner);
		this.midiFileModel = midiFileModel;
//		controller.init(this, midiFileModel, midiFileModel.getMidiTuneModel());
		setModal(false);
		init(); 
	}
	
	/**
	 * Creates components for panel. 
	 */
	private void init()
	{
		Track [] tracks = midiFileModel.getTracks();
		//content.removeAll();
		
		Container content = getContentPane();
		
        content.setLayout(new GridBagLayout());


        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 0; c.weighty = 0;
        c.fill = c.BOTH;
        c.gridx=c.gridy=0;
        c.gridwidth=5;
        c.insets = new Insets(3,3,3,3);
        
        content.add(new JLabel("Choose tracks for the lyrics, vocals tune and kr events"),c);

        c.gridy++;
        c.gridwidth=1;
       
        content.add(new JLabel("Lyrics"),c);
        
        c.gridx++;
        content.add(new JLabel("Tune"),c);
        
        c.gridx++;
        content.add(new JLabel("KR Events"),c);

        c.gridx++;
        content.add(new JLabel("#"),c);

        c.gridx++;
        c.weightx=1;
        content.add(new JLabel("Track Description"),c);
        
        c.gridx=0;
        
        lyrics = new JRadioButton [tracks.length+1];
        tune = new JRadioButton [tracks.length+1];
        krEvents = new JRadioButton [tracks.length+1];
        
        ButtonGroup lyricsGroup = new ButtonGroup(), 
        vocalsGroup = new ButtonGroup(),
        krEventsGroup = new ButtonGroup();

        for(int i = 0; i < lyrics.length; i++)
        {
        	c.gridy++;
        	c.gridx = 0;
            c.weightx=0;
            content.add(lyrics[i] = new JRadioButton(),c);
        	c.gridx++;
        	content.add(tune[i] = new JRadioButton(),c);
        	c.gridx++;
        	content.add(krEvents[i] = new JRadioButton(),c);
        	c.gridx++;
        	
        	if(i != 0)
        		content.add(new JLabel(String.valueOf(i)), c);
        	c.gridx++;
        	        	
            c.weightx=1;
          
            if(i==0)
            {
            	content.add(new JLabel("None"),c);
            }
            else
            	content.add(new JLabel(MidiAnalyzer.getTrackDescription(tracks[i-1])),c);

        	lyricsGroup.add(lyrics[i]);
        	vocalsGroup.add(tune[i]);
        	krEventsGroup.add(krEvents[i]);
        	
        }
        
        c.weightx=0;c.gridwidth=5;
        c.gridy++; c.gridx=0; c.fill = c.NONE;
        content.add(select = new JButton("Select"),c);
        
        int guessedLyricIndex = MidiAnalyzer.guessLyricsTrack(tracks);
        int guessedTuneIndex = MidiAnalyzer.guessTuneTrack(tracks, guessedLyricIndex);
        
       	lyrics[guessedLyricIndex + 1].setSelected(true);
        tune[guessedTuneIndex + 1].setSelected(true);
        krEvents[0].setSelected(true);

        pack();
        //setSize(600, 400);
 	}
	
	private Track getChosenTrack(JRadioButton [] list)
	{
		for(int i = 0; i < lyrics.length; i++)
		{
			if(list[i].isSelected())
			{
				if(i == 0) //if "None" was selected
					return null;
				return midiFileModel.getTracks()[i-1];
			}
		}
		
		return null;
	}
	
	public Track getChosenLyrics() {
		return getChosenTrack(lyrics);
	}

	public Track getChosenTune() {
		return getChosenTrack(tune);
	}

	public Track getChosenKREvents() {
		return getChosenTrack(krEvents);
	}

	public Track getTempoEvents() {
		return midiFileModel.getTracks()[0];
	}

}
