package kr.gui;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class KRMenuBar extends JMenuBar 
{
	JMenuItem loadVocals;
	JMenuItem loadBkg;
	JMenuItem loadMidi;
	JMenuItem saveKR;
	JMenuItem showMidiTrackChooser;
	JMenuItem saveKRPackage;
	JMenuItem loadKRPackage;
	JMenuItem clearVocals, clearBkg;
	
	JCheckBoxMenuItem deriveBackgroundFromVocals; 
	JCheckBoxMenuItem normalizeVocals, normalizeBackground, viewVocalsFFT;
	JMenu file, edit;
	JMenuItem generateKREvents; 
	
	
	public KRMenuBar(Model model, KRMenuController menuController, JFrame mainFrame) {
		init();
		menuController.init(model, this, mainFrame);
	}

	private void init()
	{
		file = new JMenu("File");
		file.setMnemonic(KeyEvent.VK_F);
		this.add(file);
		
        loadVocals = new JMenuItem("Load Vocals / Master Audio Track",
                KeyEvent.VK_V);
        file.add(loadVocals);
        loadBkg = new JMenuItem("Load Background Audio Track",
                KeyEvent.VK_B);
        file.add(loadBkg);
        
        clearVocals = new JMenuItem("Clear Vocals / Master Audio Track");
        file.add(clearVocals);
        clearBkg = new JMenuItem("Clear Background Audio Track");
        file.add(clearBkg);

        loadMidi = new JMenuItem("Load Midi Tune",
                KeyEvent.VK_M);
        file.add(loadMidi);
        saveKR = new JMenuItem("Save KR Midi Only",
                KeyEvent.VK_S);
        file.add(saveKR);
        
        showMidiTrackChooser = new JMenuItem("Show MIDI Track chooser",
                KeyEvent.VK_T);
//        file.add(showMidiTrackChooser);
        
        saveKRPackage = new JMenuItem("Save KR Song Package");
        file.add(saveKRPackage);
        loadKRPackage = new JMenuItem("Load KR Song Package");
        //file.add(loadKRPackage);
        
		edit = new JMenu("Edit");
		edit.setMnemonic(KeyEvent.VK_E);
		this.add(edit);

		deriveBackgroundFromVocals = new JCheckBoxMenuItem("Derive Background from Vocals / Master (L-R method)", false);
        edit.add(deriveBackgroundFromVocals);

//        normalizeVocals = new JCheckBoxMenuItem("Normalize Vocals", false);
//        edit.add(normalizeVocals);
//        
//        normalizeBackground = new JCheckBoxMenuItem("Normalize Background", false);
//        edit.add(normalizeBackground);
//        
        viewVocalsFFT = new JCheckBoxMenuItem("View Vocals FFT in note scale", false);
        generateKREvents = new JMenuItem("Generate KR Events");
        edit.add(generateKREvents);
	}

}
