package kr.gui;

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.text.SimpleDateFormat;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import kr.gui.util.MaxLengthRestrictor;
import kr.gui.util.RegexpRestrictor;
import kr.gui.util.RestrictedField;

public class KRCreateDialog extends JDialog {
	
	private static final String dbDtaText = 
	    "(songabbr ; will be replaced by song abbrevation\n"+
	    "   ( Bulwinkle \" 9/10/03 \" 12000 kRatingPass)\n"+
	    "   ( Rocky \" 9/10/03 \" 11000 kRatingPass)\n"+
	    "   ( Boris \" 9/10/03 \" 9500 kRatingPass)\n"+
	    "   ( Sherman \" 9/10/03 \" 10000 kRatingPass)\n"+
	    ")\n";

	private static final String songDtaText =
		"(songabbr ; will be replaced by song abbrevation\n"+
		"   (title  \"<Title>\")\n"+
		"   (artist \"<Artist>\")\n"+
		"   (song_length \"${song_length}\")\n"+
		"   (complexity kCompAverage) ; options are: kCompSimple kCompAverage kCompDifficult\n"+
		"   (bpm 80)\n"+
		"   (genre kGenreRock) ; options are: kGenre70s kGenre80s kGenreRock kGenreSlow\n"+
		"   (preview ${pre_start} ${pre_end}) ; start and end for song preview in millis\n"+
		"   (hud_time_scale 2.0) ; number of seconds in one screen in scrolling version\n"+
		"   (hud_lyric_scale 1.2)  ; scale of lyric font (1 = normal, 2 = twice as big)\n"+
		"   (boot_sound heavy) ; options are: dj light heavy \n"+
		"   (stage_chars guitarist drummer bassist keyboardist); options are one or more of: dj guitarist drummer bassist keyboardist\n"+
		")\n";

	RestrictedField songAbbr;

	JTextArea dbData;

	JTextArea songsData;

	JTextField directory;

	JButton submitButton;
	

	public KRCreateDialog()
	{
		init();
	}
	
	private void init()
	{
		Container content = getContentPane();
		content.setLayout(new GridBagLayout());
		GridBagConstraints c = new GridBagConstraints();
		
		c.anchor=c.WEST;
		c.insets = new Insets(0,0,5,5);
		
		c.gridx = c.gridy = 0;
		
		content.add(new JLabel("Song Abbreviation"),c);
		
		songAbbr = new RestrictedField(8);
		songAbbr.addInsertRestrictor(new RegexpRestrictor("[^a-z0-9]",""));
		songAbbr.addInsertRestrictor(new MaxLengthRestrictor(8));
		
		c.gridx++;	
		content.add(songAbbr, c);
		
		c.gridx = 0;
		c.gridy++;
		
		content.add(new JLabel("Directory"),c);
		
		c.gridx++;	
		c.fill = c.HORIZONTAL;
		content.add(directory = new JTextField("."+File.separator,10), c);
		
		c.gridx = 0;
		c.gridy++;
		c.gridwidth=2;
		c.fill = c.NONE;
		
		content.add(new JLabel("db.dta entry"),c);
		
		c.gridy++;	
		c.weightx = c.weighty = 1;
		c.fill = c.BOTH;
		dbData = addTextArea(content, c);
		dbData.setText(dbDtaText);

		c.gridx = 0;
		c.gridy++;
		c.weightx = c.weighty = 0;
		c.fill = c.NONE;
		
		content.add(new JLabel("songs.dta entry"),c);
		
		c.gridy++;	
		c.weightx = c.weighty = 1;
		c.fill = c.BOTH;
		songsData = addTextArea(content, c);
		songsData.setText(songDtaText);
		
		c.gridy++;	
		c.weightx = c.weighty = 0;
		c.fill = c.NONE;
		c.anchor = c.CENTER;
		content.add(submitButton = new JButton("Submit"), c);
		
		pack();
	}
	
	private JTextArea addTextArea(Container content, GridBagConstraints c)
	{	
        //Create a text area.
        JTextArea textArea = new JTextArea();
        textArea.setLineWrap(false);
        JScrollPane areaScrollPane = new JScrollPane(textArea);
        areaScrollPane.setVerticalScrollBarPolicy(
                        JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        areaScrollPane.setHorizontalScrollBarPolicy(
                JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        
        content.add(areaScrollPane, c);
        
        //areaScrollPane.setPreferredSize(new Dimension(250, 250));

        return textArea;
	}

	public void initForNewSong(int maxMilliSeconds) 
	{
		String songLength = String.format("%d:%02d", maxMilliSeconds / 60 / 1000, (maxMilliSeconds / 1000) % 60);
		long preStart = Math.round(maxMilliSeconds * .2);
		long preEnd = preStart + 30 * 1000;
		String currSongDta = songDtaText.replace("${song_length}", songLength).
		replace("${pre_start}",String.valueOf(preStart)).
		replace("${pre_end}",String.valueOf(preEnd));
		
		dbData.setText(dbDtaText);
		songsData.setText(currSongDta);
	}
}

class KRCreateDialogTest
{
	public static void main(String [] argv)
	{
		new KRCreateDialog().setVisible(true);
	}
}