/*
	Copyright 2003 Chris Cavey
	
	This file is part of XID.
	
	XID is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
	
	XID is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with XID; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __XID_H__
#define __XID_H__

#ifdef __cplusplus
extern "C"
{
#endif
	#include "wdm.h"
	#include "usbdi.h"
#ifdef __cplusplus
}
#endif
#include "xidreport.h"
#include "xidtypes.h"
#include "xidguid.h"

struct DEVICE_EXTENSION
{
	USBD_CONFIGURATION_HANDLE UsbConfigurationHandle;	// Selected Configuration handle
	USBD_PIPE_HANDLE UsbInputPipe;	// Handle to input interrupt pipe
	USBD_PIPE_HANDLE UsbOutputPipe;	// Handle to output interrupt pipe
    USHORT ProductId;
	USHORT VendorId;
	KSPIN_LOCK lockReport;
	
	XIDREPORT reportGen; // using the previous two classes, this will generate the output report

	UNICODE_STRING ifSymLinkName;
    KEVENT         RemoveEvent;
    LONG           RequestCount;
    BOOLEAN        fRemoved;
    BOOLEAN        fStarted;
    BOOLEAN        fSurpriseRemoved;
};

#define GET_MINIDRIVER_DEVICE_EXTENSION(DO) ((DEVICE_EXTENSION*) (((PHID_DEVICE_EXTENSION)(DO)->DeviceExtension)->MiniDeviceExtension))
#define GET_NEXT_DEVICE_OBJECT(DO) (((PHID_DEVICE_EXTENSION)(DO)->DeviceExtension)->NextDeviceObject)
#define GET_HID_DEVICE_EXTENSION(DO) ((PHID_DEVICE_EXTENSION)(DO)->DeviceExtension)
#define MINIDRIVER_FROM_HID_DEVICE(DX) ((DEVICE_EXTENSION*)(DX->MiniDeviceExtension))


#endif