/*
	Copyright 2003 Chris Cavey
	
	This file is part of XID.
	
	XID is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
	
	XID is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with XID; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#pragma once

// in addition to default libraries, link with setupapi.lib and hid.lib

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <setupapi.h>
#include <vector>
#include <string>

// this next file is tricky
extern "C" 
{ 
	#include "hidsdi.h" 
}


// These a buttons as PHYSICALLY representented on the controller. These are then mapping to
// VIRTUAL buttons defined by the dynamic HID report.

#define XID_A			1
#define XID_B			2
#define XID_X			3
#define XID_Y			4
#define XID_WHITE		5
#define XID_BLACK		6
#define XID_BACK		7
#define XID_START		8
#define XID_LSTICKPUSH	9
#define XID_RSTICKPUSH	10
#define XID_DPAD_U		11
#define XID_DPAD_UR		12
#define XID_DPAD_R		13
#define XID_DPAD_DR		14
#define XID_DPAD_D		15
#define XID_DPAD_DL		16
#define XID_DPAD_L		17
#define XID_DPAD_UL		18
#define XID_LTRIG		19
#define XID_RTRIG		20
#define XID_LEFTSTICK		21
#define XID_RIGHTSTICK		22

#define FLAG_INVERT 1

#define LASTERROR_AND_RETURN(x) {lastError = x; return -1;}

struct XIDHOTRECT
{
	SHORT x1, y1, x2, y2, xh, yh;
};

namespace XID
{
	class Controller
	{
	private:
		int lastError;
		std::string id, devDesc, pIdPrefix, symName;
		HANDLE currentHandle;
		int openHandle();
		int closeHandle();
		int getReportSizes();
		int setFeature(char *, unsigned int);
		int getFeature(char *, unsigned int);
	public:
		unsigned int inputSize, outputSize, featureSize;
		Controller(std::string idIn, std::string devDescIn, std::string pidpre, std::string symIn);
		int getLastError() { return lastError; };
		std::string deviceId();
		std::string description();
		std::string parentIdPrefix();
		std::string symbolicName();
		int enable();
		int disable();
		int mapButton(BYTE virtualButton, BYTE physicalControl, WORD threshold, XIDHOTRECT *hRect = NULL, BYTE flags = 0);
		int mapAxis(BYTE virtualAxis, BYTE physicalControl, WORD threshold, BYTE flags = 0); 
		int rumble(BYTE, BYTE);
	};

	class Configuration
	{
	private:
	public:
	};

	// this class ONLY updates data on construct
	class ConfigurationEnumerator
	{
	private:
		std::vector<Configuration *> ConfigurationList;
	public:
		// fetch info once, allow write through back registry. Flush on destructor.
		ConfigurationEnumerator();
		~ConfigurationEnumerator();

	};

	class ControllerEnumerator
	{
	private:
		std::vector<Controller *> ControllerList;
		std::vector<std::string> symNameList;
		int lastError;
		int enumerateSymbolicNames();
		std::string getParentIdPrefix(std::string rPath);
	public:
		~ControllerEnumerator();
		int getLastError() { return lastError; };
		int refreshControllerList();
		unsigned int controllerCount();
		Controller *getController(unsigned int);
		
	};
}