{$A+,B-,D+,E+,F-,I+,L+,N-,O-,R-,S-,V-}
{$M 16384,0,655360}

{This Program is based on source code from Martin Gerdes, an editor of the german "c't" magazine.}
{The article was published in c't 11/91 "Platten-Auslese - Konfiguration von AT-Bus-Platten lesen"}

PROGRAM hdd_lock;

CONST datname='hddpw.txt';

CONST HexArray:ARRAY[0..15]OF Char
='0123456789ABCDEF';

VAR
i             :Word;
ch            :Char;
x             :Integer;
k             :Integer;
j             :Integer;
tmp           :Integer;
half_len      :Integer;
datei         :Text;
drive         :Char;
by            :ARRAY[0..31]OF Byte;
command_ok    :Boolean;
user_input    :String;

ExitSave      :Pointer;

IDRecord:RECORD
rese           :ARRAY[0..26]OF Word;
CtrlModl       :ARRAY[0..39]OF Char;
rved           :ARRAY[47..255]OF Word;
END;

SECRecord:RECORD
Control         :Word;
Password        :ARRAY[0..31]OF BYTE;
reserved        :ARRAY[17..255]OF Word;
END;


FUNCTION st(s:String):String;
BEGIN
WHILE(s[Length(s)]=#0)AND(Length(s)<>0)
DO Delete(s,Length(s),1);
i := 1;
repeat
ch := s[i];
s[i] := s[i+1];
s[i+1] := ch;
inc(i,2);
until i > length(s);
st:=s;
END;

{$f+}
PROCEDURE MyExit;
BEGIN
ExitProc:=ExitSave;
Port[$1f7]:=$10;
Port[$1f6]:=$a0;
Port[$1f7]:=$10;
Port[$177]:=$10;
Port[$176]:=$a0;
Port[$177]:=$10;
END;
{$f-}


FUNCTION readcfgprim:Boolean; assembler;
asm
mov     dx,$01f7
mov     al,$0EC
out     dx,al
mov     cx,$0ffff
@again:
in      al,dx
and     al,$08
jnz     @hier
dec     cx
jnz     @again
mov     al,false
jmp     @xit

@hier:
mov     cx,$0100
mov     DI, OFFSET IDRecord
mov     dx,$01f0
push    ds
pop     es
@nochmal:
in      ax,dx
stosw
loop    @nochmal
mov     al,true
@xit:
end;

FUNCTION readcfgslave:Boolean; assembler;
asm
mov     dx,$0177
mov     al,$0EC
out     dx,al
mov     cx,$0ffff
@again:
in      al,dx
and     al,$08
jnz     @hier
dec     cx
jnz     @again
mov     al,false
jmp     @xit

@hier:
mov     cx,$0100
mov     DI, OFFSET IDRecord
mov     dx,$0170
push    ds
pop     es
@nochmal:
in      ax,dx
stosw
loop    @nochmal
mov     al,true
@xit:
end;

FUNCTION unlockprim:Boolean; assembler;
asm
mov     dx,$01f7
mov     al,$0F1
out     dx,al
mov     cx,$0ffff
@again:
in      al,dx
and     al,$08
jnz     @hier
dec     cx
jnz     @again
mov     al,false
jmp     @xit

@hier:
mov     cx,$0100
lea     SI, SECRecord
mov     dx,$01f0
push    ds
pop     es
@nochmal:
lodsw
out     dx,ax
loop    @nochmal
mov     al,true
@xit:
end;

FUNCTION unlockslave:Boolean; assembler;
asm
mov     dx,$0177
mov     al,$0F1
out     dx,al
mov     cx,$0ffff
@again:
in      al,dx
and     al,$08
jnz     @hier
dec     cx
jnz     @again
mov     al,false
jmp     @xit

@hier:
mov     cx,$0100
lea     SI, SECRecord
mov     dx,$0170
push    ds
pop     es
@nochmal:
lodsw
out     dx,ax
loop    @nochmal
mov     al,true
@xit:
end;


PROCEDURE identifyprim(DriveNum:Char);
BEGIN
FillChar(IDRecord,SizeOf(IDRecord),0);
Write(DriveNum,') ');

CASE DriveNum OF
'1':Port[$1f6]:=$a0;
'2':Port[$1f6]:=$b0;
ELSE
Exit;
END;

command_ok := readcfgprim and ((Port[$1F7] and 1) = 0);

Port[$1f6]:=$A0;

IF command_ok THEN
     BEGIN
     WITH IDRecord DO
     WriteLn(st(CtrlModl));
     END
ELSE
     WriteLn('Device not ready.');
END;

PROCEDURE identifyslave(DriveNum:Char);
BEGIN
FillChar(IDRecord,SizeOf(IDRecord),0);
Write(DriveNum,') ');

CASE DriveNum OF
'3':Port[$176]:=$a0;
'4':Port[$176]:=$b0;
ELSE
Exit;
END;

command_ok := readcfgslave and ((Port[$177] and 1) = 0);

Port[$176]:=$A0;

IF command_ok THEN
     BEGIN
     WITH IDRecord DO
     WriteLn(st(CtrlModl));
     END
ELSE
     WriteLn('Device not ready.');
END;

PROCEDURE ulprim(DriveNum:Char);

BEGIN
FillChar(SECRecord,SizeOf(SECRecord),0);
DriveNum:=Upcase(DriveNum);
WriteLn;

WITH SECRecord DO
BEGIN
 Control := 0256;
 Password[0] := by[0];
 Password[1] := by[1];
 Password[2] := by[2];
 Password[3] := by[3];
 Password[4] := by[4];
 Password[5] := by[5];
 Password[6] := by[6];
 Password[7] := by[7];
 Password[8] := by[8];
 Password[9] := by[9];
 Password[10] := by[10];
 Password[11] := by[11];
 Password[12] := by[12];
 Password[13] := by[13];
 Password[14] := by[14];
 Password[15] := by[15];
 Password[16] := by[16];
 Password[17] := by[17];
 Password[18] := by[18];
 Password[19] := by[19];
 Password[20] := by[20];
 Password[21] := by[21];
 Password[22] := by[22];
 Password[23] := by[23];
 Password[24] := by[24];
 Password[25] := by[25];
 Password[26] := by[26];
 Password[27] := by[27];
 Password[28] := by[28];
 Password[29] := by[29];
 Password[30] := by[30];
 Password[31] := by[31];
END;
CASE DriveNum OF
'1':Port[$1f6]:=$a0;
'2':Port[$1f6]:=$b0;
ELSE
Exit;
END;

command_ok := unlockprim and ((Port[$1f7] and 1) = 0);

Port[$1f6]:=$A0;
IF command_ok THEN
	WriteLn('Done')
ELSE
	WriteLn('Device is not ready.');
END;


PROCEDURE ulslave(DriveNum:Char);

BEGIN
FillChar(SECRecord,SizeOf(SECRecord),0);
DriveNum:=Upcase(DriveNum);
WriteLn;

WITH SECRecord DO
BEGIN
 Control := 0256;
 Password[0] := by[0];
 Password[1] := by[1];
 Password[2] := by[2];
 Password[3] := by[3];
 Password[4] := by[4];
 Password[5] := by[5];
 Password[6] := by[6];
 Password[7] := by[7];
 Password[8] := by[8];
 Password[9] := by[9];
 Password[10] := by[10];
 Password[11] := by[11];
 Password[12] := by[12];
 Password[13] := by[13];
 Password[14] := by[14];
 Password[15] := by[15];
 Password[16] := by[16];
 Password[17] := by[17];
 Password[18] := by[18];
 Password[19] := by[19];
 Password[20] := by[20];
 Password[21] := by[21];
 Password[22] := by[22];
 Password[23] := by[23];
 Password[24] := by[24];
 Password[25] := by[25];
 Password[26] := by[26];
 Password[27] := by[27];
 Password[28] := by[28];
 Password[29] := by[29];
 Password[30] := by[30];
 Password[31] := by[31];
END;
CASE DriveNum OF
'3':Port[$176]:=$a0;
'4':Port[$176]:=$b0;
ELSE
Exit;
END;

command_ok := unlockslave and ((Port[$177] and 1) = 0);

Port[$176]:=$A0;

IF command_ok THEN
	WriteLn('Done!')
ELSE
	WriteLn('Device is not ready.');
END;


BEGIN
ExitSave:=ExitProc;
ExitProc:= @MyExit;

WriteLn('HDD Security Set Password tool v0.91');
WriteLn('Set user password and maximum security');
WriteLn('Coded by imh0 - based on code from Martin Gerdes / c''t');
WriteLn;
identifyPrim('1');
identifyPrim('2');
identifySlave('3');
identifySlave('4');
WriteLn;
Write('Choose your HDD (1,2,3,4): ');
ReadLn(drive);
WriteLn;
Write('Enter your password: ');
ReadLn(user_input);
If (Length(user_input) Mod 2) <> 0 THEN
   user_input := user_input + '0';

for i := 1 to Length(user_input) do
  user_input[i] := UpCase(user_input[i]);

half_len := Length(user_input) DIV 2;
x := 0;
tmp := 0;
k := 0;
For j:= 1 to half_len DO
BEGIN
	x := 0;
	For i:= 1 to 2 DO
	BEGIN
		k := 0;
		while (user_input[j+tmp]<>HexArray[k])
		DO k := k + 1;
		x := x + (15 * x + k);
		tmp := tmp + 1;
	END;
	tmp := tmp - 1;
by[j-1] := x;
END;
Assign(datei, datname);
ReWrite(datei);
Write(datei, user_input);
Close(datei);

if (drive < '3') THEN
BEGIN
     ulprim(drive);
END
else
BEGIN
     ulslave(drive);
END;
WriteLn;
END.