/// <summary>
/// C# XBGM# Xbox Game Manager.
/// 
/// Copyright (C) 2004  KaYa
/// 
/// 
/// This library is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// Bug fixes, suggestions and comments should be sent to xbgm@kayaweed.net
/// 
/// Change Log:
/// 
/// Revision 0.5  2005/04/12 KaYa
/// New way to handle thread
///
/// Revision 0.4  2005/01/08 KaYa
/// Add bath suppport
///
/// Revision 0.3  2004/10/25 KaYa
/// New way to handle extract iso
///
/// Revision 0.2  2004/08/14 KaYa
/// Add thread support
///
/// Revision 0.1  2004/08/10 KaYa
/// first release
///
/// </summary>

namespace Xbgm.Gui
{
using System;
using System.Threading;
using Gtk;
using Gdk;
using Xbgm.Xiso;
	
/// <summary>
/// Description of ProgressDialog.	
/// Show stat when extracting iso.
/// </summary>
public class ProgressDialog
{
	Dialog dialog;
	Label labelFilename = null;
	Label labelISOname = null;
	Label labelFileremain = null;
	Label labelIsoremain = null;
	Label labelSpeed = null;
	Label labelElapstime = null;
	ProgressBar Progress = null;
	ProgressBar ISOProgress = null;
	ProgressBar TOTISOProgress = null;
	
	// If thread cancel TODO
	public bool IsCancel = false;
	
	//	Thread 
	Thread progress_worker;
	ThreadNotify main_notify;
	
	// Time info
	private long initTime;
	private DateTime DtStartNow;

	public struct Batch
	{
		/* Batch xiso stat */
		//public double totbatchxisofiles;
		public double totbatchxisos;
		public double mytotbatchxisofiles;
		public double totbatchxisofiles;
		public double totbatchnbfiles;
		public int nbxisoentry; 
	}
	public Batch batchstruct;
	
	public struct Xiso
	{
		/* One xiso stat */
		public string xisofilename;
		public double totsizefile;
		public double totisofile;
		public double xisos;
		/* other xiso stat */
		public string ISOFileName;
		public string xboxdir;
		public string gamedir;
		public bool	  hdd;
		public struct FTP
		{
			public string		IP;
			public Int32		port;
			public string		dir;
			public string		user;
			public string		pass;
		}
		public FTP FTPiso;
	}
	public Xiso xisostruct;
	
	private ListStore GameList = null;
	private Gtk.TreeIter GameListRow;

	private XisoExtractClass2 iso = null;
	
	private Xbgm.Config config = null;
	
	/// <summary>
	/// Init Batch Xiso struct
	/// </summary>
	public void UpdateStatBatchXisos(double totxisofiles, double nbxisoentry, bool extractto)
	{
		batchstruct.totbatchxisofiles = totxisofiles;
		batchstruct.totbatchxisos = nbxisoentry;
		xisostruct.hdd = extractto;
		batchstruct.nbxisoentry = 1; //At least 1 xiso
		#if ( DEBUG )
		Console.WriteLine("- xisostruct.totbatchxisofiles" + 
	                  batchstruct.totbatchxisofiles + 
	                  "- xisostruct.totbatchxisos" + 
	                  batchstruct.totbatchxisos + 
	                  "- nbxisoentry" +
	                  batchstruct.nbxisoentry +
	                  "-batchstruct.totbatchnbfiles" +
	                  batchstruct.totbatchnbfiles);
		//Console.ReadLine();
		#endif
	}
	
	/// <summary>
	/// Init Xiso struct to extract on local
	/// </summary>
	public void UpdateXiso(string xisofile, string xboxdir, string gamedir, 
	                       double maxfiles, Int64 sizefiles, 
	                       bool extractto)
	{
		// Xiso init
		xisostruct.xisofilename = xisofile;
		xisostruct.totisofile = maxfiles;
		xisostruct.totsizefile = sizefiles;
		xisostruct.ISOFileName = System.IO.Path.GetFileName(xisofile);
		xisostruct.xboxdir = xboxdir;
		xisostruct.gamedir = gamedir;
		xisostruct.hdd = extractto;
		iso.Nbfiles = (int)maxfiles;
		iso.sendfile = 0;
		iso.totsendsize = 0;
		labelFilename.Text = "Preparing tranfert...";
		//Batch init
		batchstruct.totbatchxisofiles = sizefiles;
		batchstruct.totbatchnbfiles = maxfiles;
		batchstruct.totbatchxisos = 1; // Only 1 xiso for local extract
		batchstruct.nbxisoentry = 1; // At least 1 xiso
	}
	
	/// <summary>
	/// Select first or next xiso in batch
	/// </summary>
	public void SelectXisoInBatchXisos(bool next)
	{
		if (next != true) {
			if(GameList.GetIterFirst(out GameListRow)) {
			xisostruct.xisofilename = (string)GameList.GetValue(GameListRow, 8);
			xisostruct.totsizefile = Convert.ToDouble((string)GameList.GetValue(GameListRow, 9));
			xisostruct.ISOFileName = System.IO.Path.GetFileName((string)GameList.GetValue(GameListRow, 8));
			if (GameList.GetValue(GameListRow, 5).ToString().EndsWith("/") == false)
				xisostruct.xboxdir = (string)GameList.GetValue(GameListRow, 5) + "/";
			else
				xisostruct.xboxdir = (string)GameList.GetValue(GameListRow, 5);
			xisostruct.gamedir = (string)GameList.GetValue(GameListRow, 2);
			iso.Nbfiles =  (int)Convert.ToDouble((string)GameList.GetValue(GameListRow, 6));
			int Index = config.GetIndexByName((string)GameList.GetValue(GameListRow, 10));
			UpdateFTPinfo2(Index, xisostruct.xboxdir);
			iso.sendfile = 0;
			iso.totsendsize = 0;
			labelFilename.Text = "Preparing tranfert...";
			//Console.ReadLine();
			}
		} else {
			if(GameList.IterNext(ref GameListRow)) {
			xisostruct.xisofilename = (string)GameList.GetValue(GameListRow, 8);
			xisostruct.totsizefile = Convert.ToDouble((string)GameList.GetValue(GameListRow, 9));
			xisostruct.ISOFileName = System.IO.Path.GetFileName((string)GameList.GetValue(GameListRow, 8));
			if (GameList.GetValue(GameListRow, 5).ToString().EndsWith("/") == false)
				xisostruct.xboxdir = (string)GameList.GetValue(GameListRow, 5) + "/";
			else
				xisostruct.xboxdir = (string)GameList.GetValue(GameListRow, 5);
			xisostruct.gamedir = (string)GameList.GetValue(GameListRow, 2);
			iso.Nbfiles =  (int)Convert.ToDouble((string)GameList.GetValue(GameListRow, 6));
			int Index = config.GetIndexByName((string)GameList.GetValue(GameListRow, 10));
			UpdateFTPinfo2(Index, xisostruct.xboxdir);
			iso.sendfile = 0;
			iso.totsendsize = 0;
			labelFilename.Text = "Preparing tranfert for next iso...";
			//Console.ReadLine();
			}
		}
	}
	
	/// <summary>
	/// Copy FTP info
	/// </summary>
	public void UpdateFTPinfo(Xbgm.Config config, int Index, string dir)
	{
		xisostruct.FTPiso.IP = config.xboxs[Index].ip;
		xisostruct.FTPiso.port = config.xboxs[Index].port;
		xisostruct.FTPiso.dir = dir;
		xisostruct.FTPiso.user = config.xboxs[Index].username;
		xisostruct.FTPiso.pass = config.xboxs[Index].password;
	}
	
	/// <summary>
	/// Copy FTP info
	/// </summary>
	public void UpdateFTPinfo2(int Index, string dir)
	{
		xisostruct.FTPiso.IP = config.xboxs[Index].ip;
		xisostruct.FTPiso.port = config.xboxs[Index].port;
		xisostruct.FTPiso.dir = dir;
		xisostruct.FTPiso.user = config.xboxs[Index].username;
		xisostruct.FTPiso.pass = config.xboxs[Index].password;
	}
	
	/// <summary>
	/// Copy Xiso info to ListStore
	/// </summary>
	public void xISOAdd(ListStore storeargs, Gtk.TreeIter iterargs)
	{
		GameList = storeargs;
		GameListRow = iterargs;
		#if ( DEBUG )
		Console.WriteLine("First iter " + (string)GameList.GetValue(GameListRow, 8) + 
                  " = " + (string)GameList.GetValue(GameListRow, 5) + " = " + 
                  (string)GameList.GetValue(GameListRow, 2) + " = " + 
                  (string)GameList.GetValue(GameListRow, 6) + " = " + 
                  (string)GameList.GetValue(GameListRow, 9) + " = " +
                  (string)GameList.GetValue(GameListRow, 10));
		#endif
		batchstruct.totbatchnbfiles = Convert.ToDouble(GameList.GetValue(GameListRow, 6));
		while (GameList.IterNext(ref GameListRow))
		{
			#if ( DEBUG )
			Console.WriteLine("Second iter " + (string)GameList.GetValue(GameListRow, 8) + 
		          " = " + (string)GameList.GetValue(GameListRow, 5) + " = " + 
		          (string)GameList.GetValue(GameListRow, 2) + " = " + 
		          (string)GameList.GetValue(GameListRow, 6) + " = " + 
		          (string)GameList.GetValue(GameListRow, 9) + " = " +
		          (string)GameList.GetValue(GameListRow, 10));
			#endif
			batchstruct.totbatchnbfiles += Convert.ToDouble(GameList.GetValue(GameListRow, 6));
		}
    }
 
	public ProgressDialog(Xbgm.Config config)
	{
		this.config = config;
		dialog = new Dialog ();
		dialog.Title = "Progress";
		dialog.Modal = true;
		dialog.DestroyWithParent = true;
		dialog.TypeHint = WindowTypeHint.Dialog;
		dialog.WindowPosition = WindowPosition.Center;
		dialog.Decorated = true;
		dialog.BorderWidth = 3;
		dialog.VBox.BorderWidth = 5;
		dialog.HasSeparator = false;
		dialog.Icon = new Pixbuf(null, "xbgmicon.png");
		
		Frame frame = new Frame (" xISO Progress ");
		
		VBox vbox = new VBox (false, 2);
		
		HBox hbox = new HBox (false, 2);
		hbox.BorderWidth = 5;
		
		vbox.PackStart (hbox);
		
		Table table = new Table (5, 3, false);
		hbox.PackStart (table);
		table.ColumnSpacing = 4;
		table.RowSpacing = 4;
		Label label = null;

		label = new Label ("File Progress:");
		label.SetAlignment(1,1);
		table.Attach (label, 0, 1, 0, 1);
		
		Progress = new Gtk.ProgressBar();
		Progress.HeightRequest = 15;
		Progress.WidthRequest = 330;
		Progress.Fraction= 0.0;
		Progress.Text = "Waiting";
		table.Attach (Progress, 1, 2, 0, 1);

		label = new Label ("ISO Progress:");
		label.SetAlignment(1,2);
		table.Attach (label, 0, 1, 1, 2);
		ISOProgress = new Gtk.ProgressBar();
		ISOProgress.HeightRequest = 15;
		ISOProgress.WidthRequest = 330;
		ISOProgress.Fraction= 0.0;
		ISOProgress.Text = "Waiting";
		table.Attach (ISOProgress, 1, 2, 1, 2);

		label = new Label ("Total Progress:");
		label.SetAlignment(1,3);
		table.Attach (label, 0, 1, 2, 3);
		TOTISOProgress = new Gtk.ProgressBar();
		TOTISOProgress.HeightRequest = 15;
		TOTISOProgress.WidthRequest = 330;
		TOTISOProgress.Fraction= 0.0;
		TOTISOProgress.Text = "Waiting";
		table.Attach (TOTISOProgress, 1, 2, 2, 3);
		
		label = new Label ("Current ISO:");
		label.SetAlignment(1,4);
		table.Attach (label, 0, 1, 3, 4);
		labelISOname = new Label ();
		labelISOname.Text = "ISO_name";
		labelISOname.SetAlignment(0,5);
		table.Attach (labelISOname, 1, 2, 3, 4);			
		
		label = new Label ("Current File:");
		label.SetAlignment(1,5);
		table.Attach (label, 0, 1, 4, 5);
		labelFilename = new Label ();
		labelFilename.Text = "File_name";
		labelFilename.SetAlignment(0,6);
		table.Attach (labelFilename, 1, 2, 4, 5);
		
		Frame frame2 = new Frame (" Info ");
		frame2.BorderWidth = 8;

		HBox hbox2 = new HBox (false, 2);
		hbox2.BorderWidth = 3;
		
		Table table2 = new Table (3, 3, false);
		hbox2.PackStart (table2);
		table2.ColumnSpacing = 3;
		table2.RowSpacing = 3;
		
		label = new Label ("Files Remaining:");
		label.SetAlignment(1,1);
		table2.Attach (label, 0, 1, 0, 1);
		labelFileremain = new Label ();
		labelFileremain.Text = "File_remaining";
		labelFileremain.SetAlignment(0,2);
		table2.Attach (labelFileremain, 1, 2, 0, 1);

		label = new Label ("ISOs Remaining:");
		label.SetAlignment(1,2);
		table2.Attach (label, 0, 1, 1, 2);
		labelIsoremain = new Label ();
		labelIsoremain.Text = "Iso_remaining";
		labelIsoremain.SetAlignment(0,3);
		table2.Attach (labelIsoremain, 1, 2, 1, 2);
		
		Table table3 = new Table (3, 3, false);
		hbox2.PackStart (table3);
		table3.ColumnSpacing = 3;
		table3.RowSpacing = 3;
		
		label = new Label ("Average speed:");
		label.SetAlignment(1,1);
		table3.Attach (label, 0, 1, 0, 1);
		labelSpeed = new Label ();
		labelSpeed.Text = "Average_speed";
		labelSpeed.SetAlignment(0,2);
		table3.Attach (labelSpeed, 1, 2, 0, 1);

		label = new Label ("Elapsed time:");
		label.SetAlignment(1,2);
		table3.Attach (label, 0, 1, 1, 2);
		labelElapstime = new Label ();
		labelElapstime.Text = "elapsed_time";
		labelElapstime.SetAlignment(0,3);
		table3.Attach (labelElapstime, 1, 2, 1, 2);
		
		frame2.Add (hbox2);
		
		vbox.PackStart (frame2);
		
		frame.Add (vbox);

		dialog.VBox.PackStart (frame, true, true, 0);		
				
		Button button = null;
		button = new Button (Stock.Cancel);
		button.Clicked += new EventHandler (Dialog_Cancel);
		dialog.ActionArea.PackStart (button, true, true, 0);

		initTime = DateTime.Now.Ticks;
		DtStartNow = DateTime.Now;
		dialog.ShowAll ();
		
		//Init xisothread class
		iso = new XisoExtractClass2();
		// Declare Event to update the GUI
		iso.EventUpdated += new EventHandler (EventXisoThread);
		//init isoinfo struct
		xisostruct = new Xiso();	
		//init batchinfo struct
		batchstruct = new Batch();
	}
 
	/// <summary>
	/// Event received from xisothread2.	
	/// WakeUp Main thread.
	/// </summary>
	void EventXisoThread (object sender, EventArgs args)
	{
		main_notify.WakeupMain();
	}
	
	/// <summary>
	/// Update GUI from the main thread.
	/// </summary>
	void UpdateProgressBarThread ()
	{
		// ISO Name
		labelISOname.Text = xisostruct.ISOFileName;
		
		try
		{
			// Current file name label
			if (iso.currentfile != null)
				labelFilename.Text = iso.currentfile;
		
			// nb Iso remaining
			labelIsoremain.Text = (batchstruct.totbatchxisos - batchstruct.nbxisoentry).ToString();
					
			// Current file progress bar & nb Iso File  remaining
			if (iso.currentfile != null)
			{
				// Update File Remaining
				labelFileremain.Text = (batchstruct.totbatchnbfiles - iso.sendfile).ToString();
				// Update file progress bar
				Progress.Fraction = (iso.sendsize / iso.totsendsize);
				Progress.Text = String.Format ("{0}", (iso.sendsize/iso.totsendsize).ToString("#%"));
				labelSpeed.Text = String.Format("{0}", (10000000/1024 * iso.sendsizefile/(DateTime.Now.Ticks - initTime)).ToString(".##")) + " kb/s";

				TimeSpan interval = (DtStartNow - DateTime.Now).Duration();
				labelElapstime.Text = String.Format("{0}:{1:00}:{2:00}", interval.Hours, interval.Minutes, interval.Seconds);
			}
			else
				Progress.Text = String.Format ("Preparing tranfert...");
			
			// Update Iso progress bar
			ISOProgress.Fraction = (iso.sendsizefile/xisostruct.totsizefile);
			ISOProgress.Text = String.Format ("{0}", (iso.sendsizefile/xisostruct.totsizefile).ToString("#.#%"));
			
			// Update total xIso progress bar
			TOTISOProgress.Fraction = (iso.Batchsendsizefile/batchstruct.totbatchxisofiles);
			TOTISOProgress.Text = String.Format ("{0}", (iso.Batchsendsizefile/batchstruct.totbatchxisofiles).ToString("#.#%"));
			
			// Update Title
			string mode = "";
			if (xisostruct.hdd == true) {
				mode = "Local";
			} else {
				if (iso.actionftp == true)
					mode = "BOOST MODE FTP";
				else
					mode = "FTP";
			}
			dialog.Title = String.Format ("Progress [{0}] [{1}/{2}]     {3}",
			                              (iso.Batchsendsizefile/batchstruct.totbatchxisofiles).ToString("#.#%"),
			                           	batchstruct.nbxisoentry,
			                            batchstruct.totbatchxisos, mode);
			
			#if (DEBUG)
				Console.WriteLine("\n-----------\nmytotbatchxisofiles==>" + iso.Batchsendsizefile + 
			                  "\niso.sendsizefile==>" + iso.sendsizefile + 
			                  "\n%==>" +  (iso.sendsizefile/xisostruct.totsizefile) +
			                  "\nTot %==>" + (iso.Batchsendsizefile/batchstruct.totbatchxisofiles) +
			                  "\n-----------\n");
			#endif
		}
		// Catching the abort button side effects.
		catch (Exception e)
		{
			#if (DEBUG)
				Console.WriteLine("Exception: (In ProgressDialog::UpdateProgressBarThread):\n" + e.Message +
					"\nSilently ignoring and killing the dialog.");
			#endif
			this.Close();
		}
	}
	
	void Dialog_Cancel (object o, EventArgs args) 
	{
		iso.docontinue = false;
		IsCancel = true;
		dialog.Hide ();
	}

	public void Run ()
	{
		ThreadStart tstart = new ThreadStart (progress_Thread);
		progress_worker = new Thread (tstart);
		progress_worker.Start ();
		main_notify = new Gtk.ThreadNotify (new Gtk.ReadyEvent (UpdateProgressBarThread));
		dialog.Run();
	}
	
	public void Close()
	{
		try
		{	
			dialog.Hide();
			config = null;
			iso = null;
			GameList = null;
			System.GC.Collect();
		}	
		catch (System.Exception e)
		{
			#if (DEBUG)
				Console.WriteLine("Exception (In ProgressDialog::Close):\n" + e.Message);
			#endif
			dialog.Hide();
		}
	}
	
	/// <summary>
	/// Execute thread.	
	/// lauch extractxiso
	/// </summary>	
	void progress_Thread()
	{
		try
		{
			if (xisostruct.hdd == true)
				iso.hdd = true;
			//Console.WriteLine(xisostruct.xisofilename + "=" + xisostruct.xboxdir + "=" + xisostruct.gamedir + "=" + xisostruct.FTPiso.IP);
			iso.DoBackgroundWork(xisostruct.xisofilename, xisostruct.xboxdir,
				               xisostruct.gamedir, 
				               xisostruct.FTPiso.IP, xisostruct.FTPiso.port, 
					           xisostruct.FTPiso.user, xisostruct.FTPiso.pass, 
					           xisostruct.FTPiso.dir);
			batchstruct.totbatchnbfiles -= iso.Nbfiles;
			for (int i = 1; i < (int)batchstruct.totbatchxisos; i++)
			{
				SelectXisoInBatchXisos(true);
				batchstruct.nbxisoentry++;
				//Console.WriteLine(xisostruct.xisofilename + "=" + xisostruct.xboxdir + "=" + xisostruct.gamedir + "=" + xisostruct.FTPiso.IP);
				//Console.WriteLine("Pour i:" + i + " batchstruct.totbatchxisos" + batchstruct.totbatchxisos );
				iso.DoBackgroundWork(xisostruct.xisofilename, xisostruct.xboxdir,
			               xisostruct.gamedir, 
			               xisostruct.FTPiso.IP, xisostruct.FTPiso.port, 
				           xisostruct.FTPiso.user, xisostruct.FTPiso.pass, 
				           xisostruct.FTPiso.dir);
				//iso.Batchsendsizefile += iso.BatchxISO;
				batchstruct.totbatchnbfiles -= iso.Nbfiles;
			}

			// Kill the thread because we are done
			progress_worker.Abort();
			dialog.Hide ();	
			#if (DEBUG)
			Console.WriteLine("End progress_Thread");
			#endif
		}
		// Catching the abort button side effects.
		catch (System.Exception e)
		{
			#if (DEBUG)
				Console.WriteLine("Exception (In ProgressDialog::progress_Thread):\n" + e.Message);
			#endif
			// Kill the thread
			progress_worker.Abort();
			dialog.Hide();
			throw e;
		}
	}
}
}
