/*
 * Decompiled with CFR 0.152.
 */
package com.superhac.JXBStreamer.Gui;

import com.superhac.JXBStreamer.Gui.DirFilter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class FileTreeModel
implements TreeModel,
Serializable,
Cloneable {
    static final long serialVersionUID = 45344434L;
    protected EventListenerList listeners;
    private static final Object LEAF = new Serializable(){
        static final long serialVersionUID = 4543322534L;
    };
    private Map map;
    private File root;
    static /* synthetic */ Class class$0;

    public FileTreeModel(File root) throws NullPointerException {
        this.root = root;
        if (!root.isDirectory()) {
            this.map.put(root, LEAF);
        }
        this.listeners = new EventListenerList();
        this.map = new HashMap();
    }

    public Object getRoot() {
        return this.root;
    }

    public boolean isLeaf(Object node) {
        return this.map.get(node) == LEAF;
    }

    public int getChildCount(Object node) {
        List children = this.children(node);
        if (children == null) {
            return 0;
        }
        return children.size();
    }

    public Object getChild(Object parent, int index) {
        return this.children(parent).get(index);
    }

    public int getIndexOfChild(Object parent, Object child) {
        return this.children(parent).indexOf(child);
    }

    protected List children(Object node) {
        File f = (File)node;
        Object value = this.map.get(f);
        if (value == LEAF) {
            return null;
        }
        ArrayList<File> children = (ArrayList<File>)value;
        if (children == null) {
            File[] c = f.listFiles(new DirFilter());
            if (c != null) {
                children = new ArrayList(c.length);
                int len = c.length;
                int i = 0;
                while (i < len) {
                    children.add(c[i]);
                    if (!c[i].isDirectory()) {
                        this.map.put(c[i], LEAF);
                    }
                    ++i;
                }
            } else {
                children = new ArrayList<File>(0);
            }
            this.map.put(f, children);
        }
        return children;
    }

    public void valueForPathChanged(TreePath path, Object value) {
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(TreeModelListener.class, l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(TreeModelListener.class, l);
    }

    public Object clone() {
        try {
            FileTreeModel clone = (FileTreeModel)super.clone();
            clone.listeners = new EventListenerList();
            clone.map = new HashMap(this.map);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public static void main(String[] args) {
        File root = new File("/");
        if (!root.exists()) {
            System.err.println(root + ": No such file or directory");
            System.exit(2);
        }
        JTree tree = new JTree(new FileTreeModel(root));
        JFrame f = new JFrame(root.toString());
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.getContentPane().add(new JScrollPane(tree));
        f.pack();
        f.setVisible(true);
    }
}

