/*
 * Decompiled with CFR 0.152.
 */
package com.superhac.JXBStreamer.Gui;

import com.superhac.JXBStreamer.Core.ConnectedClientStatus;
import com.superhac.JXBStreamer.Core.ServerStatus;
import com.superhac.JXBStreamer.Core.XBMSPServer;
import com.superhac.JXBStreamer.Gui.RemindTask;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.table.AbstractTableModel;

public class ConnectionStatusTabMod
extends AbstractTableModel {
    static final long serialVersionUID = 4534534L;
    ArrayList<ConnectedClientStatus> clients;
    XBMSPServer server;
    Timer timer;
    public String[] colNames = new String[]{"IP", "LastCommand", "Dir Handles", "File Handles", "Transfer Rate", "Client Version"};

    public ConnectionStatusTabMod(XBMSPServer server) {
        this.server = server;
        ServerStatus ss = server.getServerStatus();
        this.clients = ss.getClients();
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate((TimerTask)new RemindTask(this), 0L, 1000L);
    }

    public String getColumnName(int col) {
        return this.colNames[col].toString();
    }

    public int getRowCount() {
        return this.clients.size();
    }

    public int getColumnCount() {
        return this.colNames.length;
    }

    public Object getValueAt(int row, int col) {
        ConnectedClientStatus client = this.clients.get(row);
        switch (col) {
            case 0: {
                return client.getSourceIP();
            }
            case 1: {
                return client.getLastClientCommand();
            }
            case 2: {
                return client.getOpenDirectoryHandlers();
            }
            case 3: {
                return client.getOpenFileHandlers();
            }
            case 4: {
                long bytes = client.getTransferedBytesSec();
                if (bytes != 0L) {
                    return String.valueOf(bytes / 1000L) + "/KBps";
                }
                return "0 KBps";
            }
            case 5: {
                return client.getClientVersion();
            }
        }
        return "";
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void update() {
        ServerStatus ss = this.server.getServerStatus();
        this.clients = ss.getClients();
        this.fireTableDataChanged();
    }
}

