/*
 * Decompiled with CFR 0.152.
 */
package com.superhac.JXBStreamer.Gui;

import com.superhac.JXBStreamer.Core.Debug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.OutputStream;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class DebugWindow {
    private JFrame jFrame = null;
    private JPanel jContentPane = null;
    private JTextArea jTextArea = null;
    private JScrollPane jScrollPane = null;
    private Logger logger;
    private WindowHandler st = new WindowHandler();

    public DebugWindow() {
        Debug.debug = true;
        this.logger = Debug.getLogger();
        this.logger.setUseParentHandlers(false);
    }

    public JFrame getJFrame() {
        if (this.jFrame == null) {
            this.jFrame = new JFrame();
            this.jFrame.setSize(new Dimension(613, 430));
            this.jFrame.setTitle("Debug");
            this.jFrame.setMinimumSize(new Dimension(600, 400));
            this.jFrame.setDefaultCloseOperation(0);
            this.jFrame.setContentPane(this.getJContentPane());
            this.jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    Debug.debug = false;
                    DebugWindow.this.logger.removeHandler(DebugWindow.this.st);
                    DebugWindow.this.jFrame.dispose();
                }
            });
        }
        return this.jFrame;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 0));
            this.jContentPane.add((Component)this.getJScrollPane(), null);
        }
        return this.jContentPane;
    }

    private JTextArea getJTextArea() {
        if (this.jTextArea == null) {
            this.jTextArea = new JTextArea();
            this.jTextArea.setPreferredSize(new Dimension(600, 400));
            this.jTextArea = this.st.getJTextArea();
            this.logger.addHandler(this.st);
        }
        return this.jTextArea;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTextArea());
        }
        return this.jScrollPane;
    }

    class WindowHandler
    extends StreamHandler {
        final JTextArea output = new JTextArea();

        public WindowHandler() {
            this.setOutputStream(new OutputStream(this){
                final /* synthetic */ WindowHandler this$1;
                {
                    this.this$1 = windowHandler;
                }

                public void write(int b) {
                }

                public void write(byte[] b, int off, int len) {
                    this.this$1.output.append(new String(b, off, len));
                }
            });
        }

        public JTextArea getJTextArea() {
            return this.output;
        }

        public void publish(LogRecord record) {
            super.publish(record);
            this.flush();
        }
    }
}

