/*
 * Decompiled with CFR 0.152.
 */
package com.superhac.JXBStreamer.Core;

import com.superhac.JXBStreamer.Core.CheckForClientTimeoutsTask;
import com.superhac.JXBStreamer.Core.ConnectedClientStatus;
import com.superhac.JXBStreamer.Core.Debug;
import com.superhac.JXBStreamer.Core.ServerStatus;
import com.superhac.JXBStreamer.Core.XBMSPDiscoverServer;
import com.superhac.JXBStreamer.Core.XBMSPServerMessageHandler;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XBMSPServer
implements Runnable {
    private int port = 1400;
    private ArrayList<File> virtualRoot;
    private boolean autoDiscoveryEnabled = true;
    private boolean startServer = false;
    private boolean stopServer = false;
    private boolean serverRunning = false;
    private Selector selector;
    private XBMSPDiscoverServer discoveryServer;
    private ArrayList<XBMSPServerMessageHandler> smhList = new ArrayList();
    private static Logger logger;
    private Timer timer;
    private int maximumClientIdleTime = 1800;

    public XBMSPServer() {
        logger = Debug.getLogger();
        this.discoveryServer = new XBMSPDiscoverServer(this.port);
        XBMSPServer runnable = this;
        Thread thread = new Thread(runnable);
        thread.start();
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate((TimerTask)new CheckForClientTimeoutsTask(this), 0L, 5000L);
    }

    @Override
    public void run() {
        while (true) {
            if (this.startServer) {
                if (this.autoDiscoveryEnabled) {
                    this.discoveryServer.startServer();
                }
                this.serverListeningLoop();
            }
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverListeningLoop() {
        try {
            this.selector = Selector.open();
            ServerSocketChannel ssc = ServerSocketChannel.open();
            ssc.configureBlocking(false);
            ServerSocket ss = ssc.socket();
            ss.bind(new InetSocketAddress(this.port));
            SelectionKey key = ssc.register(this.selector, 16);
            ByteBuffer buffer = ByteBuffer.allocate(2048);
            this.serverRunning = true;
            while (!this.stopServer) {
                if (Debug.debug) {
                    logger.info("Waiting for packet...");
                }
                this.selector.select();
                Set<SelectionKey> skeys = this.selector.selectedKeys();
                Iterator<SelectionKey> it = skeys.iterator();
                while (it.hasNext()) {
                    XBMSPServer xBMSPServer;
                    SelectionKey rsk = it.next();
                    if ((rsk.readyOps() & 0x10) == 16) {
                        Socket socket = ss.accept();
                        SocketChannel sc = socket.getChannel();
                        sc.configureBlocking(false);
                        sc.register(this.selector, 1);
                        XBMSPServerMessageHandler smh = new XBMSPServerMessageHandler(sc, this.virtualRoot);
                        xBMSPServer = this;
                        synchronized (xBMSPServer) {
                            this.smhList.add(smh);
                        }
                        String version = "XBMSP-1.0 1.0 JXBStreamer Media Server 1.0\n";
                        ByteBuffer buf = ByteBuffer.wrap(version.getBytes("US-ASCII"));
                        sc.write(buf);
                        if (Debug.debug) {
                            logger.info("New connection created..");
                        }
                        it.remove();
                        continue;
                    }
                    if ((rsk.readyOps() & 1) != 1) continue;
                    SocketChannel sc = (SocketChannel)rsk.channel();
                    it.remove();
                    int i = 0;
                    while (i < this.smhList.size()) {
                        if (sc.equals(this.smhList.get(i).getSocketChannel())) {
                            buffer.clear();
                            int numBytesRead = sc.read(buffer);
                            if (numBytesRead == -1) {
                                if (Debug.debug) {
                                    logger.info("Client Disconnected");
                                }
                                xBMSPServer = this;
                                synchronized (xBMSPServer) {
                                    this.smhList.remove(i);
                                }
                                sc.close();
                            } else {
                                buffer.flip();
                                this.smhList.get(i).IncommingMessage(buffer);
                            }
                        }
                        ++i;
                    }
                }
            }
            key.selector().close();
            ssc.close();
            XBMSPServer xBMSPServer = this;
            synchronized (xBMSPServer) {
                this.smhList.removeAll(this.smhList);
            }
            this.serverRunning = false;
            this.stopServer = false;
            this.startServer = false;
        }
        catch (IOException e) {
            System.out.println("ERROR: " + e);
        }
    }

    public ServerStatus getServerStatus() {
        ArrayList<ConnectedClientStatus> clients = new ArrayList<ConnectedClientStatus>();
        for (XBMSPServerMessageHandler smh : this.smhList) {
            clients.add(smh.getStatus());
        }
        return new ServerStatus(this.serverRunning, clients);
    }

    public boolean isServerRunning() {
        return this.serverRunning;
    }

    public void stopServer() {
        if (this.autoDiscoveryEnabled) {
            this.discoveryServer.stopServer();
        }
        this.stopServer = true;
        this.selector.wakeup();
    }

    public void startServer() {
        this.startServer = true;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        if (this.serverRunning) {
            this.stopServer();
            this.port = port;
            while (this.serverRunning) {
            }
            this.startServer();
        } else {
            this.port = port;
        }
    }

    public boolean isAutoDiscoveryEnabled() {
        return this.autoDiscoveryEnabled;
    }

    public void setAutoDiscoveryEnabled(boolean autoDiscoveryEnabled) {
        this.autoDiscoveryEnabled = autoDiscoveryEnabled;
    }

    public void setVirtualRoot(ArrayList<File> virtualRoot) {
        this.virtualRoot = virtualRoot;
    }

    protected ArrayList<XBMSPServerMessageHandler> getServerMessageHandlers() {
        return this.smhList;
    }

    protected int getMaximumClientIdleTime() {
        return this.maximumClientIdleTime;
    }

    protected void setMaximumClientIdleTime(int maximumClientIdleTime) {
        this.maximumClientIdleTime = maximumClientIdleTime;
    }
}

