/*
 * Decompiled with CFR 0.152.
 */
package com.superhac.JXBStreamer.Core;

import com.superhac.JXBStreamer.Core.Debug;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;

public class XBMSPEncoderDecoder {
    protected static final String SERVER_VERSION = "XBMSP-1.0 1.0 JXBStreamer Media Server 1.0\n";
    protected static final byte XBMSP_PACKET_NULL = 10;
    protected static final byte XBMSP_PACKET_SETCWD = 11;
    protected static final byte XBMSP_PACKET_FILELIST_OPEN = 12;
    protected static final byte XBMSP_PACKET_FILELIST_READ = 13;
    protected static final byte XBMSP_PACKET_FILE_INFO = 14;
    protected static final byte XBMSP_PACKET_FILE_OPEN = 15;
    protected static final byte XBMSP_PACKET_FILE_READ = 16;
    protected static final byte XBMSP_PACKET_FILE_SEEK = 17;
    protected static final byte XBMSP_PACKET_CLOSE = 18;
    protected static final byte XBMSP_PACKET_CLOSE_ALL = 19;
    protected static final byte XBMSP_PACKET_SET_CONFIGURATION_OPTION = 20;
    protected static final byte XBMSP_PACKET_AUTHENTICATION_INIT = 21;
    protected static final byte XBMSP_PACKET_AUTHENTICATE = 22;
    protected static final byte XBMSP_PACKET_UPCWD = 23;
    protected static final byte XBMSP_PACKET_OK = 1;
    protected static final byte XBMSP_PACKET_ERROR = 2;
    protected static final byte XBMSP_PACKET_HANDLE = 3;
    protected static final byte XBMSP_PACKET_FILE_DATA = 4;
    protected static final byte XBMSP_PACKET_FILE_CONTENTS = 5;
    protected static final byte XBMSP_PACKET_AUTHENTICATION_CONTINUE = 6;
    protected static final byte XBMSP_PACKET_SERVER_DISCOVERY_QUERY = 90;
    protected static final byte XBMSP_PACKET_SERVER_DISCOVERY_REPLY = 91;
    protected static final byte XBMSP_ERROR_OK = 0;
    protected static final byte XBMSP_ERROR_FAILURE = 1;
    protected static final byte XBMSP_ERROR_UNSUPPORTED = 2;
    protected static final byte XBMSP_ERROR_NO_SUCH_FILE = 3;
    protected static final byte XBMSP_ERROR_INVALID_FILE = 4;
    protected static final byte XBMSP_ERROR_INVALID_HANDLE = 5;
    protected static final byte XBMSP_ERROR_OPEN_FAILED = 6;
    protected static final byte XBMSP_ERROR_TOO_MANY_OPEN_FILES = 7;
    protected static final byte XBMSP_ERROR_TOO_LONG_READ = 8;
    protected static final byte XBMSP_ERROR_ILLEGAL_SEEK = 9;
    protected static final byte XBMSP_ERROR_OPTION_IS_READ_ONLY = 10;
    protected static final byte XBMSP_ERROR_INVALID_OPTION_VALUE = 11;
    protected static final byte XBMSP_ERROR_AUTHENTICATION_NEEDED = 12;
    protected static final byte XBMSP_ERROR_AUTHENTICATION_FAILED = 13;
    protected static final byte XBMSP_FILE_SEEK_TYPE_FWDFROMBEG = 0;
    protected static final byte XBMSP_FILE_SEEK_TYPE_BCKFROMEND = 1;
    protected static final byte XBMSP_FILE_SEEK_TYPE_FWDFROMCUR = 2;
    protected static final byte XBMSP_FILE_SEEK_TYPE_BCKFROMCUR = 3;
    private int msgLen;
    private byte type;
    private int id;
    private ByteBuffer payload;
    private ByteBuffer packet;
    private String payloadString;
    private String payloadString2;
    private int payloadInt;
    private int payloadInt2;
    private long payloadInt64;
    private byte payloadByte;
    private byte[] payloadData;
    private int headerSize = 5;
    private static Logger logger;

    protected XBMSPEncoderDecoder() {
        logger = Debug.getLogger();
    }

    protected ByteBuffer getPacket() {
        if (Debug.debug) {
            logger.info("Packing packet for transmission..");
        }
        if (this.payload != null) {
            this.payload.flip();
            this.msgLen = this.headerSize + this.payload.remaining();
        } else {
            this.msgLen = this.headerSize;
        }
        this.packet = ByteBuffer.allocate(this.msgLen + 4);
        this.packet.putInt(this.msgLen);
        this.packet.put(this.type);
        this.packet.putInt(this.id);
        if (this.payload != null) {
            this.packet.put(this.payload);
        }
        this.packet.flip();
        return this.packet;
    }

    private int getId() {
        return this.id;
    }

    private void setId(int id) {
        this.id = id;
    }

    private void setMsgLen(int msgLen) {
        this.msgLen = msgLen;
    }

    protected byte getType() {
        return this.type;
    }

    private void setType(byte type) {
        this.type = type;
    }

    protected void decodepacket(ByteBuffer buff) {
        if (Debug.debug) {
            logger.info("Decoding packet.. Socket Buffer size: " + buff.remaining());
        }
        this.msgLen = buff.getInt();
        this.type = buff.get();
        this.id = buff.getInt();
        if (this.msgLen == this.headerSize) {
            return;
        }
        if (Debug.debug) {
            logger.info("Decoding packet.. Socket Buffer size after XBMSP header: " + buff.remaining());
        }
        this.payload = ByteBuffer.allocate(this.msgLen);
        while (buff.hasRemaining()) {
            this.payload.put(buff.get());
        }
        this.payload.flip();
        switch (this.type) {
            case 11: {
                if (Debug.debug) {
                    logger.info("<XBMSP_PACKET_SETCWD Decoded>");
                }
                this.payloadString = this.decodePayloadString();
                break;
            }
            case 23: {
                if (Debug.debug) {
                    logger.info("<XBMSP_PACKET_UPCWD>");
                }
                this.payloadInt = this.decodePayloadInt();
                break;
            }
            case 13: {
                if (Debug.debug) {
                    logger.info("<XBMSP_PACKET_FILELIST_READ>");
                }
                this.payloadInt = this.decodePayloadInt();
                break;
            }
            case 14: {
                if (Debug.debug) {
                    logger.info("<XBMSP_PACKET_FILE_INFO>");
                }
                this.payloadString = this.decodePayloadString();
                break;
            }
            case 15: {
                if (Debug.debug) {
                    logger.info("<XBMSP_PACKET_FILE_OPEN>");
                }
                this.payloadString = this.decodePayloadString();
                break;
            }
            case 16: {
                if (Debug.debug) {
                    logger.info("<XBMSP_PACKET_FILE_READ>");
                }
                this.payloadInt = this.decodePayloadInt();
                this.payloadInt2 = this.decodePayloadInt();
                break;
            }
            case 17: {
                if (Debug.debug) {
                    logger.info("<XBMSP_PACKET_FILE_SEEK>");
                }
                this.payloadInt = this.decodePayloadInt();
                this.payloadByte = this.decodePayloadByte();
                this.payloadInt64 = this.decodePayloadInt64();
                break;
            }
            case 18: {
                if (Debug.debug) {
                    logger.info("<XBMSP_PACKET_CLOSE>");
                }
                this.payloadInt = this.decodePayloadInt();
                break;
            }
            case 20: {
                if (Debug.debug) {
                    logger.info("<XBMSP_PACKET_SET_CONFIGURATION_OPTION>");
                }
                this.payloadString = this.decodePayloadString();
                this.payloadString2 = this.decodePayloadString();
                break;
            }
            case 21: {
                if (Debug.debug) {
                    logger.info("<XBMSP_PACKET_AUTHENTICATION_INIT>");
                }
                this.payloadString = this.decodePayloadString();
                break;
            }
            case 22: {
                if (Debug.debug) {
                    logger.info("<XBMSP_PACKET_AUTHENTICATE>");
                }
                this.payloadInt = this.decodePayloadInt();
                this.payloadData = this.decodePayloadData();
                break;
            }
            default: {
                if (!Debug.debug) break;
                logger.info("Packet not identifed... Hacker? lmfao!");
            }
        }
    }

    private String decodePayloadString() {
        int stringSize = this.payload.getInt();
        if (stringSize == 0) {
            return null;
        }
        byte[] dir = new byte[stringSize];
        int i = 0;
        while (i < stringSize) {
            dir[i] = this.payload.get();
            ++i;
        }
        try {
            return new String(dir, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("ERROR: " + e);
            System.exit(1);
            return null;
        }
    }

    private int decodePayloadInt() {
        return this.payload.getInt();
    }

    private byte decodePayloadByte() {
        return this.payload.get();
    }

    private long decodePayloadInt64() {
        return this.payload.getLong();
    }

    private byte[] decodePayloadData() {
        byte[] payloadData = new byte[this.payload.remaining()];
        int size = this.payload.limit();
        int i = 0;
        while (i < size) {
            payloadData[i] = this.payload.get();
            ++i;
        }
        return payloadData;
    }

    protected XBMSPEncoderDecoder encodePacketOk() {
        if (Debug.debug) {
            logger.info("Encoded Packet Okay response.");
        }
        XBMSPEncoderDecoder outgoingPacket = new XBMSPEncoderDecoder();
        outgoingPacket.setMsgLen(this.headerSize);
        outgoingPacket.setType((byte)1);
        outgoingPacket.setId(this.getId());
        return outgoingPacket;
    }

    protected XBMSPEncoderDecoder encodePacketError(byte errorCode, String errorMessage) {
        if (Debug.debug) {
            logger.info("Encoded Packet Error response. Code:" + errorCode);
        }
        XBMSPEncoderDecoder outgoingPacket = new XBMSPEncoderDecoder();
        ByteBuffer payload = ByteBuffer.allocate(2048);
        outgoingPacket.setType((byte)2);
        outgoingPacket.setId(this.getId());
        payload.put(errorCode);
        if (errorMessage != null) {
            int stringLength = errorMessage.length();
            payload.putInt(stringLength);
            try {
                payload.put(errorMessage.getBytes("US-ASCII"));
            }
            catch (UnsupportedEncodingException e) {
                System.out.println("ERROR: " + e);
                System.exit(1);
            }
        }
        outgoingPacket.setPayload(payload);
        return outgoingPacket;
    }

    protected XBMSPEncoderDecoder encodePacketHandle(int handle) {
        if (Debug.debug) {
            logger.info("Encoded Packet Handle response.");
        }
        XBMSPEncoderDecoder outgoingPacket = new XBMSPEncoderDecoder();
        ByteBuffer payload = ByteBuffer.allocate(100);
        outgoingPacket.setType((byte)3);
        outgoingPacket.setId(this.getId());
        payload.putInt(handle);
        outgoingPacket.setPayload(payload);
        return outgoingPacket;
    }

    protected XBMSPEncoderDecoder encodePacketFileData(String name, String data) {
        if (Debug.debug) {
            logger.info("Encoded File data response. (XML Data).");
        }
        XBMSPEncoderDecoder outgoingPacket = new XBMSPEncoderDecoder();
        ByteBuffer payload = ByteBuffer.allocate(2000);
        outgoingPacket.setType((byte)4);
        outgoingPacket.setId(this.getId());
        if (name != null && data != null) {
            payload.putInt(name.length());
            byte[] bytes = name.getBytes();
            payload.put(bytes);
            payload.putInt(data.length());
            bytes = data.getBytes();
            payload.put(bytes);
        } else {
            payload.putInt(0);
            payload.putInt(0);
        }
        outgoingPacket.setPayload(payload);
        return outgoingPacket;
    }

    protected XBMSPEncoderDecoder encodePacketFileContents(ByteBuffer data) {
        if (Debug.debug) {
            logger.info("Encoded File Contents.");
        }
        XBMSPEncoderDecoder outgoingPacket = new XBMSPEncoderDecoder();
        outgoingPacket.setType((byte)5);
        outgoingPacket.setId(this.getId());
        if (data != null) {
            outgoingPacket.setPayload(data);
        } else {
            ByteBuffer payload = ByteBuffer.allocate(4);
            payload.putInt(0);
            outgoingPacket.setPayload(payload);
        }
        return outgoingPacket;
    }

    private void setPayload(ByteBuffer payload) {
        this.payload = payload;
    }

    protected byte getPayloadByte() {
        return this.payloadByte;
    }

    protected byte[] getPayloadData() {
        return this.payloadData;
    }

    protected int getPayloadInt() {
        return this.payloadInt;
    }

    protected int getPayloadInt2() {
        return this.payloadInt2;
    }

    protected long getPayloadInt64() {
        return this.payloadInt64;
    }

    protected String getPayloadString() {
        return this.payloadString;
    }

    protected String getPayloadString2() {
        return this.payloadString2;
    }
}

