/*
 * Decompiled with CFR 0.152.
 */
package com.superhac.JXBStreamer.Core;

import com.superhac.JXBStreamer.Core.ConnectedClientStatus;
import com.superhac.JXBStreamer.Core.Debug;
import com.superhac.JXBStreamer.Core.DirectoryHandlerObject;
import com.superhac.JXBStreamer.Core.FileHandlerObject;
import com.superhac.JXBStreamer.Core.XBMSPEncoderDecoder;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XBMSPServerMessageHandler {
    private File currentPath = null;
    private ArrayList<DirectoryHandlerObject> directoryHandlers = new ArrayList();
    private ArrayList<FileHandlerObject> fileHandlers = new ArrayList();
    private ArrayList<File> virtualRoot;
    private boolean atVirtualRoot = true;
    private SocketChannel sc;
    private int directoryNextHandlerCount = 0;
    private int fileNextHandlerCount = 10000;
    private boolean newConnection = true;
    private String clientVersion = "Not Set";
    private int lastClientCommand = 0;
    private static Logger logger;
    private long lastTransmissionTime;

    protected XBMSPServerMessageHandler(SocketChannel sc, ArrayList<File> virtualRoot) {
        this.sc = sc;
        this.virtualRoot = virtualRoot;
        logger = Debug.getLogger();
    }

    protected void IncommingMessage(ByteBuffer message) {
        if (message.remaining() == 0) {
            if (Debug.debug) {
                logger.info("Message is empty... Probably disconnected client.");
            }
            return;
        }
        this.lastTransmissionTime = System.currentTimeMillis();
        if (this.newConnection) {
            byte[] version = new byte[message.remaining()];
            int i = 0;
            i = 0;
            while (i < version.length) {
                version[i] = message.get();
                if (version[i] == 10) break;
                ++i;
            }
            this.clientVersion = new String(version, 0, i - 1);
            if (Debug.debug) {
                logger.info("New connection XBMSP client version packet. Client Version: " + this.clientVersion);
            }
            this.newConnection = false;
        }
        while (message.hasRemaining()) {
            XBMSPEncoderDecoder packet = new XBMSPEncoderDecoder();
            packet.decodepacket(message);
            this.handleMessage(packet);
        }
    }

    protected SocketChannel getSocketChannel() {
        return this.sc;
    }

    private void handleMessage(XBMSPEncoderDecoder decodedMessage) {
        XBMSPEncoderDecoder response = null;
        boolean error = false;
        if (Debug.debug) {
            logger.info("Routing decoded packet by type: Type: " + decodedMessage.getType());
        }
        this.lastClientCommand = decodedMessage.getType();
        switch (decodedMessage.getType()) {
            case 10: {
                response = decodedMessage.encodePacketOk();
                break;
            }
            case 11: {
                error = this.changeDir(decodedMessage.getPayloadString());
                if (error) {
                    response = decodedMessage.encodePacketError((byte)1, "Invalid Directory Change");
                    break;
                }
                response = decodedMessage.encodePacketOk();
                break;
            }
            case 23: {
                error = this.upDirectory(decodedMessage.getPayloadInt());
                if (error) {
                    response = decodedMessage.encodePacketError((byte)1, "Invalid Directory Change");
                    break;
                }
                response = decodedMessage.encodePacketOk();
                break;
            }
            case 12: {
                int handle = this.getDirectoryHandle();
                response = decodedMessage.encodePacketHandle(handle);
                break;
            }
            case 13: {
                DirectoryHandlerObject handleObject = this.getDirectoryHandle(decodedMessage.getPayloadInt());
                if (handleObject == null) {
                    response = decodedMessage.encodePacketError((byte)5, "Invalid Handle");
                    break;
                }
                String[] strings = handleObject.getNextEntry();
                response = decodedMessage.encodePacketFileData(strings[0], strings[1]);
                break;
            }
            case 14: {
                DirectoryHandlerObject dho = this.getCWDDirectoryHandler();
                if (dho != null) {
                    int index = dho.getFileIndexNumber(decodedMessage.getPayloadString());
                    if (index != -1) {
                        String[] strings = dho.getEntryDataByIndex(index);
                        response = decodedMessage.encodePacketFileData(strings[0], strings[1]);
                        break;
                    }
                    response = decodedMessage.encodePacketError((byte)3, "No such File...");
                    break;
                }
                response = decodedMessage.encodePacketError((byte)3, "No such File..");
                break;
            }
            case 15: {
                DirectoryHandlerObject dho2 = this.getCWDDirectoryHandler();
                if (dho2 != null) {
                    int index = dho2.getFileIndexNumber(decodedMessage.getPayloadString());
                    if (index == -1) {
                        response = decodedMessage.encodePacketError((byte)5, "Invalid Handle");
                        break;
                    }
                    File file = dho2.getFileByIndex(index);
                    int handle2 = this.getFileHandle(file);
                    response = decodedMessage.encodePacketHandle(handle2);
                    break;
                }
                response = decodedMessage.encodePacketError((byte)3, "No such File or Directory");
                break;
            }
            case 16: {
                FileHandlerObject fho = this.getFileHandler(decodedMessage.getPayloadInt());
                if (fho != null) {
                    response = decodedMessage.encodePacketFileContents(fho.read(decodedMessage.getPayloadInt2()));
                    break;
                }
                response = decodedMessage.encodePacketError((byte)5, "Invalid Handle");
                break;
            }
            case 17: {
                FileHandlerObject fho2 = this.getFileHandler(decodedMessage.getPayloadInt());
                if (fho2 != null) {
                    boolean error2 = fho2.seekFile(decodedMessage.getPayloadInt64(), decodedMessage.getPayloadByte());
                    if (!error2) {
                        response = decodedMessage.encodePacketOk();
                        break;
                    }
                    response = decodedMessage.encodePacketError((byte)9, "Illegal Seek!");
                    break;
                }
                response = decodedMessage.encodePacketError((byte)5, "Invalid Handle");
                break;
            }
            case 18: {
                if (this.closeHandle(decodedMessage.getPayloadInt())) {
                    response = decodedMessage.encodePacketOk();
                    break;
                }
                response = decodedMessage.encodePacketError((byte)5, "Invalid Handle");
                break;
            }
            case 19: {
                this.closeAllHandles();
                response = decodedMessage.encodePacketOk();
            }
        }
        if (response != null) {
            try {
                if (Debug.debug) {
                    logger.info("Sending response packet..");
                }
                ByteBuffer buf = response.getPacket();
                while (buf.hasRemaining()) {
                    this.sc.write(buf);
                }
            }
            catch (IOException e) {
                System.out.println("ERROR: " + e);
            }
        }
    }

    private boolean changeDir(String newDirectory) {
        boolean error = false;
        boolean matched = false;
        if (newDirectory == null) {
            if (Debug.debug) {
                logger.info("Client requested directory change of null.  Directory not changed.");
            }
            matched = true;
            return error;
        }
        if (newDirectory.startsWith("/", 0)) {
            if (Debug.debug) {
                logger.info("Client requested directory change to : <" + newDirectory + ">.");
            }
            this.atVirtualRoot = true;
            this.currentPath = null;
            return false;
        }
        if (newDirectory.startsWith("..", 0)) {
            if (Debug.debug) {
                logger.info("Client requested directory change to : <" + newDirectory + ">.");
            }
            if (this.atVirtualRoot) {
                return true;
            }
            System.out.println("Move up .. ran");
            File currentPathTemp = new File(this.currentPath.getParent());
            for (File root : this.virtualRoot) {
                File parent = new File(root.getParent());
                if (parent.getAbsolutePath().compareTo(currentPathTemp.getAbsolutePath()) == 0) {
                    this.atVirtualRoot = true;
                    this.currentPath = null;
                    break;
                }
                this.currentPath = currentPathTemp;
            }
            return false;
        }
        if (this.atVirtualRoot) {
            for (File path : this.virtualRoot) {
                if (path.getName().compareTo(newDirectory) != 0) continue;
                this.currentPath = new File(path.getAbsolutePath());
                this.atVirtualRoot = false;
                matched = true;
                break;
            }
        } else {
            String[] children = this.currentPath.list();
            int i = 0;
            while (i < children.length) {
                String newPath;
                if (children[i].compareTo(newDirectory) == 0 && new File(newPath = this.currentPath + "/" + newDirectory).isDirectory()) {
                    this.currentPath = new File(newPath);
                    this.atVirtualRoot = false;
                    if (Debug.debug) {
                        logger.info("Client requested directory change to : <" + newDirectory + ">.");
                    }
                    matched = true;
                    break;
                }
                ++i;
            }
        }
        if (!matched) {
            error = true;
        }
        if (Debug.debug) {
            logger.info("ERROR: Client requested directory change to : <" + newDirectory + ">.");
        }
        return error;
    }

    private boolean upDirectory(int count) {
        if (Debug.debug) {
            logger.info("Client requested directory change up " + count + " levels.");
        }
        boolean error = false;
        if (count == 0) {
            return false;
        }
        if (count == -1) {
            this.currentPath = null;
            this.atVirtualRoot = true;
            return false;
        }
        int i = 0;
        while (i < count) {
            if (this.atVirtualRoot) {
                return true;
            }
            File currentPathTemp = new File(this.currentPath.getParent());
            for (File root : this.virtualRoot) {
                File parent = new File(root.getParent());
                if (parent.getAbsolutePath().compareTo(currentPathTemp.getAbsolutePath()) == 0) {
                    this.atVirtualRoot = true;
                    this.currentPath = null;
                    break;
                }
                this.currentPath = currentPathTemp;
            }
            ++i;
        }
        return error;
    }

    private int getDirectoryHandle() {
        int i;
        int handle = 0;
        boolean match = false;
        if (this.atVirtualRoot) {
            i = 0;
            while (i < this.directoryHandlers.size()) {
                if (this.directoryHandlers.get(i).getPath() == null) {
                    handle = this.directoryHandlers.get(i).getHandle();
                    match = true;
                    if (Debug.debug) {
                        logger.info("Directory handler already created.. Returning the handler.");
                    }
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < this.directoryHandlers.size()) {
                if (this.directoryHandlers.get(i).getPath() != null && this.directoryHandlers.get(i).getPath().getName().compareTo(this.currentPath.getName()) == 0) {
                    handle = this.directoryHandlers.get(i).getHandle();
                    match = true;
                    if (Debug.debug) {
                        logger.info("Directory handler already created.. Returning the handler.");
                    }
                }
                ++i;
            }
        }
        if (!match) {
            if (Debug.debug) {
                logger.info("Directoy handler does not exist.. Creating one..");
            }
            if (this.atVirtualRoot) {
                DirectoryHandlerObject dirHandler = new DirectoryHandlerObject(this.directoryNextHandlerCount, this.virtualRoot);
                handle = dirHandler.getHandle();
                this.directoryHandlers.add(dirHandler);
                ++this.directoryNextHandlerCount;
            } else {
                DirectoryHandlerObject dirHandler = new DirectoryHandlerObject(this.directoryNextHandlerCount, this.currentPath);
                handle = dirHandler.getHandle();
                this.directoryHandlers.add(dirHandler);
                ++this.directoryNextHandlerCount;
            }
        }
        return handle;
    }

    private int getFileHandle(File file) {
        int handle = 0;
        boolean match = false;
        if (Debug.debug) {
            logger.info("Get File handler for <" + file.getName() + ">.");
        }
        int i = 0;
        while (i < this.fileHandlers.size()) {
            if (this.fileHandlers.get(i).getFileName().compareTo(file.getName()) == 0) {
                handle = this.fileHandlers.get(i).getHandle();
                match = true;
                if (Debug.debug) {
                    logger.info("File handler exist.. returning it.");
                }
            }
            ++i;
        }
        if (!match) {
            if (Debug.debug) {
                logger.info("File handler does not exist.. Creating one. Handler #:" + this.fileNextHandlerCount);
            }
            FileHandlerObject fileHandler = new FileHandlerObject(this.fileNextHandlerCount, file);
            handle = fileHandler.getHandle();
            this.fileHandlers.add(fileHandler);
            ++this.fileNextHandlerCount;
        }
        return handle;
    }

    private DirectoryHandlerObject getCWDDirectoryHandler() {
        if (Debug.debug) {
            logger.info("Geting CWD handler...");
        }
        this.getDirectoryHandle();
        if (this.atVirtualRoot) {
            int i = 0;
            while (i < this.directoryHandlers.size()) {
                if (this.directoryHandlers.get(i).getPath() == null) {
                    return this.directoryHandlers.get(i);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.directoryHandlers.size()) {
                if (this.directoryHandlers.get(i).getPath() != null && this.directoryHandlers.get(i).getPath().getName().compareTo(this.currentPath.getName()) == 0) {
                    return this.directoryHandlers.get(i);
                }
                ++i;
            }
        }
        if (Debug.debug) {
            logger.info("ERROR: Can't find working directory handler.  Should not happen!");
        }
        return null;
    }

    private DirectoryHandlerObject getDirectoryHandle(int handle) {
        if (Debug.debug) {
            logger.info("Client directory read for handle #: " + handle);
        }
        int i = 0;
        while (i < this.directoryHandlers.size()) {
            if (this.directoryHandlers.get(i).getHandle() == handle) {
                return this.directoryHandlers.get(i);
            }
            ++i;
        }
        return null;
    }

    private FileHandlerObject getFileHandler(int handle) {
        int i = 0;
        while (i < this.fileHandlers.size()) {
            if (this.fileHandlers.get(i).getHandle() == handle) {
                if (Debug.debug) {
                    logger.info("Client file read for handle #: " + handle + " filename:" + this.fileHandlers.get(i).getFileName());
                }
                return this.fileHandlers.get(i);
            }
            ++i;
        }
        if (Debug.debug) {
            logger.info("Client file read for handle #: " + handle + " is invalid!");
        }
        return null;
    }

    private boolean closeHandle(int handle) {
        if (Debug.debug) {
            logger.info("Client request handle #: " + handle + " to be closed.");
        }
        int i = 0;
        while (i < this.fileHandlers.size()) {
            if (this.fileHandlers.get(i).getHandle() == handle) {
                this.fileHandlers.remove(i);
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < this.directoryHandlers.size()) {
            if (this.directoryHandlers.get(i).getHandle() == handle) {
                this.directoryHandlers.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean closeAllHandles() {
        if (Debug.debug) {
            logger.info("Client requested all handles to be closed..");
        }
        this.fileHandlers.removeAll(this.fileHandlers);
        this.directoryHandlers.removeAll(this.directoryHandlers);
        return true;
    }

    public ConnectedClientStatus getStatus() {
        return new ConnectedClientStatus(this.sc.socket().getRemoteSocketAddress().toString(), this.clientVersion, this.lastClientCommand, this.fileHandlers.size(), this.directoryHandlers.size(), this.getFileTransferRates());
    }

    private long getFileTransferRates() {
        long fileTransferRate = 0L;
        for (FileHandlerObject file : this.fileHandlers) {
            fileTransferRate += file.getFileTransferRate();
        }
        return fileTransferRate;
    }

    protected long getLastTransmissionDelay() {
        long delay = (System.currentTimeMillis() - this.lastTransmissionTime) / 1000L;
        return delay;
    }
}

