#include <stdio.h>
#include <stdlib.h>
#include <hal/xbox.h>
#include <hal/fileio.h>
#include <openxdk/debug.h>
#include <SDL.h>

#define JOYSTICK_MOVEMENT_THRESHOLD 3200

void XBoxStartup()
{
	char buffer[80];
	if (SDL_Init(SDL_INIT_VIDEO | SDL_INIT_JOYSTICK) != 0)
	{
		sprintf(buffer, "Error: %s\n", SDL_GetError());
		debugPrint(buffer);
		XSleep(2000); 
		XReboot();
	}
	sprintf(buffer, "%i joysticks were found.\n\n", SDL_NumJoysticks());
	debugPrint(buffer);
	sprintf(buffer, "The names of the joysticks are:\n");
	debugPrint(buffer);
	for (int i = 0; i < SDL_NumJoysticks(); i++) 
	{
		sprintf(buffer, "    %s\n", SDL_JoystickName(i));
		debugPrint(buffer);
	}

	SDL_JoystickEventState(SDL_ENABLE);
	SDL_Joystick *joystick = SDL_JoystickOpen(0);	
	
	int done = 0;
	while (!done)
	{
		SDL_Event event;
		while(SDL_PollEvent(&event))
		{  
			debugPrint("#");
			switch(event.type)
			{  
			case SDL_KEYDOWN:
				break;
			case SDL_QUIT:
				break;
			case SDL_JOYBUTTONDOWN:
				sprintf(buffer, "Press = %d\n", event.jbutton.button);
				debugPrint(buffer);
				break;
			case SDL_JOYBUTTONUP:
				sprintf(buffer, "Release = %d\n", event.jbutton.button);
				debugPrint(buffer);
				break;
//			case SDL_JOYAXISMOTION:
//				if ((event.jaxis.value < -JOYSTICK_MOVEMENT_THRESHOLD) || (event.jaxis.value > JOYSTICK_MOVEMENT_THRESHOLD)) 
//				{
//					if( event.jaxis.axis == 0) 
//					{
//						sprintf(buffer, "left joy = %d\n", event.jaxis.value);
//						debugPrint(buffer);
//					}
//					if( event.jaxis.axis == 1) 
//					{
//						sprintf(buffer, "right joy = %d\n", event.jaxis.value);
//						debugPrint(buffer);
//					}
//				}
//				break;
			case SDL_JOYHATMOTION:  /* Handle Hat Motion */
				sprintf(buffer, "Hat = %d\n", event.jhat.value);
				debugPrint(buffer);
				break;
			}
		}
	}
	XSleep(2000);
	XReboot();
}
