#include <memory.h>
#include <sys/stat.h>
#include <sys/times.h>
#include <hal/xbox.h>
#include <hal/fileio.h>
#include <xboxkrnl/xboxkrnl.h>

#include <stdio.h>
#include <openxdk/debug.h>

void XReboot()
{
	HalReturnToFirmware(ReturnFirmwareReboot);
}

int XGetTickCount()
{
	return KeTickCount;
}

void XSleep(int milliseconds)
{
	int target = times(NULL)+milliseconds;
	while(times(NULL)<target);
}

/**
 * Launches an XBE.  Examples of xbePath might be:
 *   c:\\blah.xbe
 *   c:/foo/bar.xbe
 * If the XBE is able to be launched, this method will
 * not return.  If there is a problem, then it return.
 */
void XLaunchXBE(char *xbePath)
{
	struct stat statbuf;
	if (stat(xbePath, &statbuf) < 0)
		return;	
	
	memset((void*)LaunchDataPage, 0, 0x1000);
	
	LaunchDataPage->Header.dwLaunchDataType = 0xFFFFFFFF;
	LaunchDataPage->Header.dwTitleId = 0;
	XConvertDOSFilenameToXBOX(xbePath, LaunchDataPage->Header.szLaunchPath);
	
	// one last thing... xbePath now looks like:
	//   \Device\Harddisk0\Partition2\blah\doom.xbe
	// but it has to look like:
	//   \Device\Harddisk0\Partition2\blah;doom.xbe
	char *lastSlash = strrchr(LaunchDataPage->Header.szLaunchPath, '\\');
	if (lastSlash != NULL)
	{
		*lastSlash = ';';
		HalReturnToFirmware(ReturnFirmwareQuickReboot);
	}
	
	// if we couldn't find a trailing slash, the conversion to 
	// the xbox path mustn't have worked, so we will return
}

