#region Copyright & License
/// <summary>
/// C# XBGM# Xbox Game Manager.
///  
/// Copyright (C) 2004  KaYa
/// 
/// 
/// This library is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// Bug fixes, suggestions and comments should be sent to xbgm@kayaweed.net
/// 
/// Change Log:
/// 
/// Revision 0.1  2006/10/19 KaYa
/// first release
///
/// </summary>
#endregion

using System;
using System.IO;
using FreeImageAPI;
using System.Runtime.InteropServices;
using System.Drawing;

namespace Xbgm.Xiso
{
	public class Freeimage
	{	
		// Constructor
		public Freeimage(string bindir)
		{
			System.IO.Directory.SetCurrentDirectory(bindir);
		}
		
		public void Convert(string filename, string olddir)
		{
			#if ( DEBUG)
				Console.WriteLine("\nStart XPR 2 DDS 2 BMP Conversion!\nFile: [{0}]\nLib: [{1}]\n",
			                 filename, olddir);
			#endif
			
			FileStream  imgsrcfs  = new FileStream(filename + ".xpr",
			                        FileMode.Open, FileAccess.Read);
	       	StreamReader xprReader = new StreamReader(imgsrcfs);
	       	
	       	//Go to  header
	       	xprReader.BaseStream.Seek(0x0000, SeekOrigin.Begin);
	       	byte[] buf = new byte[4];
			xprReader.BaseStream.Read(buf, 0, buf.Length);
			string s = System.Text.Encoding.ASCII.GetString(buf, 0, buf.Length);
			if ((s.StartsWith("DDS")) == true)
			{					 
				Console.WriteLine("DDS file format\nConverting to BMP");
				xprReader.Close();
				imgsrcfs.Close();
			     // Finally convert DDS to BMP		
				int myhandle = FreeImageAPI.FreeImage.FreeImage_Load(
	                FreeImageAPI.FIF.FIF_DDS,
	                filename + ".xpr", 
	                0);

	            FreeImageAPI.FreeImage.FreeImage_Save(
	                FreeImageAPI.FIF.FIF_BMP,   
	                myhandle, filename + ".bmp",
	                0);
	 				
	            FreeImageAPI.FreeImage.FreeImage_Unload(myhandle); 
	
	            // Clean up
	            buf = null;
	            File.Delete(filename + ".xpr");
	            
	            ResizeBitmap(filename + ".bmp");
	            	
	            #if ( DEBUG)
					Console.WriteLine("Done DDS 2 BMP Conversion!\n");
				#endif
				return;
			}
			else if ((s.Equals("XPR0")) != true)
			{					 
				Console.WriteLine("not an XPR0 file format\nError possible corruption");
				return;
			}
			#if ( DEBUG)
				Console.WriteLine("XPR0 magic header");
			#endif
			
			// File Size
			buf = new byte[4];
			xprReader.BaseStream.Read(buf, 0, buf.Length);
			int Filesize = ((buf[3]<<24) | (buf[2]<<16) | (buf[1]<<8) | buf[0]);
			#if ( DEBUG)
				Console.WriteLine("Filesize ["+ Filesize + "]");
			#endif

			// Header Size
			buf = new byte[4];
			xprReader.BaseStream.Read(buf, 0, buf.Length);
			int Headersize = ((buf[3]<<24) | (buf[2]<<16) | (buf[1]<<8) | buf[0]);
			#if ( DEBUG)
				Console.WriteLine("Headersize ["+ Headersize + "]");
			#endif
			
			// dwTextureCommon
			buf = new byte[4];
			xprReader.BaseStream.Read(buf, 0, buf.Length);
			int dwTextureCommon = ((buf[3]<<24) | (buf[2]<<16) | (buf[1]<<8) | buf[0]);
			#if ( DEBUG)
				Console.WriteLine("dwTextureCommon ["+ dwTextureCommon + "]");
			#endif
			
			// dwTextureData
			buf = new byte[4];
			xprReader.BaseStream.Read(buf, 0, buf.Length);
			int dwTextureData = ((buf[3]<<24) | (buf[2]<<16) | (buf[1]<<8) | buf[0]);
			#if ( DEBUG)
				Console.WriteLine("dwTextureData ["+ dwTextureData + "]");
			#endif
			
			// dwTextureLock
			buf = new byte[4];
			xprReader.BaseStream.Read(buf, 0, buf.Length);
			int dwTextureLock = ((buf[3]<<24) | (buf[2]<<16) | (buf[1]<<8) | buf[0]);
			#if ( DEBUG)
				Console.WriteLine("dwTextureLock ["+ dwTextureLock + "]");
			#endif

			// btTextureMisc1
			buf = new byte[1];
			xprReader.BaseStream.Read(buf, 0, buf.Length);
			int btTextureMisc1 = ( buf[0]);
			#if ( DEBUG)
				Console.WriteLine("btTextureMisc1 ["+ btTextureMisc1 + "]");
			#endif
			
			// btTextureFormat 
			buf = new byte[1];
			xprReader.BaseStream.Read(buf, 0, buf.Length);
			int btTextureFormat = ( buf[0]);
			#if ( DEBUG)
				Console.WriteLine("btTextureFormat ["+ btTextureFormat + "]");
			#endif
			
			// btTextureWidth
			buf = new byte[1];
			xprReader.BaseStream.Read(buf, 0, buf.Length);
			int btTextureWidth = ( buf[0]);
			#if ( DEBUG)
				Console.WriteLine("btTextureWidth ["+ btTextureWidth + "]");
			#endif
			
			// btTextureHeight
			buf = new byte[1];
			xprReader.BaseStream.Read(buf, 0, buf.Length);
			int btTextureHeight = ( buf[0]);
			#if ( DEBUG)
				Console.WriteLine("btTextureHeight ["+ btTextureHeight + "]");
			#endif

			// btTextureMisc2
			buf = new byte[1];
			xprReader.BaseStream.Read(buf, 0, buf.Length);
			int btTextureMisc2 = ( buf[0]);
			#if ( DEBUG)
				Console.WriteLine("btTextureMisc2 ["+ btTextureMisc2 + "]");
			#endif
			
			/* dwTextureSize
			buf = new byte[4];
			xprReader.BaseStream.Read(buf, 0, buf.Length);
			int dwTextureSize = ((buf[3]<<24) | (buf[2]<<16) | (buf[1]<<8) | buf[0]);
			#if ( DEBUG)
				Console.WriteLine("dwTextureSize ["+ dwTextureSize + "]");
			#endif
			*/
			
			//Go to End of header
	       	xprReader.BaseStream.Seek(Headersize, SeekOrigin.Begin);
			buf = new byte[Filesize];
			xprReader.BaseStream.Read(buf, 0, buf.Length);
			
			FileStream imgdstfs  = new FileStream(filename + ".dds", FileMode.Create);
	       	BinaryWriter xprWriter = new BinaryWriter(imgdstfs);

	       	// Magic header
	       	char[] magic = new char[] {'D','D','S',' '};
	       	xprWriter.Write(magic, 0 , 4);
			// Size header fix
	       	xprWriter.Write((uint)124);
			// Flags
	       	xprWriter.Write((uint)528391);	       	
	       	// height
	       	xprWriter.Write((uint)128);
	       	// width
	       	xprWriter.Write((uint)128);
	       	// Pitch
	       	xprWriter.Write((uint)8192);
			// depth
	       	xprWriter.Write((uint)0);	       	
	       	//mipMapLevels
	       	xprWriter.Write((uint)0);	       	
	       	//alphaBitDepth;
	       	xprWriter.Write((uint)0);	       	
			//reserved;
	       	xprWriter.Write((uint)0);		
			//surface;
	       	xprWriter.Write((uint)0);			 
			//ckDestOverlay;
	       	xprWriter.Write((uint)0);
	       	xprWriter.Write((uint)0);
			//ckDestBlt;
	       	xprWriter.Write((uint)0);
	       	xprWriter.Write((uint)0);
			//ckSrcOverlay;
	       	xprWriter.Write((uint)0);
	       	xprWriter.Write((uint)0);
			//ckSrcBlt;
	       	xprWriter.Write((uint)0);
	       	xprWriter.Write((uint)0);		
			//format;
			xprWriter.Write((uint)32);
			xprWriter.Write((uint)4);
			char[] format = new char[] {'D','X','T','1'};
	       	xprWriter.Write(format, 0 , 4);
			//caps;
	       	xprWriter.Write((uint)0);
	       	xprWriter.Write((uint)0);
			xprWriter.Write((uint)0);
	       	xprWriter.Write((uint)0);
			//textureStage;
			xprWriter.Write((uint)0);
	       	xprWriter.Write((uint)0);
			xprWriter.Write((uint)0);
	       	xprWriter.Write((uint)0);
			xprWriter.Write((uint)0);
	       	xprWriter.Write((uint)0);
	       	// Write the data
	       	xprWriter.BaseStream.Write(buf, 0, buf.Length);
	       	
	       	xprReader.Close();
	        imgsrcfs.Close();
	        xprWriter.Close();
	        imgdstfs.Close();
	        
		     // Finally convert DDS to BMP		
			int handle = FreeImageAPI.FreeImage.FreeImage_Load(
                FreeImageAPI.FIF.FIF_DDS,
                filename + ".dds", 
                0);
                          
            FreeImageAPI.FreeImage.FreeImage_Save(
                FreeImageAPI.FIF.FIF_BMP,   
                handle, 
                filename + ".bmp", 
                0);
 				
            FreeImageAPI.FreeImage.FreeImage_Unload(handle); 

            // Clean up
            buf = null;
            format = magic = null;
            File.Delete(filename + ".xpr");
            File.Delete(filename + ".dds");
            
            ResizeBitmap(filename + ".bmp");
            
            #if ( DEBUG)
				Console.WriteLine("Done XPR 2 DDS 2 BMP Conversion!\n");
			#endif
			
			System.IO.Directory.SetCurrentDirectory(olddir);
		}

     private void ResizeBitmap(string filename)
	{
	    try 
	    {
	    	System.Drawing.Image src = System.Drawing.Image.FromFile(filename);
			System.Drawing.Image result = new Bitmap( 128, 128, System.Drawing.Imaging.PixelFormat.Format24bppRgb);
			using( Graphics g = Graphics.FromImage( (Image) result ) )
			g.DrawImage( src, 0, 0, 128, 128 );
			result.Save(filename + "1.bmp", System.Drawing.Imaging.ImageFormat.Bmp);
			result.Dispose();
			src.Dispose();
			File.Delete(filename);
			File.Move(filename + "1.bmp", filename);
		}
	    catch (Exception)  { Console.WriteLine("Error Resizing BMP!\n"); }
	}

	}
}


namespace FreeImageAPI
{
	public enum FIF
	{
		FIF_UNKNOWN = -1,
		FIF_BMP		= 0,
		FIF_ICO		= 1,
		FIF_JPEG	= 2,
		FIF_JNG		= 3,
		FIF_KOALA	= 4,
		FIF_LBM		= 5,
		FIF_IFF = FIF_LBM,
		FIF_MNG		= 6,
		FIF_PBM		= 7,
		FIF_PBMRAW	= 8,
		FIF_PCD		= 9,
		FIF_PCX		= 10,
		FIF_PGM		= 11,
		FIF_PGMRAW	= 12,
		FIF_PNG		= 13,
		FIF_PPM		= 14,
		FIF_PPMRAW	= 15,
		FIF_RAS		= 16,
		FIF_TARGA	= 17,
		FIF_TIFF	= 18,
		FIF_WBMP	= 19,
		FIF_PSD		= 20,
		FIF_CUT		= 21,
		FIF_XBM		= 22,
		FIF_XPM		= 23,
		FIF_DDS     = 24,
		FIF_GIF     = 25,
		FIF_HDR		= 26,
		FIF_FAXG3	= 27
	}

	public class FreeImage
	{
		[DllImport("FreeImage.dll")]
		public static extern int FreeImage_Load(FIF format, string filename, int flags);
		
		[DllImport("FreeImage.dll")]
		public static extern void FreeImage_Unload(int handle);
		
		[DllImport("FreeImage.dll")]
		public static extern bool FreeImage_Save(FIF format, int handle, string filename, int flags);
	}
}
