//
// translation.cs: I18N related stuff.
//
// Authors:
//	Gonzalo Paniagua Javier (gonzalo@ximian.com)
//
// (C) 2003 Ximian, Inc (http://www.ximian.com)
//
/// Change Log:
/// 
/// Revision 0.1  2005/07/09 KaYa
/// first release
/// http://svn.myrealbox.com/viewcvs/trunk/nunit-gtk/src/
/// http://galactus.ximian.com/pipermail/gtk-sharp-list/2003-May/001904.html

using System;
using System.Collections;
using System.Reflection;
using System.Resources;

namespace Xbgm.Gui
{
	public class ResMan
	{
		public static string ResourceName = "strings";
		public static Assembly Assembly = typeof (ResMan).Assembly;

		static ResourceManager rm;
		static Hashtable mangled;
		static char [] invalidChars = new Char [] {'=', ' '};

		private ResMan () {}
		
		static ResourceManager RM {
			get {
				if (rm == null)
					rm = new ResourceManager (ResourceName, Assembly);

				return rm;
			}
		}

		static string _ (string key)
		{
			return GetString (key);
		}

		static string GetMangled (string key)
		{
			if (mangled == null)
				mangled = new Hashtable ();

			if (mangled.Contains (key))
				return (string) mangled [key];

			string k = key.Replace ('=', '_');
			k = k.Replace (' ', '_');
			mangled [key] = k;
			return k;
		}
		
		public static string GetString (string key)
		{
			if (key == null)
				throw new ArgumentNullException ("key");

			if (key == "")
				throw new ArgumentException (_("Empty key"), "key");

			string k = key;
			if (k.IndexOfAny (invalidChars) != -1)
				k = GetMangled (k);

			string result = RM.GetString (k);
			if (result == null) {
				Console.Error.WriteLine (_("ResMan: Warning: no value found for '{0}'"), k);
				result = key;
			}

			return result;
		}
	}
}

