/// <summary>
/// C# XBGM# Xbox Game Manager.
///  
/// Copyright (C) 2004  KaYa
/// 
/// 
/// This library is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// Bug fixes, suggestions and comments should be sent to xbgm@kayaweed.net
/// 
/// Change Log:
/// 
/// Revision 0.1  2005/07/17 KaYa
/// first release
///
/// </summary>


namespace Xbgm.Core
{
using System;
using System.IO;
using System.Net;
using System.Net.Sockets;
using System.Collections;
using EnterpriseDT.Net.Ftp;
using RecursiveFileExplorer;

	public class Filethread
	{
		// Event send to the Main GUI
		public event EventHandler EventUpdated;
		// Standard FTP 
		private FTPClient ftp = null;
		// Data Boost mode
		private TcpClient client = null;
		private NetworkStream streamnetwork = null;
		// File from HDD
		private BinaryReader readerfile = null;
		private Config config;
		private int Index = -1;
		private string dest = null; 
		private string source = null; 
		private FileExplorer FileExplorer;
		// File/Dir list of the xiso BOOST MODE
		private ArrayList FileDirlist = new ArrayList(); 
		
		//TO update the GUI
		public double TotSize = 0;
		public double sendsize = 0;
		public double totsendsize = 0;
		public double TotSendSize = 0;
		public double size = 0;
		public int nbfile = 0;
		public int totnbfile = 0;
		public string name = null;
		
		public 	Filethread(FileExplorer FileExplorer, Xbgm.Config config, int Index, string dest, string source)
		{
			this.FileExplorer = FileExplorer;
			this.config = config;
			this.Index = Index;
			this.dest = dest;
			this.source = source;
			//Console.WriteLine("Sending to [{0}] ", dest);
			//Console.ReadLine();
		}
		
		public void FtpJob()
		{
			ftp = new FTPClient(config.xboxs[Index].ip, config.xboxs[Index].port);
			#if (DEBUG)
				ftp.DebugResponses(true);
			#endif
			ftp.Login(config.xboxs[Index].username, config.xboxs[Index].password); 
			ftp.System();
			ftp.TransferType = FTPTransferType.BINARY;
			ftp.ConnectMode = FTPConnectMode.ACTIVE;
			FileDirlist.Add("D," + dest);
			//Console.WriteLine("Root path: {0}", dest);
			string lastfullpath = null;
			string msg = null;
			Int64 Size = 0;
			int nbBOOST = 1; //because one the of the first lastfullpath directory
			foreach (FileData FileData in FileExplorer.FileList) {
				if (Size == 0)
					 lastfullpath = System.IO.Path.GetDirectoryName(FileData.FullName);
				string fullpath = System.IO.Path.GetDirectoryName(FileData.FullName);
				if (!fullpath.Equals(lastfullpath)) {
					string xboxpath = fullpath.Substring(source.Length); //.Replace("/", "\\");
					//Console.WriteLine("new Xboxpath: {0}", xboxpath);
					msg = @"D," + dest + xboxpath;			
					//Console.WriteLine(msg);
					FileDirlist.Add(msg);
					nbBOOST++;
					lastfullpath = System.IO.Path.GetDirectoryName(FileData.FullName);
				}
				/*Console.WriteLine("File: {0} Size: {1}", 
				                  FileData.Name, 
				                  FileData.Length); */
				msg = @"F," + FileData.Name + "," + FileData.Length;
				//Console.WriteLine(msg);
				FileDirlist.Add(msg);
				nbBOOST++;
				/*                 
				Console.WriteLine("File: {0} Size: {1} Dir: {2}\npath: {3}", 
				                  FileData.Name, 
				                  FileData.Length,
				                  System.IO.Path.GetDirectoryName(FileData.FullName),
				                  xboxpath);
				*/
				Size += FileData.Length;
			}
			lastfullpath = null;
			msg = null;
			
			#if ( DEBUG )
				Console.WriteLine("Count:" + nbBOOST);
				Console.WriteLine("Sending to [{0}] ", dest);
			#endif
			//Console.ReadLine();
			// Update GUI before sending ftp list
			if(this.EventUpdated != null)
				this.EventUpdated(null, null); 
			ftp.Site("BOOST SUPPORTED");
			// NbFILES + NbDIR + 1GameDIR 
			ftp.Site("BOOST START UPLOAD " + nbBOOST);
			//Console.ReadLine();
			// Create the data steam for Boost mode
			int dataport = ftp.FileList(FileDirlist);
			//Console.ReadLine();						
			client = new TcpClient(config.xboxs[Index].ip, dataport);
			streamnetwork = client.GetStream();
			
			// Init stats
			totnbfile = FileExplorer.FileList.Count;
			TotSize = Size; 
			TotSendSize = 0;
			
			foreach (FileData FileData in FileExplorer.FileList) 
			{
				// Create the destination file
				System.IO.FileStream streamfile = new System.IO.FileStream(FileData.FullName,
				                                                           FileMode.Open,FileAccess.Read);
				readerfile = new BinaryReader(streamfile);

				// Create buffer
				int chunksize = 4096;
				byte[] chunk = new byte[chunksize];
				int updateCounter = 0;
				int size = (int)FileData.Length;
				totsendsize = (int)FileData.Length;
				sendsize = 0;
				
				while(size > 0)
				{
					//Console.WriteLine("Size =[" + size +"]");
					if (size > chunksize)
					{
						size -= chunksize;
						sendsize += chunksize;
						readerfile.BaseStream.Read(chunk, 0, chunksize);
						streamnetwork.Write(chunk, 0, chunksize);
					}
					else
					{
						readerfile.BaseStream.Read(chunk, 0, size);
						streamnetwork.Write(chunk, 0, size);
						size -= size;
						sendsize += size;
					}
					updateCounter++;
					// Limit update frequency...
					// chunk = 4096b
					//   => Update every 1024*4096b = 4096kb = 4Mb 
					if( updateCounter > 1024 && this.EventUpdated != null)
					{
						updateCounter = 0;
						this.EventUpdated(null, null);
					}
				}
				sendsize = size; // File progress
				TotSendSize += totsendsize; // Total progress
				chunk = null;
				// one file done
				nbfile++;
				readerfile.Close();
				#if ( DEBUG)
					Console.WriteLine("Sending ["+ FileData.Name + "] " + nbfile + " of " + totnbfile);
				#endif
				// Update GUI after sending one file
				if(this.EventUpdated != null)
					this.EventUpdated(null, null); 
			}
			Byte[] data = new Byte[256];
			data = System.Text.Encoding.ASCII.GetBytes("QUIT");
			streamnetwork.Write(data, 0, data.Length);
			client.Close(); 
			ftp.QuitXbox();
			data = null;
			ftp = null;
			client = null;
			streamnetwork = null;
		}
		
		public void Close ()
		{
			config = null;
			FileExplorer = null;
			System.GC.Collect();		
		}
	}
}
