# Copyright 1999-2005 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /cvsroot/xbgm/xbgmsharp/gentoo/xbgmsharp-0.8.0.ebuild,v 1.2 2005/04/22 19:07:33 kayaweed Exp $
# XBGM# ebuild

DESCRIPTION="Xbox Game Manager and xISO utils"
HOMEPAGE="http://xbgm.sourceforge.net/"
SRC_URI="mirror://sourceforge/xbgm/xbgmsharp0.8_src.tar.gz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~x86"
IUSE=""

inherit mono

DEPEND=">=dev-lang/mono-1.0.6
	>=dev-dotnet/libgdiplus-1.0.6
	>=dev-dotnet/gtk-sharp-1.0.6"

RDEPEND=">=dev-lang/mono-1.0.6
	>=dev-dotnet/libgdiplus-1.0.6
	>=dev-dotnet/gtk-sharp-1.0.6"

src_unpack(){
	unpack ${A}
}

src_compile(){
	cd ${WORKDIR}/xbgmsharp/src
	make
}

src_install() {
	# Should be in Makefile
	#make DESTDIR=${D} install || die

	# But we will make it by hand	
	# Probably not the right way to do this but it sure did install and put the wrapper in the right place...
	mkdir -p ${D}/usr/share/dotnet/xbgmsharp/
	install -m 0644 -o root -g root ${WORKDIR}/xbgmsharp/src/xbgmsharp.exe ${D}/usr/share/dotnet/xbgmsharp/
	mkdir -p ${D}/usr/share/dotnet/bin/
	install -m 0755 -o root -g root ${WORKDIR}/xbgmsharp/debian/xbgmsharp.wrapper ${D}/usr/share/dotnet/bin/xbgmsharp
	mkdir -p ${D}/usr/bin/
	install -m 0755 -o root -g root ${WORKDIR}/xbgmsharp/debian/xbgmsharp.wrapper ${D}/usr/bin/xbgmsharp
	
	# If using Gentoo Private Scripts and Commands
	#dodir /usr/share/dotnet/xbgmsharp/
	
	# And last installing documentation
	cd ${WORKDIR}/xbgmsharp/	
	dodoc AUTHORS ChangeLog INSTALL NEWS README TODO
}

pkg_postinst() {
	einfo
	einfo "Thanks for using XBGM#"
	einfo "Please feedback"
	einfo
}
