/*
 * Copyright (C) 2003 Sanjay Madhavan.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package com.revasoft.shoutcast.plsdownloader;

/**
 * Lists all constants used during parsing and navigating a shoutcast.com web
 * page.
 * 
 * @author Sanjay Madhavan
 *  
 */
public interface PlsConstants {
	static final String _GENRE_ = "#genre#";
	static final String _PAGESTART_ = "#pagestart#";
	static String BANNED_TEXT = "Too many requests";
	static final String BOLDTOKEN = "<b>";
	static final String CLOSE_BRACKET = ")";
	static final String CLOSINGBRACKET = "]";
	static final String CURRENTGENRE = "CurrentGenre";
	static String DESCRIPTION_START_TOKEN = "<b>[";
	static final String DOUBLEQUOTE_AND_GT = "\">";
	static final String ENDFONT_ENDTD_TOKEN = "</font></td>";
	static String ENDPAGETOKEN = "</b></font></td>";
	static String GENRE_DOWNLOAD_PAGE =
		"http://www.shoutcast.com/directory/index.phtml?sgenre="
			+ _GENRE_
			+ "&startat="
			+ _PAGESTART_;
	static final String LASTRUN = "LastRun";
	static int MAX_FILELENGTH = 25;
	static final String OFTOKEN = "of";
	static final String OPEN_BRACKET = "(";
	static final String OPENDOUBLEQUOTE = "\"";
	static String PAGEINFOTOKEN = "&nbsp;&nbsp;&nbsp;";
	static final String PAGETOKEN = "Page";
	static final String PLS_EXTENSION = ".pls";
	static final String PROXY_ = "Proxy.";
	static final String PROXYCOUNT = "ProxyCount";
	static final String GENRE_ = "Genre.";
	static final String GENRECOUNT = "GenreCount";

	static String RANKTOKEN = "Rank</font></td>";
	static String SBIN_START = "/sbin/shoutcast-playlist.pls";
	static String SHOUTCAST_HOME = "http://www.shoutcast.com";
	  static final String SPACE = " ";
	static final String STARTPAGEINDEX = "CurrentPageIndex";
	static String TBN_EXTENSION = ".tbn";
	static String TD_END = "/td>";
	static String TD_START = "<td";

}
