/// <summary>
/// C# XBGM# Xbox Game Manager.
///  
/// Copyright (C) 2004  KaYa
/// 
/// 
/// This library is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// Bug fixes, suggestions and comments should be sent to xbgm@kayaweed.net
/// 
/// Change Log:
/// 
/// Revision 0.1  2004/08/01 KaYa
/// first release
///
/// </summary>


/// <summary>
/// I translate xbiso code into C#
/// So here is the all xdvdfs (xbox iso) format
/// directly to the xbox via ftp 
/// </summary>
namespace Xbgm.Xiso
{
using System;
using System.IO;
using System.Text;
using System.Data;
using System.Net;
using System.Net.Sockets;
using System.Collections;
using EnterpriseDT.Net.Ftp;

	class XisoInfoClass
	{
		// The dirent structure of a xiso
		public struct dirent
		{
		 public long	ltable;				//left entry
		 public long	rtable;				//right entry
		 public long	sector;				//sector of file
		 public long	size;				//size of file
		 public int		attribs;			//file attributes
		 public int		fnamelen;			//filename lenght
		 public string 	fname;				//filename
		 //public long	pad;				//padding (unused)
		}
 
		FileStream xisofs; //File Handling xiso
		StreamReader xisoReader; //Stream reader xiso

	/*	// TEST LIST TO FILE
		FileStream FileListWriter; //File Handling xiso
		StreamWriter xisoFileList; //Stream reader xiso
	*/
		public Int64 isosize = 0;
		public int Nbfiles = 0;
		public int Nbdir = 0;
		public string GameName = null;
		public string GameFolder = null;
		public int GameRegion = 0;
		
		string xisofilename = null;
				
		public bool xbe = false;
		
		// File/Dir list of the xiso BOOST MODE
		ArrayList FileDirlist = new ArrayList(); 

		public int GetNbFiles
		{
			get {return Nbfiles; }
		}

		public string FileName
		{
			get {return xisofilename; }
			set { xisofilename = value; }
		}


		#region infoxiso
		/// <summary>
		/// Start reading the xiso to count information on it.
		/// We don't write anything
		/// </summary>
		/// <param name="xisofile">Name of xbox iso</param>
		public void getfileiniso()
		{
			#if ( DEBUG)
				Console.WriteLine("Start of ISO information");
			#endif
	        xisofs  = new FileStream(xisofilename, FileMode.Open,
	                             FileAccess.Read);
	        // Create a character reader.
	        xisoReader = new StreamReader(xisofs);

	        // Set the StreamReader file pointer to the end.
	        xisoReader.BaseStream.Seek( 0x10000, SeekOrigin.Begin);
			byte[] bufheader = new byte[20];
			int size = xisoReader.BaseStream.Read(bufheader, 0, bufheader.Length);
			if(size != 0)
			{					
				string s = System.Text.Encoding.ASCII.GetString(bufheader, 0, 20);
				bufheader = null;
				if ((s.Equals("MICROSOFT*XBOX*MEDIA")) != true)
				{					 
					Console.WriteLine("Error file doesnt appear to be a xbox iso image.");
					return;
				}
				//Sector that root directory table resides in
				byte[] buf = new byte[4];
				size = xisoReader.BaseStream.Read(buf, 0, 4);
				long sectorroot = ((buf[3]<<24)+(buf[2]<<16)+(buf[1]<<8)+(buf[0]<< 0 ));
				#if ( DEBUG)
					Console.WriteLine("Sector root directory ["+ sectorroot + "]");
				#endif
				//Size of root directory table in bytes
				buf = new byte[4];
				size = xisoReader.BaseStream.Read(buf, 0, 4);
				int sizeroot = ((buf[3]<<24)+(buf[2]<<16)+(buf[1]<<8)+(buf[0]<< 0 ));
				#if ( DEBUG)
					Console.WriteLine("Size root directory ["+ sizeroot + "]");
				#endif
				//discard FILETIME structure representing image creation time
				xisoReader.BaseStream.Seek( 8, SeekOrigin.Current);
				//discard unused
				xisoReader.BaseStream.Seek( 0x7c8, SeekOrigin.Current);
				buf = new byte[20];
				size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
				s = System.Text.Encoding.ASCII.GetString(buf,0,buf.Length);
				if ((s.Equals("MICROSOFT*XBOX*MEDIA")) != true)
				{					 
					Console.WriteLine("Error possible corruption");
					return;
				}
				//Done With HEADER
				buf = null;
				s = null;
				countfileiniso(sectorroot*2048, (int)sectorroot);
			}
			isosize = (Int64)xisofs.Length;
			isosize = (isosize>>=20);
			#if ( DEBUG)
				Console.WriteLine("End of archive size:" +  isosize + " file:" + Nbfiles + " nbdir:" + Nbdir);
			#endif
			xisoReader.Close();
			xisofs.Close();
			xisoReader = null;
			xisofs = null;
			System.GC.Collect();
		// End extractiso
		}
		
		/// <summary>
		/// Go trought the xiso to count 
		/// numbers of files and 
		/// numbers of directory and size
		/// We don't write anything
		/// </summary>
		/// <param name="offset">the next position</param>
		/// <param name="dtable">the root directory offset</param>
		private void countfileiniso(Int64 offset, Int64 dtable)
		{
			dirent cur = new dirent();
			
			// Start from the beginning 
			xisoReader.BaseStream.Seek(offset, SeekOrigin.Begin);
			#if ( DEBUG)
				Console.WriteLine("Next Offset [" + offset + "]");
			#endif
				
			//time to fill the structure
			byte[] buf = new byte[2];
			//ltable offset from current
			int size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.ltable = ((buf[1]<<8) | (buf[0]));
			#if ( DEBUG)
				Console.WriteLine("ltable offset ["+ cur.ltable + "]");
			#endif
			
			//rtable offset from current
			size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.rtable = ((buf[1]<<8) | (buf[0]));	
			#if ( DEBUG)
				Console.WriteLine("rtable offset ["+ cur.rtable + "]");
			#endif
			
			buf = new byte[4];
			//sector of file
			size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.sector = ((buf[3]<<24) | (buf[2]<<16) | (buf[1]<<8) | buf[0]);
			#if ( DEBUG)
				Console.WriteLine("Sector of file ["+ cur.sector + "]");
			#endif
			//file size
			size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.size = ((buf[3]<<24) | (buf[2]<<16) | (buf[1]<<8) | buf[0]);
			#if ( DEBUG)
				Console.WriteLine("Size of file ["+ cur.size + "]");
			#endif

			buf = new byte[1];
			//file attributes
			size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.attribs = ((buf[0]<<0));
			#if ( DEBUG)
				Console.WriteLine("file attributes ["+ cur.attribs + "]");
			#endif
			//filename length
			size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.fnamelen = ((buf[0]<<0));
			#if ( DEBUG)
				Console.WriteLine("length of filename ["+ cur.fnamelen + "]");
			#endif
			
			// Filename
			buf = new byte[cur.fnamelen];
			size = xisoReader.BaseStream.Read(buf, 0, buf.Length);
			cur.fname = System.Text.Encoding.ASCII.GetString(buf, 0, cur.fnamelen);
			#if ( DEBUG)
				Console.WriteLine("Filename ["+ cur.fname + "]\n");
			#endif
			buf = null;
			if( (cur.attribs == 16)) // attribs is a DIR
				{
				/*	Console.WriteLine("Creating directory ["  + cur.fname + "]");
					// Create the directory 
					// Then get into it...
					Directory.CreateDirectory(cur.fname);
					Directory.SetCurrentDirectory(cur.fname);		
				*/	Nbdir++;
					// Call back handling
					countfileiniso((Int64)cur.sector*2048, (Int64)cur.sector);
				//	Directory.SetCurrentDirectory(@"..");
				}
			else
			{
				//So now we don't have to extract anything 
				// just counting or parse XBE
				// We don't need XBE info if we extract the iso on the HDD
				Nbfiles++;
				if (xbe == true)
					if (cur.fname.Equals("default.xbe") == true)
						ParseXBE(cur);
			}	
			
		    if(cur.rtable != 0)
		         countfileiniso(dtable*2048+(cur.rtable*4), dtable);
		    if (cur.ltable != 0)
		      	countfileiniso(dtable*2048+(cur.ltable*4), dtable);
		  //End handling
		}
		#endregion

		/// <summary>
		/// Parse xbe to get name and region
		/// Information at
		/// http://www.caustik.com/xbox/download/xbe.htm
		/// </summary>
		/// <param name="cur">dirent struct</param>
		private void ParseXBE(dirent cur)
		{
			// Go to the right place
			xisoReader.BaseStream.Seek(cur.sector*2048, SeekOrigin.Begin);

			// Create buffer
			int chunksize = (int) cur.size;
			byte[] chunk = new byte[chunksize];
			// read from stream iso 
			xisoReader.BaseStream.Read(chunk, 0, chunk.Length);
			
			// Write XBE file to memory
			MemoryStream temp = new MemoryStream(chunk.Length);
			temp.Write(chunk, 0, chunk.Length);
			
			// Go to the Certificate address Section
			temp.Seek( 0x0118, SeekOrigin.Begin);

			chunk = new byte[2];	
			temp.Read(chunk, 0, chunk.Length);
			int certoff = ((chunk[1]<<8) | chunk[0]);
			#if ( DEBUG )
				Console.WriteLine("certificate offset: [" + certoff + "]");
			#endif
			
			// Go to the Certificate address Section	
			temp.Seek(certoff, SeekOrigin.Begin);
			
			// Go to the Title Name Section
			temp.Seek( 0x000C, SeekOrigin.Current);
			
			// Read  Title name
			chunk = new byte[0x0050];
			temp.Read(chunk, 0, chunk.Length);
			// Fuck all encoding stuff
			// It was a big pain in the ass
			Encoding unicode = Encoding.Unicode;
			Encoding ascii = Encoding.ASCII;
			string unicodeString = unicode.GetString(chunk);
			byte[] unicodeBytes = unicode.GetBytes(unicodeString);
			byte[] asciiBytes = Encoding.Convert(unicode, ascii, unicodeBytes);
         	char[] asciiChars = new char[ascii.GetCharCount(asciiBytes, 0, asciiBytes.Length)];
			ascii.GetChars(asciiBytes, 0, asciiBytes.Length, asciiChars, 0);
			char[] goodasciiChars = new char[ascii.GetCharCount(asciiBytes, 0, asciiBytes.Length)];
			// Check for Punctuation (Xbox doesn't want it for directory)
			for(int i = 0; i < asciiChars.Length; i++)
			{
				if(Char.IsPunctuation(asciiChars[i]) == false)
					goodasciiChars[i] = asciiChars[i];
				else
					goodasciiChars[i] = ' ';
				#if ( DEBUG )
					Console.WriteLine(Char.IsPunctuation(asciiChars[i]) + "[" + asciiChars[i] + "]");
				#endif
			}
         	GameName = new string(asciiChars);
         	GameFolder = new string(goodasciiChars);
			// Clean up all temp var
			#if ( DEBUG )
				Console.WriteLine("Game Name: [" + GameName + "]");
			#endif
			
			// Go to the Certificate address Section	
			temp.Seek(certoff, SeekOrigin.Begin);
			
			// Go to the Title Region Section
			temp.Seek( 0x00A0, SeekOrigin.Current);
			
			// Read  Title Region
			chunk = new byte[2];
			temp.Read(chunk, 0, chunk.Length);
			GameRegion = ((chunk[1]<<8) | chunk[0]);
			#if ( DEBUG )
				Console.WriteLine("Game Region: [" + GameRegion + "]");
			#endif
			chunk = null;
			temp.Close();
			temp = null;
		}
	}
}
