/// <summary>
/// C# XBGM# Xbox Game Manager.
///  
/// Copyright (C) 2004  KaYa
/// 
/// 
/// This library is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// Bug fixes, suggestions and comments should be sent to xbgm@kayaweed.net
/// 
/// Change Log:
/// 
/// Revision 0.1  2004/07/27 KaYa
/// first release
///
/// </summary>

namespace Xbgm.Gui
{
using System;
using System.Collections;
using System.Data;
using System.Text;
using System.IO;
using Gtk;
using GtkSharp;

/// <summary>
/// Description of RenameDialog.	
/// </summary>
public class DeleteDialog
	{
		Dialog dialog;
		Gtk.RadioButton m_rdo1 = null;
		Gtk.RadioButton m_rdo2 = null;
		Gtk.RadioButton m_rdo3 = null;
		
		public DeleteDialog(string name) 
		{ 
			dialog = new Dialog ();
			dialog.Title = "Delete Game";
			dialog.BorderWidth = 3;
			dialog.VBox.BorderWidth = 5;
			dialog.HasSeparator = false;

			Frame frame = new Frame ("Delete Game");
			string image = Stock.DialogWarning;
			
			HBox hbox = new HBox (false, 2);
			hbox.BorderWidth = 5;
			hbox.PackStart (new Gtk.Image (image, IconSize.Dialog), true, true, 0);
		
			VBox vbox = new VBox (false, 4);
			hbox.PackStart (vbox);
			
			Label label = null;
			label = new Label ("Are you sure you want to delete " + name + " ?");
			
			vbox.PackStart (label, false, false, 2);			
			
    		m_rdo1 = new Gtk.RadioButton("Title");
    		m_rdo2 = new Gtk.RadioButton(m_rdo1, "Save files");
			m_rdo3 = new Gtk.RadioButton(m_rdo1, "Both");

    		vbox.PackStart (m_rdo1, false, false, 2);
    		vbox.PackStart (m_rdo2, false, false, 2);
			vbox.PackStart (m_rdo3, false, false, 2);
	
			frame.Add (hbox);

			dialog.VBox.PackStart (frame, true, true, 0);

			Button button = null;
			button = new Button (Stock.Ok);
			button.Clicked += new EventHandler (Connect_Action);
			button.CanDefault = true;
			dialog.ActionArea.PackStart (button, true, true, 0);
			button.GrabDefault ();

			button = new Button (Stock.Cancel);
			button.Clicked += new EventHandler (Dialog_Cancel);
			dialog.ActionArea.PackStart (button, true, true, 0);
			dialog.Modal = true;

			dialog.ShowAll ();
		}

		
		void Connect_Action (object o, EventArgs args) 
		{
			#if (DEBUG)
				Console.WriteLine("Delete Game");
			#endif
			dialog.Hide ();
		}

		void Dialog_Cancel (object o, EventArgs args) 
		{
			dialog.Hide ();
		}
		
		public int action
		{
			get { if(m_rdo1.Active){return 1;}
				  if(m_rdo2.Active){return 2;}
				  if(m_rdo3.Active){return 3;}
				  return 0;
				}
		}

		public void Run ()
		{
			dialog.Run();
		}
		
		public void Close()
		{
			dialog.Destroy();
		}
	}
}
